/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.ParseException;
import weblogic.jdbc.rowset.TableNameParser;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLSchemaReader;
import weblogic.jdbc.rowset.XMLSchemaWriter;
import weblogic.jdbc.rowset.XMLUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachedRowSetMetaData
implements WLRowSetMetaData,
Serializable,
XMLSchemaConstants,
Cloneable {
    private static final long serialVersionUID = -343025277802741983L;
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private int columnCount = 0;
    private boolean haveSetPKColumns = false;
    private int version = 2;
    private DatabaseMetaDataHolder databaseMetaData = null;
    private boolean isValidMetaData = false;
    private String writeTableName;
    private String rowName;
    private String rowSetName;
    private boolean isReadOnly = false;
    private String defaultNamespace = "http://www.openuri.org";
    private ColumnAttributes[] columnAttributes = null;
    private transient Map rowAttributes = new HashMap();
    private int optimisticPolicy = 1;
    private boolean batchInserts;
    private boolean batchDeletes;
    private boolean batchUpdates;
    private boolean groupDeletes;
    private int groupDeleteSize = 50;
    private int batchVerifySize = 50;
    private boolean verboseSQL;
    private String schemaLocation;
    ArrayList matchColumns = new ArrayList();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CachedRowSetMetaData)) {
            return false;
        }
        CachedRowSetMetaData cachedRowSetMetaData = (CachedRowSetMetaData)object;
        if (cachedRowSetMetaData.columnCount != this.columnCount) {
            return false;
        }
        if (cachedRowSetMetaData.haveSetPKColumns != this.haveSetPKColumns) {
            return false;
        }
        if (cachedRowSetMetaData.isValidMetaData != this.isValidMetaData) {
            return false;
        }
        if (!(cachedRowSetMetaData.databaseMetaData == this.databaseMetaData || cachedRowSetMetaData.databaseMetaData != null && cachedRowSetMetaData.databaseMetaData.equals(this.databaseMetaData))) {
            return false;
        }
        if (cachedRowSetMetaData.writeTableName != this.writeTableName && !cachedRowSetMetaData.writeTableName.equals(this.writeTableName)) {
            return false;
        }
        if (cachedRowSetMetaData.rowName != this.rowName && !cachedRowSetMetaData.rowName.equals(this.rowName)) {
            return false;
        }
        if (cachedRowSetMetaData.rowSetName != this.rowSetName && !cachedRowSetMetaData.rowSetName.equals(this.rowSetName)) {
            return false;
        }
        if (cachedRowSetMetaData.isReadOnly != this.isReadOnly) {
            return false;
        }
        if (cachedRowSetMetaData.defaultNamespace != this.defaultNamespace && !cachedRowSetMetaData.defaultNamespace.equals(this.defaultNamespace)) {
            return false;
        }
        if (!cachedRowSetMetaData.columnAttributes.equals(this.columnAttributes)) {
            if (cachedRowSetMetaData.columnAttributes.length != this.columnAttributes.length) {
                return false;
            }
            for (int i = 0; i < this.columnAttributes.length; ++i) {
                if (this.columnAttributes[i].equals(cachedRowSetMetaData.columnAttributes[i])) continue;
                return false;
            }
        }
        if (!((Object)cachedRowSetMetaData.rowAttributes).equals(this.rowAttributes)) {
            return false;
        }
        if (cachedRowSetMetaData.optimisticPolicy != this.optimisticPolicy) {
            return false;
        }
        if (cachedRowSetMetaData.batchInserts != this.batchInserts) {
            return false;
        }
        if (cachedRowSetMetaData.batchDeletes != this.batchDeletes) {
            return false;
        }
        if (cachedRowSetMetaData.batchUpdates != this.batchUpdates) {
            return false;
        }
        if (cachedRowSetMetaData.groupDeletes != this.groupDeletes) {
            return false;
        }
        if (cachedRowSetMetaData.groupDeleteSize != this.groupDeleteSize) {
            return false;
        }
        if (cachedRowSetMetaData.batchVerifySize != this.batchVerifySize) {
            return false;
        }
        if (cachedRowSetMetaData.verboseSQL != this.verboseSQL) {
            return false;
        }
        return cachedRowSetMetaData.schemaLocation == this.schemaLocation || cachedRowSetMetaData.schemaLocation.equals(this.schemaLocation);
    }

    protected Object clone() {
        CachedRowSetMetaData cachedRowSetMetaData = null;
        try {
            cachedRowSetMetaData = (CachedRowSetMetaData)super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
        if (this.columnAttributes == null) {
            cachedRowSetMetaData.columnAttributes = null;
        } else {
            cachedRowSetMetaData.columnAttributes = new ColumnAttributes[this.columnAttributes.length];
            for (int i = 0; i < this.columnAttributes.length; ++i) {
                if (this.columnAttributes[i] == null) continue;
                cachedRowSetMetaData.columnAttributes[i] = (ColumnAttributes)this.columnAttributes[i].clone();
            }
        }
        cachedRowSetMetaData.rowAttributes = this.rowAttributes == null ? null : (Map)((HashMap)this.rowAttributes).clone();
        return cachedRowSetMetaData;
    }

    public void initialize(ResultSetMetaData resultSetMetaData, DatabaseMetaData databaseMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.columnAttributes = new ColumnAttributes[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnAttributes[i] = new ColumnAttributes();
            this.columnAttributes[i].colName = resultSetMetaData.getColumnName(i + 1);
            try {
                this.columnAttributes[i].tableName = resultSetMetaData.getTableName(i + 1);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].tableName = "";
            }
            try {
                this.columnAttributes[i].catalogName = resultSetMetaData.getCatalogName(i + 1);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].catalogName = "";
            }
            this.columnAttributes[i].columnLabel = resultSetMetaData.getColumnLabel(i + 1);
            try {
                this.columnAttributes[i].schemaName = resultSetMetaData.getSchemaName(i + 1);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].schemaName = "";
            }
            this.columnAttributes[i].isAutoIncrement = resultSetMetaData.isAutoIncrement(i + 1);
            this.columnAttributes[i].isCaseSensitive = resultSetMetaData.isCaseSensitive(i + 1);
            this.columnAttributes[i].isCurrency = resultSetMetaData.isCurrency(i + 1);
            this.columnAttributes[i].isNullable = resultSetMetaData.isNullable(i + 1);
            try {
                this.columnAttributes[i].isReadOnly = resultSetMetaData.isReadOnly(i + 1);
            }
            catch (Exception exception) {
                this.columnAttributes[i].isReadOnly = false;
            }
            this.columnAttributes[i].isSearchable = resultSetMetaData.isSearchable(i + 1);
            this.columnAttributes[i].isSigned = resultSetMetaData.isSigned(i + 1);
            try {
                this.columnAttributes[i].isWritable = resultSetMetaData.isWritable(i + 1);
            }
            catch (Exception exception) {
                this.columnAttributes[i].isWritable = true;
            }
            this.columnAttributes[i].columnDisplaySize = resultSetMetaData.getColumnDisplaySize(i + 1);
            try {
                this.columnAttributes[i].isDefinitelyWritable = resultSetMetaData.isDefinitelyWritable(i + 1);
            }
            catch (Exception exception) {
                this.columnAttributes[i].isDefinitelyWritable = false;
            }
            try {
                this.columnAttributes[i].columnClassName = resultSetMetaData.getColumnClassName(i + 1);
            }
            catch (SQLException sQLException) {
                this.columnAttributes[i].columnClassName = "";
            }
            this.columnAttributes[i].columnTypeName = resultSetMetaData.getColumnTypeName(i + 1);
            this.columnAttributes[i].columnType = resultSetMetaData.getColumnType(i + 1);
            if (this.columnAttributes[i].columnType == -1 && this.columnAttributes[i].columnTypeName.equals("xml")) {
                this.columnAttributes[i].columnType = 2009;
            }
            if (this.columnAttributes[i].columnType == 93 && "DATE".equals(this.columnAttributes[i].columnTypeName)) {
                this.columnAttributes[i].columnType = 91;
            }
            if (!this.isNumericType(this.columnAttributes[i].columnType)) continue;
            this.columnAttributes[i].precision = resultSetMetaData.getPrecision(i + 1);
            this.columnAttributes[i].scale = resultSetMetaData.getScale(i + 1);
        }
        if (databaseMetaData == null) {
            this.databaseMetaData = null;
            this.isValidMetaData = false;
        } else {
            this.databaseMetaData = new DatabaseMetaDataHolder(databaseMetaData);
            this.isValidMetaData = true;
        }
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public int getVersion() {
        return this.version;
    }

    public void setMetaDataHolder(DatabaseMetaDataHolder databaseMetaDataHolder) {
        this.databaseMetaData = databaseMetaDataHolder;
        this.isValidMetaData = databaseMetaDataHolder != null;
    }

    public DatabaseMetaDataHolder getMetaDataHolder() {
        return this.databaseMetaData;
    }

    public boolean isValidMetaData() {
        return this.isValidMetaData;
    }

    public void addColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        int[] nArray = new int[resultSetMetaData.getColumnCount()];
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            nArray[i] = i + 1;
        }
        this.addColumns(resultSetMetaData, nArray);
    }

    public void addColumns(ResultSetMetaData resultSetMetaData, int[] nArray) throws SQLException {
        int n = nArray.length + this.columnCount;
        ColumnAttributes[] columnAttributesArray = new ColumnAttributes[n];
        System.arraycopy(this.columnAttributes, 0, columnAttributesArray, 0, this.columnAttributes.length);
        this.columnAttributes = columnAttributesArray;
        int n2 = 0;
        for (int i = this.columnCount; i < n; ++i) {
            this.columnAttributes[i] = new ColumnAttributes();
            this.columnAttributes[i].colName = resultSetMetaData.getColumnName(nArray[n2]);
            try {
                this.columnAttributes[i].tableName = resultSetMetaData.getTableName(nArray[n2]);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].tableName = "";
            }
            try {
                this.columnAttributes[i].catalogName = resultSetMetaData.getCatalogName(nArray[n2]);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].catalogName = "";
            }
            this.columnAttributes[i].columnLabel = resultSetMetaData.getColumnLabel(nArray[n2]);
            try {
                this.columnAttributes[i].schemaName = resultSetMetaData.getSchemaName(nArray[n2]);
            }
            catch (Throwable throwable) {
                this.columnAttributes[i].schemaName = "";
            }
            this.columnAttributes[i].isAutoIncrement = resultSetMetaData.isAutoIncrement(nArray[n2]);
            this.columnAttributes[i].isCaseSensitive = resultSetMetaData.isCaseSensitive(nArray[n2]);
            this.columnAttributes[i].isCurrency = resultSetMetaData.isCurrency(nArray[n2]);
            this.columnAttributes[i].isNullable = resultSetMetaData.isNullable(nArray[n2]);
            this.columnAttributes[i].isReadOnly = resultSetMetaData.isReadOnly(nArray[n2]);
            this.columnAttributes[i].isSearchable = resultSetMetaData.isSearchable(nArray[n2]);
            this.columnAttributes[i].isSigned = resultSetMetaData.isSigned(nArray[n2]);
            this.columnAttributes[i].isWritable = resultSetMetaData.isWritable(nArray[n2]);
            this.columnAttributes[i].columnDisplaySize = resultSetMetaData.getColumnDisplaySize(nArray[n2]);
            this.columnAttributes[i].isDefinitelyWritable = resultSetMetaData.isDefinitelyWritable(nArray[n2]);
            try {
                this.columnAttributes[i].columnClassName = resultSetMetaData.getColumnClassName(nArray[n2]);
            }
            catch (SQLException sQLException) {
                this.columnAttributes[i].columnClassName = "";
            }
            this.columnAttributes[i].columnTypeName = resultSetMetaData.getColumnTypeName(nArray[n2]);
            this.columnAttributes[i].columnType = resultSetMetaData.getColumnType(nArray[n2]);
            if (this.columnAttributes[i].columnType == 93 && "DATE".equals(this.columnAttributes[i].columnTypeName)) {
                this.columnAttributes[i].columnType = 91;
            }
            if (this.isNumericType(this.columnAttributes[i].columnType)) {
                this.columnAttributes[i].precision = resultSetMetaData.getPrecision(nArray[n2]);
                this.columnAttributes[i].scale = resultSetMetaData.getScale(nArray[n2]);
            }
            ++n2;
        }
        this.columnCount = n;
    }

    private boolean isNumericType(int n) {
        return n == -7 || n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 2 || n == 3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CachedRowSetMetaData] [" + System.identityHashCode(this) + "] ");
        stringBuffer.append("columnCount: " + this.columnCount + "\n");
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append(this.columnAttributes[i].toString());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    @Override
    public int getOptimisticPolicy() {
        return this.optimisticPolicy;
    }

    @Override
    public void setBatchInserts(boolean bl) {
        this.batchInserts = bl;
    }

    @Override
    public boolean getBatchInserts() {
        return this.batchInserts;
    }

    @Override
    public void setBatchDeletes(boolean bl) {
        this.batchDeletes = bl;
    }

    @Override
    public boolean getBatchDeletes() {
        return this.batchDeletes;
    }

    @Override
    public void setBatchUpdates(boolean bl) {
        this.batchUpdates = bl;
    }

    @Override
    public boolean getBatchUpdates() {
        return this.batchUpdates;
    }

    @Override
    public void setGroupDeletes(boolean bl) {
        this.groupDeletes = bl;
    }

    @Override
    public boolean getGroupDeletes() {
        return this.groupDeletes;
    }

    @Override
    public void setGroupDeleteSize(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("setGroupDeleteSize must be called  with a size > 0");
        }
        this.groupDeleteSize = n;
    }

    @Override
    public int getGroupDeleteSize() {
        return this.groupDeleteSize;
    }

    @Override
    public void setBatchVerifySize(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("setBatchVerifySize must be called  with a size > 0");
        }
        this.batchVerifySize = n;
    }

    @Override
    public int getBatchVerifySize() {
        return this.batchVerifySize;
    }

    @Override
    public void setOptimisticPolicyAsString(String string) throws SQLException {
        if ("VERIFY_READ_COLUMNS".equalsIgnoreCase(string) || "".equals(string)) {
            this.setOptimisticPolicy(1);
        } else if ("VERIFY_MODIFIED_COLUMNS".equalsIgnoreCase(string)) {
            this.setOptimisticPolicy(2);
        } else if ("VERIFY_SELECTED_COLUMNS".equalsIgnoreCase(string)) {
            this.setOptimisticPolicy(3);
        } else if ("VERIFY_NONE".equalsIgnoreCase(string)) {
            this.setOptimisticPolicy(4);
        } else if ("VERIFY_AUTO_VERSION_COLUMNS".equalsIgnoreCase(string)) {
            this.setOptimisticPolicy(5);
        } else if ("VERIFY_VERSION_COLUMNS".equalsIgnoreCase(string)) {
            this.setOptimisticPolicy(6);
        } else {
            throw new SQLException("Unexpected parameter to setOptimisticPolicyAsString: " + string + ".  The parameter " + "must be VERIFY_MODIFIED_COLUMNS, VERIFY_READ_COLUMNS," + " VERIFY_SELECTED_COLUMNS, VERIFY_NONE, VERIFY_AUTO_VERSION_COLUMNS," + " VERIFY_VERSION_COLUMNS");
        }
    }

    @Override
    public void setOptimisticPolicy(int n) throws SQLException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.optimisticPolicy = n;
                break;
            }
            default: {
                throw new SQLException("Unexpected parameter to setOptimisticPolicy: " + n + ".  The parameter " + "must be VERIFY_MODIFIED_COLUMNS, VERIFY_READ_COLUMNS," + " VERIFY_SELECTED_COLUMNS, VERIFY_NONE, VERIFY_AUTO_VERSION_COLUMNS," + " VERIFY_VERSION_COLUMNS");
            }
        }
    }

    @Override
    public String getOptimisticPolicyAsString() {
        switch (this.getOptimisticPolicy()) {
            case 1: {
                return "VERIFY_READ_COLUMNS";
            }
            case 2: {
                return "VERIFY_MODIFIED_COLUMNS";
            }
            case 3: {
                return "VERIFY_SELECTED_COLUMNS";
            }
            case 4: {
                return "VERIFY_NONE";
            }
            case 5: {
                return "VERIFY_AUTO_VERSION_COLUMNS";
            }
            case 6: {
                return "VERIFY_VERSION_COLUMNS";
            }
        }
        throw new AssertionError((Object)("Unexpected getOptimisticPolicy:" + this.getOptimisticPolicy()));
    }

    @Override
    public void setVerboseSQL(boolean bl) {
        this.verboseSQL = bl;
    }

    @Override
    public boolean getVerboseSQL() {
        return this.verboseSQL;
    }

    boolean claimSchema(String string) {
        if (this.rowSetName == null) {
            return true;
        }
        return this.rowSetName.equals(string);
    }

    void setXMLAttributes(int n, List list) {
        this.columnAttributes[n].setXMLAttributes(list);
    }

    void readXMLAttributes(int n, StartElement startElement) throws IOException {
        this.columnAttributes[n].readXMLAttributes(startElement);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (string != null) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!string.equalsIgnoreCase(this.columnAttributes[i].colName)) continue;
                return i + 1;
            }
        }
        throw new SQLException("There is no column named: " + string + " in this RowSet.");
    }

    private void checkColumn(int n) throws SQLException {
        if (this.columnCount == 0) {
            throw new SQLException("You should populate the RowSet with data or call setColumnCount before calling any other method onthe RowSetMetaData");
        }
        if (n == 0) {
            throw new SQLException("You have specified a column index of 0.  JDBC indexes begin with 1.");
        }
        if (n < 1 || n > this.columnCount) {
            throw new SQLException("There is no column: " + n + " in this RowSet.");
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    void setColumnCountInternal(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("Invalid column count: " + n);
        }
        this.columnCount = n;
        this.columnAttributes = new ColumnAttributes[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnAttributes[i] = new ColumnAttributes();
        }
    }

    @Override
    public void setColumnCount(int n) throws SQLException {
        if (this.columnCount != 0) {
            throw new SQLException("You cannot reset the columnCount of the RowSetMetaData to a new value.");
        }
        this.setColumnCountInternal(n);
    }

    @Override
    public void setColumnName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].colName = string;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].colName;
    }

    String getQualifiedColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].getQualifiedTableName() + "." + this.columnAttributes[n - 1].colName;
    }

    @Override
    public void setTableName(String string) throws SQLException {
        this.checkColumn(1);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string != null) {
            Object object;
            if (this.isValidMetaData) {
                object = new TableNameParser(string, this.databaseMetaData);
                String[] stringArray = ((TableNameParser)object).parse();
                string2 = stringArray[0];
                string3 = stringArray[1];
                string4 = stringArray[2];
            } else {
                object = new StringTokenizer(string, ".");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = string3;
                    string3 = string4;
                    string4 = ((StringTokenizer)object).nextToken();
                }
            }
        }
        for (int i = 0; i < this.columnAttributes.length; ++i) {
            this.columnAttributes[i].setTableName(string2, string3, string4);
        }
    }

    @Override
    public void setTableName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].setTableName(string);
    }

    @Override
    public void setTableName(String string, String string2) throws SQLException {
        this.setTableName(this.findColumn(string), string2);
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].tableName;
    }

    @Override
    public String getQualifiedTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].getQualifiedTableName();
    }

    @Override
    public String getQualifiedTableName(String string) throws SQLException {
        return this.getQualifiedTableName(this.findColumn(string));
    }

    public void setMatchColumns(int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.setMatchColumn(nArray[i], true);
        }
    }

    public int[] getMatchColumns() throws SQLException {
        int[] nArray = new int[this.matchColumns.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.matchColumns.get(i);
        }
        return nArray;
    }

    public void setMatchColumn(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        int n2 = this.matchColumns.indexOf(new Integer(n));
        if (bl) {
            if (n2 == -1) {
                this.matchColumns.add(new Integer(n));
            }
        } else if (n2 != -1) {
            this.matchColumns.remove(n2);
        }
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        int n;
        for (n = 0; n < this.columnCount; ++n) {
            this.columnAttributes[n].isPrimaryKeyColumn = false;
        }
        for (n = 0; n < nArray.length; ++n) {
            this.setPrimaryKeyColumn(nArray[n], true);
        }
    }

    public int[] getKeyColumns() throws SQLException {
        int[] nArray = new int[this.columnCount];
        int n = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.columnAttributes[i].isPrimaryKeyColumn) continue;
            nArray[n++] = i + 1;
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    @Override
    public void setPrimaryKeyColumn(String string, boolean bl) throws SQLException {
        this.setPrimaryKeyColumn(this.findColumn(string), bl);
    }

    @Override
    public void setPrimaryKeyColumn(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        if (bl) {
            this.haveSetPKColumns = true;
            this.columnAttributes[n - 1].isReadOnly = true;
        }
        this.columnAttributes[n - 1].isPrimaryKeyColumn = bl;
    }

    @Override
    public boolean isPrimaryKeyColumn(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isPrimaryKeyColumn;
    }

    @Override
    public boolean isPrimaryKeyColumn(String string) throws SQLException {
        return this.isPrimaryKeyColumn(this.findColumn(string));
    }

    @Override
    public boolean haveSetPKColumns() {
        if (this.haveSetPKColumns) {
            return true;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.columnAttributes[i].isPrimaryKeyColumn) continue;
            this.haveSetPKColumns = true;
            return true;
        }
        return false;
    }

    @Override
    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isAutoIncrement = bl;
        this.setReadOnly(n, bl);
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isAutoIncrement;
    }

    @Override
    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isCaseSensitive = bl;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isCaseSensitive;
    }

    @Override
    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isSearchable = bl;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isSearchable;
    }

    @Override
    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isCurrency = bl;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isCurrency;
    }

    @Override
    public void setNullable(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isNullable = n2;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isNullable;
    }

    @Override
    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isSigned = bl;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isSigned;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].catalogName;
    }

    @Override
    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].catalogName = string != null ? string : "";
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].columnDisplaySize;
    }

    @Override
    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].columnDisplaySize = n2;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].columnLabel;
    }

    @Override
    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].columnLabel = string;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].schemaName;
    }

    @Override
    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].schemaName = string;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].columnType;
    }

    @Override
    public void setColumnType(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].columnType = n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].columnTypeName;
    }

    @Override
    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].columnTypeName = string;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].precision;
    }

    @Override
    public void setPrecision(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].precision = n2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].scale;
    }

    @Override
    public void setScale(int n, int n2) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].scale = n2;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnAttributes[i].isReadOnly = bl;
        }
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        if (this.isReadOnly) {
            return true;
        }
        return this.columnAttributes[n - 1].isReadOnly;
    }

    @Override
    public boolean isReadOnly(String string) throws SQLException {
        return this.isReadOnly(this.findColumn(string));
    }

    @Override
    public void setReadOnly(String string, boolean bl) throws SQLException {
        this.setReadOnly(this.findColumn(string), bl);
    }

    @Override
    public void setReadOnly(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isReadOnly = bl;
    }

    @Override
    public void setVerifySelectedColumn(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isSelectedColumn = bl;
    }

    boolean hasSelectedColumn() throws SQLException {
        for (int i = 0; i < this.columnAttributes.length; ++i) {
            if (!this.columnAttributes[i].isSelectedColumn) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSelectedColumn(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isSelectedColumn;
    }

    @Override
    public void setVerifySelectedColumn(String string, boolean bl) throws SQLException {
        this.setVerifySelectedColumn(this.findColumn(string), bl);
    }

    @Override
    public boolean isSelectedColumn(String string) throws SQLException {
        return this.isSelectedColumn(this.findColumn(string));
    }

    @Override
    public void setAutoVersionColumn(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isAutoVersionColumn = bl;
    }

    @Override
    public boolean isAutoVersionColumn(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isAutoVersionColumn;
    }

    @Override
    public void setAutoVersionColumn(String string, boolean bl) throws SQLException {
        this.setAutoVersionColumn(this.findColumn(string), bl);
    }

    @Override
    public boolean isAutoVersionColumn(String string) throws SQLException {
        return this.isAutoVersionColumn(this.findColumn(string));
    }

    @Override
    public void setVersionColumn(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isVersionColumn = bl;
    }

    @Override
    public boolean isVersionColumn(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isVersionColumn;
    }

    @Override
    public void setVersionColumn(String string, boolean bl) throws SQLException {
        this.setVersionColumn(this.findColumn(string), bl);
    }

    @Override
    public boolean isVersionColumn(String string) throws SQLException {
        return this.isVersionColumn(this.findColumn(string));
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isWritable;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].isDefinitelyWritable;
    }

    public void setDefinitelyWritable(int n, boolean bl) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].isDefinitelyWritable = bl;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columnAttributes[n - 1].columnClassName;
    }

    public void setColumnClassName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].columnClassName = string;
    }

    @Override
    public String getWriteColumnName(int n) throws SQLException {
        this.checkColumn(n);
        if (this.columnAttributes[n - 1].writeColumnName != null) {
            return this.columnAttributes[n - 1].writeColumnName;
        }
        return this.columnAttributes[n - 1].colName;
    }

    @Override
    public String getWriteColumnName(String string) throws SQLException {
        return this.getWriteColumnName(this.findColumn(string));
    }

    @Override
    public void setWriteColumnName(int n, String string) throws SQLException {
        this.checkColumn(n);
        this.columnAttributes[n - 1].writeColumnName = string;
    }

    @Override
    public void setWriteColumnName(String string, String string2) throws SQLException {
        this.setWriteColumnName(this.findColumn(string), string2);
    }

    @Override
    public String getWriteTableName() {
        return this.writeTableName;
    }

    private boolean seq(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public void setWriteTableName(String string) throws SQLException {
        this.writeTableName = string;
        if (string == null) {
            return;
        }
        if (this.isValidMetaData) {
            TableNameParser tableNameParser = new TableNameParser(this.writeTableName, this.databaseMetaData);
            String[] stringArray = tableNameParser.parse();
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnAttributes columnAttributes = this.columnAttributes[i];
                if (tableNameParser.identifierEqual(columnAttributes.tableName, stringArray[2]) && tableNameParser.identifierEqual(columnAttributes.schemaName, stringArray[1]) && tableNameParser.identifierEqual(columnAttributes.catalogName, stringArray[0])) continue;
                columnAttributes.isReadOnly = true;
            }
        } else {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string3;
                string3 = string4;
                string4 = stringTokenizer.nextToken();
            }
            for (int i = 0; i < this.columnCount; ++i) {
                ColumnAttributes columnAttributes = this.columnAttributes[i];
                if (this.seq(columnAttributes.tableName, string4) && ("".equals(string3) || this.seq(columnAttributes.schemaName, string3)) && ("".equals(string2) || this.seq(columnAttributes.catalogName, string2))) continue;
                columnAttributes.isReadOnly = true;
            }
        }
    }

    @Override
    public void markUpdateProperties(String string, String string2, String string3) throws SQLException {
        this.setTableName(string);
        this.setWriteTableName(string);
        this.setPrimaryKeyColumn(this.findColumn(string2), true);
        this.setOptimisticPolicy(6);
        this.setVersionColumn(this.findColumn(string3), true);
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    @Override
    public String getRowName() {
        if (this.rowName == null) {
            if (this.writeTableName != null) {
                return this.writeTableName + "Row";
            }
            return "TableRow";
        }
        return this.rowName;
    }

    @Override
    public void setRowName(String string) {
        this.rowName = string;
    }

    @Override
    public String getRowSetName() {
        if (this.rowSetName == null) {
            return this.getRowName() + "Set";
        }
        return this.rowSetName;
    }

    @Override
    public void setRowSetName(String string) {
        this.rowSetName = string;
    }

    @Override
    public void writeXMLSchema(XMLOutputStream xMLOutputStream) throws IOException, SQLException {
        XMLSchemaWriter xMLSchemaWriter = new XMLSchemaWriter(this);
        xMLSchemaWriter.writeSchema(xMLOutputStream);
    }

    @Override
    public void loadXMLSchema(XMLInputStream xMLInputStream) throws IOException, SQLException {
        XMLSchemaReader xMLSchemaReader = new XMLSchemaReader(this);
        xMLSchemaReader.loadSchema(xMLInputStream);
    }

    @Override
    public String getXMLSchemaLocation() {
        if (this.schemaLocation == null) {
            return this.getDefaultNamespace() + "/" + this.getRowSetName() + ".xsd";
        }
        return this.schemaLocation;
    }

    @Override
    public void setXMLSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    private XMLName getName(String string, String string2) {
        return ElementFactory.createXMLName((String)string, (String)"", (String)string2);
    }

    @Override
    public Properties getRowAttributes(String string, String string2) {
        return (Properties)this.rowAttributes.get(this.getName(string, string2));
    }

    @Override
    public Map getAllRowAttributes() {
        return this.rowAttributes;
    }

    void readRowAttributes(StartElement startElement) throws IOException, SQLException {
        this.rowAttributes = XMLUtils.readPropertyMapFromAttributes(startElement);
    }

    @Override
    public Properties setRowAttributes(String string, String string2, Properties properties) throws SQLException {
        if ("http://www.w3.org/2001/XMLSchema".equals(string) || "http://www.bea.com/2002/10/weblogicdata".equals(string)) {
            throw new SQLException("namespace parameter " + string + " cannot be reserved namespaces: " + "http://www.bea.com/2002/10/weblogicdata" + " or " + "http://www.w3.org/2001/XMLSchema");
        }
        return this.rowAttributes.put(this.getName(string, string2), properties);
    }

    @Override
    public Properties getColAttributes(String string, String string2, String string3) throws SQLException {
        return this.getColAttributes(string, string2, this.findColumn(string3));
    }

    @Override
    public Properties getColAttributes(String string, String string2, int n) throws SQLException {
        this.checkColumn(n);
        Map map = this.columnAttributes[n - 1].attributes;
        if (map == null) {
            return null;
        }
        return (Properties)map.get(this.getName(string, string2));
    }

    @Override
    public Map getAllColAttributes(String string) throws SQLException {
        return this.getAllColAttributes(this.findColumn(string));
    }

    @Override
    public Map getAllColAttributes(int n) throws SQLException {
        this.checkColumn(n);
        if (this.columnAttributes[n - 1].attributes == null) {
            return Collections.EMPTY_MAP;
        }
        return this.columnAttributes[n - 1].attributes;
    }

    @Override
    public Properties setColAttributes(String string, String string2, int n, Properties properties) throws SQLException {
        if ("http://www.w3.org/2001/XMLSchema".equals(string) || "http://www.bea.com/2002/10/weblogicdata".equals(string)) {
            throw new SQLException("namespace parameter " + string + " cannot be reserved namespaces: " + "http://www.bea.com/2002/10/weblogicdata" + " or " + "http://www.w3.org/2001/XMLSchema");
        }
        this.checkColumn(n);
        HashMap<XMLName, Properties> hashMap = this.columnAttributes[n - 1].attributes;
        if (hashMap == null) {
            this.columnAttributes[n - 1].attributes = hashMap = new HashMap<XMLName, Properties>();
        }
        return hashMap.put(this.getName(string, string2), properties);
    }

    @Override
    public Properties setColAttributes(String string, String string2, String string3, Properties properties) throws SQLException {
        return this.setColAttributes(string, string2, this.findColumn(string3), properties);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.defaultNamespace = "http://www.openuri.org";
        this.groupDeletes = true;
        this.groupDeleteSize = 50;
        this.batchVerifySize = 50;
        this.rowAttributes = new HashMap();
        objectInputStream.defaultReadObject();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    final class ColumnAttributes
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3162667379829885159L;
        String colName;
        String writeColumnName;
        String tableName;
        String catalogName;
        String columnClassName;
        String columnLabel;
        String schemaName;
        String columnTypeName;
        transient Map attributes;
        boolean isAutoIncrement = false;
        boolean isCaseSensitive = false;
        boolean isCurrency = false;
        boolean isDefinitelyWritable = false;
        boolean isPrimaryKeyColumn = false;
        boolean isReadOnly = false;
        boolean isWritable = true;
        boolean isSearchable = true;
        boolean isSigned = false;
        boolean isAutoVersionColumn = false;
        boolean isVersionColumn = false;
        boolean isSelectedColumn = false;
        int isNullable;
        int columnDisplaySize;
        int columnType;
        int precision;
        int scale;

        ColumnAttributes() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            ColumnAttributes columnAttributes = (ColumnAttributes)object;
            if (columnAttributes.colName != this.colName) {
                return false;
            }
            if (columnAttributes.writeColumnName != this.writeColumnName) {
                return false;
            }
            if (columnAttributes.tableName != this.tableName) {
                return false;
            }
            if (columnAttributes.catalogName != this.catalogName) {
                return false;
            }
            if (columnAttributes.columnClassName != this.columnClassName) {
                return false;
            }
            if (columnAttributes.columnLabel != this.columnLabel) {
                return false;
            }
            if (columnAttributes.schemaName != this.schemaName) {
                return false;
            }
            if (columnAttributes.columnTypeName != this.columnTypeName) {
                return false;
            }
            if (columnAttributes.attributes != this.attributes) {
                return false;
            }
            if (columnAttributes.isAutoIncrement != this.isAutoIncrement) {
                return false;
            }
            if (columnAttributes.isCaseSensitive != this.isCaseSensitive) {
                return false;
            }
            if (columnAttributes.isCurrency != this.isCurrency) {
                return false;
            }
            if (columnAttributes.isDefinitelyWritable != this.isDefinitelyWritable) {
                return false;
            }
            if (columnAttributes.isPrimaryKeyColumn != this.isPrimaryKeyColumn) {
                return false;
            }
            if (columnAttributes.isReadOnly != this.isReadOnly) {
                return false;
            }
            if (columnAttributes.isWritable != this.isWritable) {
                return false;
            }
            if (columnAttributes.isSearchable != this.isSearchable) {
                return false;
            }
            if (columnAttributes.isSigned != this.isSigned) {
                return false;
            }
            if (columnAttributes.isAutoVersionColumn != this.isAutoVersionColumn) {
                return false;
            }
            if (columnAttributes.isVersionColumn != this.isVersionColumn) {
                return false;
            }
            if (columnAttributes.isSelectedColumn != this.isSelectedColumn) {
                return false;
            }
            if (columnAttributes.isNullable != this.isNullable) {
                return false;
            }
            if (columnAttributes.columnDisplaySize != this.columnDisplaySize) {
                return false;
            }
            if (columnAttributes.columnType != this.columnType) {
                return false;
            }
            if (columnAttributes.precision != this.precision) {
                return false;
            }
            return columnAttributes.scale == this.scale;
        }

        private Attribute getAttr(XMLName xMLName, String string) {
            return ElementFactory.createAttribute((XMLName)xMLName, (String)string);
        }

        protected Object clone() {
            ColumnAttributes columnAttributes = null;
            try {
                columnAttributes = (ColumnAttributes)super.clone();
            }
            catch (Throwable throwable) {
                return null;
            }
            if (this.attributes != null) {
                columnAttributes.attributes = (Map)((HashMap)this.attributes).clone();
            }
            return columnAttributes;
        }

        public void setXMLAttributes(List list) {
            if (this.isAutoIncrement) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_AUTO, "true"));
            }
            if (this.isPrimaryKeyColumn) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_PK, "true"));
            }
            if (this.isReadOnly) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_READONLY, "true"));
            }
            if (this.isAutoVersionColumn) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_AUTO_VERSION, "true"));
            }
            if (this.isDefinitelyWritable) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_DEFINITELY_WRITABLE, "true"));
            }
            if (this.isVersionColumn) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_VERSION, "true"));
            }
            if (this.isSelectedColumn) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_SELECTED, "true"));
            }
            if (this.writeColumnName != null) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_WRITECOL, this.writeColumnName));
            }
            if (this.tableName != null && !"".equals(this.tableName)) {
                list.add(this.getAttr(XMLSchemaConstants.WLDD_TABLE_NAME, this.getQualifiedTableName()));
            }
            if (this.isNullable != 0) {
                list.add(XMLSchemaConstants.NIL_ATTR);
            }
            if (this.attributes != null) {
                XMLUtils.addAttributesFromPropertyMap(list, this.attributes);
            }
        }

        public void readXMLAttributes(StartElement startElement) throws IOException {
            this.colName = XMLUtils.getRequiredAttribute(startElement, "name").getValue();
            this.isAutoIncrement = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_AUTO);
            this.isDefinitelyWritable = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_DEFINITELY_WRITABLE);
            this.isPrimaryKeyColumn = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_PK);
            this.isReadOnly = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_READONLY);
            this.isAutoVersionColumn = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_AUTO_VERSION);
            this.isVersionColumn = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_VERSION);
            this.isSelectedColumn = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.WLDD_SELECTED);
            this.writeColumnName = XMLUtils.getOptionalStringAttribute(startElement, XMLSchemaConstants.WLDD_WRITECOL);
            String string = XMLUtils.getOptionalStringAttribute(startElement, XMLSchemaConstants.WLDD_TABLE_NAME);
            this.setTableName(string);
            String string2 = XMLUtils.getRequiredAttribute(startElement, "type").getValue();
            String string3 = XMLUtils.getOptionalStringAttribute(startElement, XMLSchemaConstants.WLDD_JDBC_TYPE);
            if (string3 == null) {
                this.columnType = TypeMapper.getDbType(string2);
                this.columnTypeName = TypeMapper.getJDBCTypeAsString(this.columnType);
            } else {
                this.columnTypeName = string3;
                this.columnType = TypeMapper.getJDBCTypeFromString(this.columnTypeName);
            }
            this.isNullable = XMLUtils.getOptionalBooleanAttribute(startElement, XMLSchemaConstants.NILLABLE_NAME) ? 1 : 0;
            this.attributes = XMLUtils.readPropertyMapFromAttributes(startElement);
        }

        String getQualifiedTableName() {
            StringBuffer stringBuffer = new StringBuffer();
            if (CachedRowSetMetaData.this.isValidMetaData) {
                String string;
                stringBuffer.append(this.tableName);
                if (CachedRowSetMetaData.this.databaseMetaData.supportsSchemasInDataManipulation() && this.schemaName != null && !"".equals(this.schemaName)) {
                    stringBuffer.insert(0, ".").insert(0, this.schemaName);
                }
                if (CachedRowSetMetaData.this.databaseMetaData.supportsCatalogsInDataManipulation() && this.catalogName != null && !"".equals(this.catalogName) && (string = CachedRowSetMetaData.this.databaseMetaData.getCatalogSeparator()) != null && !"".equals(string)) {
                    if (CachedRowSetMetaData.this.databaseMetaData.isCatalogAtStart()) {
                        stringBuffer.insert(0, string).insert(0, this.catalogName);
                    } else {
                        stringBuffer.append(string).append(this.catalogName);
                    }
                }
            } else {
                if (this.catalogName != null && !"".equals(this.catalogName)) {
                    stringBuffer.append(this.catalogName).append(".");
                }
                if (this.schemaName != null && !"".equals(this.schemaName)) {
                    stringBuffer.append(this.schemaName).append(".");
                }
                stringBuffer.append(this.tableName);
            }
            return stringBuffer.toString();
        }

        void setTableName(String string) {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (string != null) {
                if (CachedRowSetMetaData.this.isValidMetaData) {
                    try {
                        TableNameParser tableNameParser = new TableNameParser(string, CachedRowSetMetaData.this.databaseMetaData);
                        String[] stringArray = tableNameParser.parse();
                        string2 = stringArray[0];
                        string3 = stringArray[1];
                        string4 = stringArray[2];
                    }
                    catch (ParseException parseException) {}
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = string3;
                        string3 = string4;
                        string4 = stringTokenizer.nextToken();
                    }
                }
            }
            this.setTableName(string2, string3, string4);
        }

        void setTableName(String string, String string2, String string3) {
            this.catalogName = string != null ? string : "";
            this.schemaName = string2 != null ? string2 : "";
            this.tableName = string3;
        }

        public String toString() {
            return "colName=" + this.colName + ", tableName=" + this.tableName + ", catalogName=" + this.catalogName + ", columnClassName=" + this.columnClassName + ", columnLabel=" + this.columnLabel + ", schemaName=" + this.schemaName + ", columnTypeName=" + this.columnTypeName + ", isAutoIncrement=" + this.isAutoIncrement + ", isCaseSensitive=" + this.isCaseSensitive + ", isCurrency=" + this.isCurrency + ", isDefinitelyWritable=" + this.isDefinitelyWritable + ", isPrimaryKeyColumn=" + this.isPrimaryKeyColumn + ", isReadOnly=" + this.isReadOnly + ", isWritable=" + this.isWritable + ", isSearchable=" + this.isSearchable + ", isSigned=" + this.isSigned + ", isNullable=" + this.isNullable + ", columnDisplaySize=" + this.columnDisplaySize + ", columnType=" + this.columnType + ", precision=" + this.precision + ", scale=" + this.scale;
        }
    }
}

