/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

final class DatabaseMetaDataHolder
implements Serializable {
    private static final long serialVersionUID = -3120626766920233516L;
    private int maxCatalogNameLength = 0;
    private int maxSchemaNameLength = 30;
    private int maxTableNameLength = 30;
    private String identifierQuoteString = "\"";
    private String catalogSeparator = "";
    private boolean isCatalogAtStart = false;
    private boolean supportsSchemasInDataManipulation = true;
    private boolean supportsCatalogsInDataManipulation = false;
    private boolean storesUpperCaseIdentifiers = true;
    private boolean storesLowerCaseIdentifiers = false;
    private boolean storesMixedCaseIdentifiers = false;
    private boolean storesUpperCaseQuotedIdentifiers = false;
    private boolean storesLowerCaseQuotedIdentifiers = false;
    private boolean storesMixedCaseQuotedIdentifiers = true;

    DatabaseMetaDataHolder(DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData == null) {
            throw new SQLException("Invalid parameter, can't initialize DatabaseMetaDataHolder.");
        }
        this.maxCatalogNameLength = databaseMetaData.getMaxCatalogNameLength();
        this.maxSchemaNameLength = databaseMetaData.getMaxSchemaNameLength();
        this.maxTableNameLength = databaseMetaData.getMaxTableNameLength();
        this.identifierQuoteString = databaseMetaData.getIdentifierQuoteString();
        this.catalogSeparator = databaseMetaData.getCatalogSeparator();
        this.isCatalogAtStart = databaseMetaData.isCatalogAtStart();
        this.supportsSchemasInDataManipulation = databaseMetaData.supportsSchemasInDataManipulation();
        this.supportsCatalogsInDataManipulation = databaseMetaData.supportsCatalogsInDataManipulation();
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        this.storesLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesMixedCaseIdentifiers = databaseMetaData.storesMixedCaseIdentifiers();
        this.storesUpperCaseQuotedIdentifiers = databaseMetaData.storesUpperCaseQuotedIdentifiers();
        this.storesLowerCaseQuotedIdentifiers = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        this.storesMixedCaseQuotedIdentifiers = databaseMetaData.storesMixedCaseQuotedIdentifiers();
    }

    DatabaseMetaDataHolder(int n, int n2, int n3, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.maxCatalogNameLength = n;
        this.maxSchemaNameLength = n2;
        this.maxTableNameLength = n2;
        this.identifierQuoteString = string;
        this.catalogSeparator = string2;
        this.isCatalogAtStart = bl;
        this.supportsSchemasInDataManipulation = bl2;
        this.supportsCatalogsInDataManipulation = bl3;
        this.storesUpperCaseIdentifiers = bl4;
        this.storesLowerCaseIdentifiers = bl5;
        this.storesMixedCaseIdentifiers = bl6;
        this.storesUpperCaseQuotedIdentifiers = bl7;
        this.storesLowerCaseQuotedIdentifiers = bl8;
        this.storesMixedCaseQuotedIdentifiers = bl9;
    }

    int getMaxCatalogNameLength() {
        return this.maxCatalogNameLength;
    }

    int getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    boolean supportsCatalogsInDataManipulation() {
        return this.supportsCatalogsInDataManipulation;
    }

    boolean supportsSchemasInDataManipulation() {
        return this.supportsSchemasInDataManipulation;
    }

    boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    boolean storesLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    boolean storesMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers;
    }

    boolean storesUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    boolean storesLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    boolean storesMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers;
    }

    boolean supportsIdentifierQuoting() {
        return !this.identifierQuoteString.equals(" ");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DatabaseMetaDataHolder)) {
            return false;
        }
        DatabaseMetaDataHolder databaseMetaDataHolder = (DatabaseMetaDataHolder)object;
        return this.maxCatalogNameLength == databaseMetaDataHolder.maxCatalogNameLength && this.maxSchemaNameLength == databaseMetaDataHolder.maxSchemaNameLength && this.maxTableNameLength == databaseMetaDataHolder.maxTableNameLength && this.identifierQuoteString.equals(databaseMetaDataHolder.identifierQuoteString) && this.catalogSeparator.equals(databaseMetaDataHolder.catalogSeparator) && this.isCatalogAtStart == databaseMetaDataHolder.isCatalogAtStart && this.supportsSchemasInDataManipulation == databaseMetaDataHolder.supportsSchemasInDataManipulation && this.supportsCatalogsInDataManipulation == databaseMetaDataHolder.supportsCatalogsInDataManipulation && this.storesUpperCaseIdentifiers == databaseMetaDataHolder.storesUpperCaseIdentifiers && this.storesLowerCaseIdentifiers == databaseMetaDataHolder.storesLowerCaseIdentifiers && this.storesMixedCaseIdentifiers == databaseMetaDataHolder.storesMixedCaseIdentifiers && this.storesUpperCaseQuotedIdentifiers == databaseMetaDataHolder.storesUpperCaseQuotedIdentifiers && this.storesLowerCaseQuotedIdentifiers == databaseMetaDataHolder.storesLowerCaseQuotedIdentifiers && this.storesMixedCaseQuotedIdentifiers == databaseMetaDataHolder.storesMixedCaseQuotedIdentifiers;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.maxCatalogNameLength;
        n = 37 * n + this.maxSchemaNameLength;
        n = 37 * n + this.maxTableNameLength;
        n = 37 * n + (this.identifierQuoteString == null ? 0 : this.identifierQuoteString.hashCode());
        n = 37 * n + (this.catalogSeparator == null ? 0 : this.catalogSeparator.hashCode());
        n = 37 * n + (this.isCatalogAtStart ? 0 : 1);
        n = 37 * n + (this.supportsSchemasInDataManipulation ? 0 : 1);
        n = 37 * n + (this.supportsCatalogsInDataManipulation ? 0 : 1);
        n = 37 * n + (this.storesUpperCaseIdentifiers ? 0 : 1);
        n = 37 * n + (this.storesLowerCaseIdentifiers ? 0 : 1);
        n = 37 * n + (this.storesMixedCaseIdentifiers ? 0 : 1);
        n = 37 * n + (this.storesUpperCaseQuotedIdentifiers ? 0 : 1);
        n = 37 * n + (this.storesLowerCaseQuotedIdentifiers ? 0 : 1);
        n = 37 * n + (this.storesMixedCaseQuotedIdentifiers ? 0 : 1);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("maxCatalogNameLength=" + this.maxCatalogNameLength).append(",");
        stringBuffer.append("maxSchemaNameLength=" + this.maxSchemaNameLength).append(",");
        stringBuffer.append("maxTableNameLength=" + this.maxTableNameLength).append(",");
        stringBuffer.append("identifierQuoteString=" + this.identifierQuoteString).append(",");
        stringBuffer.append("catalogSeparator=" + this.catalogSeparator).append(",");
        stringBuffer.append("isCatalogAtStart=" + this.isCatalogAtStart).append(",");
        stringBuffer.append("supportsSchemasInDataManipulation=" + this.supportsSchemasInDataManipulation).append(",");
        stringBuffer.append("supportsCatalogsInDataManipulation=" + this.supportsCatalogsInDataManipulation).append(",");
        stringBuffer.append("storesUpperCaseIdentifiers=" + this.storesUpperCaseIdentifiers).append(",");
        stringBuffer.append("storesLowerCaseIdentifiers=" + this.storesLowerCaseIdentifiers).append(",");
        stringBuffer.append("storesMixedCaseIdentifiers=" + this.storesMixedCaseIdentifiers).append(",");
        stringBuffer.append("storesUpperCaseQuotedIdentifiers=" + this.storesUpperCaseQuotedIdentifiers).append(",");
        stringBuffer.append("storesLowerCaseQuotedIdentifiers=" + this.storesLowerCaseQuotedIdentifiers).append(",");
        stringBuffer.append("storesMixedCaseQuotedIdentifiers=" + this.storesMixedCaseQuotedIdentifiers);
        return stringBuffer.toString();
    }
}

