/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.LifeCycle;
import weblogic.jdbc.rowset.RowSetBlob;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.RowSetNClob;
import weblogic.jdbc.rowset.WLParameter;
import weblogic.utils.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRowSetImpl
implements JdbcRowSet {
    String url;
    String userName;
    String password;
    String dataSourceName;
    boolean preferDataSource;
    transient DataSource dataSource;
    transient Connection cachedConnection;
    String command;
    transient ArrayList<WLParameter> params = new ArrayList();
    int isolationLevel = -1;
    int fetchDirection;
    int fetchSize;
    int concurrency = 1008;
    int resultSetType = 1004;
    Map<String, Class<?>> typeMap;
    int queryTimeout;
    int maxRows;
    int maxFieldSize;
    boolean escapeProcessing;
    boolean showDeleted;
    boolean isComplete;
    boolean wasNull;
    private Connection conn = null;
    private CallableStatement cstmt = null;
    private ResultSet rs = null;
    CachedRowSetMetaData metaData = null;
    LifeCycle.State state = LifeCycle.DESIGNING;
    List<RowSetListener> rowSetListeners = new ArrayList<RowSetListener>();

    public JdbcRowSetImpl() {
    }

    public JdbcRowSetImpl(Connection connection) {
        throw new RuntimeException("Method not implemented");
    }

    public JdbcRowSetImpl(ResultSet resultSet) {
        throw new RuntimeException("Method not implemented");
    }

    public JdbcRowSetImpl(String string, String string2, String string3) {
        throw new RuntimeException("Method not implemented");
    }

    void checkOp(int n) {
        this.state = this.state.checkOp(n);
    }

    @Override
    public void addRowSetListener(RowSetListener rowSetListener) {
        this.rowSetListeners.add(rowSetListener);
    }

    @Override
    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.rowSetListeners.remove(rowSetListener);
    }

    void cursorMoved() {
        RowSetEvent rowSetEvent = new RowSetEvent(this);
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.cursorMoved(rowSetEvent);
        }
    }

    void rowChanged() {
        RowSetEvent rowSetEvent = new RowSetEvent(this);
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.rowChanged(rowSetEvent);
        }
    }

    void rowSetChanged() {
        RowSetEvent rowSetEvent = new RowSetEvent(this);
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.rowSetChanged(rowSetEvent);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public boolean isReadOnly() {
        return this.metaData.isReadOnly();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.metaData.setReadOnly(bl);
    }

    public String getTableName() throws SQLException {
        return this.metaData.getWriteTableName();
    }

    public void setTableName(String string) throws SQLException {
        this.metaData.setWriteTableName(string);
    }

    public int[] getKeyColumns() throws SQLException {
        return this.metaData.getKeyColumns();
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        this.metaData.setKeyColumns(nArray);
    }

    @Override
    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    @Override
    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public RowSetWarning getRowSetWarnings() {
        return null;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public void setDataSourceName(String string) {
        this.dataSourceName = string;
        this.preferDataSource = true;
    }

    private DataSource lookupDataSource() throws SQLException {
        InitialContext initialContext = null;
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.userName != null) {
                hashtable.put("java.naming.security.principal", this.userName);
            }
            if (this.password != null) {
                hashtable.put("java.naming.security.credentials", this.password);
            }
            initialContext = new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            throw new SQLException("Unable to access JNDI with username: " + this.userName + ". Please ensure that your username and password are correct.", StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
        try {
            this.dataSource = (DataSource)initialContext.lookup(this.dataSourceName);
            return this.dataSource;
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("The name: " + this.dataSourceName + " was found in the JNDI tree, but this is not a javax.sql.DataSource.");
        }
        catch (NamingException namingException) {
            throw new SQLException("Unable to locate a DataSource with the name: " + this.dataSourceName + ".  Please check your configuration and make sure that this DataSource has been deployed.", StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
    }

    public DataSource getDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.dataSourceName != null) {
            return this.lookupDataSource();
        }
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.preferDataSource = true;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String string) {
        this.url = string;
        this.preferDataSource = false;
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public void setUsername(String string) {
        this.userName = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            if (this.preferDataSource) {
                if (this.dataSource == null) {
                    if (this.dataSourceName == null) {
                        throw new SQLException("You must call setDataSourceName and provide a valid DataSource JNDI name before attempting JDBC commands.");
                    }
                    this.lookupDataSource();
                }
                this.conn = this.dataSource.getConnection();
            } else {
                Properties properties = new Properties();
                properties.setProperty("user", this.userName);
                properties.setProperty("password", this.password);
                if (this.url != null && this.url.toLowerCase().matches(".*protocol\\s*=\\s*sdp.*")) {
                    properties.put("oracle.net.SDP", "true");
                }
                this.conn = DriverManager.getConnection(this.url, properties);
            }
        }
        if (this.isolationLevel != -1) {
            this.conn.setTransactionIsolation(this.isolationLevel);
        }
        return this.conn;
    }

    void toDesign() {
        this.checkOp(0);
    }

    @Override
    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.toDesign();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolationLevel = n;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new SQLException("Invalid value for setTransactionIsolation: " + n);
            }
        }
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(String string) {
        this.toDesign();
        this.command = string;
        this.clearParameters();
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int n) {
        this.toDesign();
        this.queryTimeout = n;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int n) {
        this.toDesign();
        this.maxRows = n;
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) {
        this.toDesign();
        this.maxFieldSize = n;
    }

    @Override
    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public void setEscapeProcessing(boolean bl) {
        this.toDesign();
        this.escapeProcessing = bl;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public void setConcurrency(int n) {
        this.toDesign();
        this.concurrency = n;
    }

    @Override
    public int getType() {
        return this.resultSetType;
    }

    @Override
    public void setType(int n) {
        this.toDesign();
        this.resultSetType = n;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.toDesign();
        switch (n) {
            case 1001: {
                if (this.getType() == 1003) {
                    throw new SQLException("Cannot set FETCH_REVERSE on a TYPE_FORWARD_ONLY RowSet.");
                }
            }
            case 1000: 
            case 1002: {
                this.fetchDirection = n;
                break;
            }
            default: {
                throw new SQLException("Unknown value for setFetchDirection:" + n);
            }
        }
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n) {
        this.toDesign();
        this.fetchSize = n;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.toDesign();
        this.typeMap = map;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setIsComplete(boolean bl) {
        this.isComplete = bl;
    }

    ArrayList getParameters() {
        return this.params;
    }

    @Override
    public void clearParameters() {
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        Object[] objectArray = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            objectArray[i] = this.params.get(i).getObject();
        }
        return objectArray;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkOp(5);
        this.rs.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkOp(6);
        this.rs.moveToCurrentRow();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkOp(4);
        return this.rs.absolute(n);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOp(4);
        this.rs.beforeFirst();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOp(4);
        return this.rs.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOp(4);
        return this.rs.last();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOp(4);
        this.rs.afterLast();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkOp(4);
        return this.rs.relative(n);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOp(4);
        return this.rs.next();
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOp(4);
        return this.rs.previous();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOp(4);
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOp(4);
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOp(4);
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOp(4);
        return this.rs.isLast();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    void toConfigQuery() {
        this.checkOp(1);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 1, new Object[]{array}));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 2, new Object[]{inputStream}));
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 3, new Object[]{inputStream, new Integer(n2)}));
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 2, new Object[]{inputStream}));
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 3, new Object[]{inputStream, new Integer(n)}));
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 4, new Object[]{bigDecimal}));
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 4, new Object[]{bigDecimal}));
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 5, new Object[]{inputStream}));
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 6, new Object[]{inputStream, new Integer(n2)}));
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 5, new Object[]{inputStream}));
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 6, new Object[]{inputStream, new Integer(n)}));
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 7, new Object[]{blob}));
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 8, new Object[]{inputStream}));
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 9, new Object[]{inputStream, new Long(l)}));
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 7, new Object[]{blob}));
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 8, new Object[]{inputStream}));
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 9, new Object[]{inputStream, new Long(l)}));
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 10, new Object[]{new Boolean(bl)}));
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 10, new Object[]{new Boolean(bl)}));
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 11, new Object[]{new Byte(by)}));
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 11, new Object[]{new Byte(by)}));
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 12, new Object[]{byArray}));
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 12, new Object[]{byArray}));
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 13, new Object[]{reader}));
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 14, new Object[]{reader, new Integer(n2)}));
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 13, new Object[]{reader}));
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 14, new Object[]{reader, new Integer(n)}));
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 15, new Object[]{clob}));
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 16, new Object[]{reader}));
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 17, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 15, new Object[]{clob}));
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 16, new Object[]{reader}));
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 17, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 18, new Object[]{date}));
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 19, new Object[]{date, calendar}));
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 18, new Object[]{date}));
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 19, new Object[]{date, calendar}));
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 20, new Object[]{new Double(d)}));
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 20, new Object[]{new Double(d)}));
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 21, new Object[]{new Float(f)}));
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 21, new Object[]{new Float(f)}));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 22, new Object[]{new Integer(n2)}));
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 22, new Object[]{new Integer(n)}));
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 23, new Object[]{new Long(l)}));
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 23, new Object[]{new Long(l)}));
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 24, new Object[]{reader}));
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 25, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 24, new Object[]{reader}));
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 25, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 26, new Object[]{nClob}));
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 27, new Object[]{reader}));
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 28, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 26, new Object[]{nClob}));
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 27, new Object[]{reader}));
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 28, new Object[]{reader, new Long(l)}));
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 29, new Object[]{string}));
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 29, new Object[]{string2}));
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 30, new Object[]{new Integer(n2)}));
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 31, new Object[]{new Integer(n2), string}));
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 30, new Object[]{new Integer(n)}));
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 31, new Object[]{new Integer(n), string2}));
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 32, new Object[]{object}));
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 33, new Object[]{object, new Integer(n2)}));
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 34, new Object[]{object, new Integer(n2), new Integer(n3)}));
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 32, new Object[]{object}));
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 33, new Object[]{object, new Integer(n)}));
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 34, new Object[]{object, new Integer(n), new Integer(n2)}));
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 35, new Object[]{ref}));
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 36, new Object[]{rowId}));
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 36, new Object[]{rowId}));
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 37, new Object[]{new Short(s)}));
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 37, new Object[]{new Short(s)}));
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 38, new Object[]{sQLXML}));
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 38, new Object[]{sQLXML}));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 39, new Object[]{string}));
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 39, new Object[]{string2}));
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 40, new Object[]{time}));
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 41, new Object[]{time, calendar}));
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 40, new Object[]{time}));
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 41, new Object[]{time, calendar}));
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 42, new Object[]{timestamp}));
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 43, new Object[]{timestamp, calendar}));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 42, new Object[]{timestamp}));
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 43, new Object[]{timestamp, calendar}));
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.params.add(new WLParameter(n, 44, new Object[]{uRL}));
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return this.rs.getArray(n);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.rs.getArray(string);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.rs.getAsciiStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.rs.getAsciiStream(string);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rs.getBigDecimal(n, n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rs.getBigDecimal(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rs.getBigDecimal(string, n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return this.rs.getBinaryStream(n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.rs.getBinaryStream(string);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            return this.rs.getBlob(n);
        }
        catch (SQLException sQLException) {
            byte[] byArray = this.rs.getBytes(n);
            return new RowSetBlob(byArray);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            return this.rs.getBlob(string);
        }
        catch (SQLException sQLException) {
            byte[] byArray = this.rs.getBytes(string);
            return new RowSetBlob(byArray);
        }
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return this.rs.getBoolean(n);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.rs.getBoolean(string);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return this.rs.getByte(n);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.rs.getByte(string);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.rs.getBytes(string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return this.rs.getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.rs.getCharacterStream(string);
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            return this.rs.getClob(n);
        }
        catch (SQLException sQLException) {
            String string = this.rs.getString(n);
            return new RowSetClob(string);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            return this.rs.getClob(string);
        }
        catch (SQLException sQLException) {
            String string2 = this.rs.getString(string);
            return new RowSetClob(string2);
        }
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.rs.getDate(n, calendar);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.rs.getDate(string);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.rs.getDate(string, calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return this.rs.getDouble(n);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.rs.getDouble(string);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return this.rs.getFloat(n);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.rs.getFloat(string);
    }

    @Override
    public int getInt(int n) throws SQLException {
        return this.rs.getInt(n);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.rs.getInt(string);
    }

    @Override
    public long getLong(int n) throws SQLException {
        return this.rs.getLong(n);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.rs.getLong(string);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.rs.getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.rs.getNCharacterStream(string);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        try {
            return this.rs.getNClob(n);
        }
        catch (SQLException sQLException) {
            String string = this.rs.getString(n);
            return new RowSetNClob(string);
        }
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        try {
            return this.rs.getNClob(string);
        }
        catch (SQLException sQLException) {
            String string2 = this.rs.getString(string);
            return new RowSetNClob(string2);
        }
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.rs.getNString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.rs.getNString(string);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.rs.getObject(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(n, map);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.rs.getObject(string);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.rs.getObject(string, map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.rs.getRef(string);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        return this.rs.getRowId(n);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.rs.getRowId(string);
    }

    @Override
    public short getShort(int n) throws SQLException {
        return this.rs.getShort(n);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.rs.getShort(string);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return this.rs.getSQLXML(n);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.rs.getSQLXML(string);
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.rs.getString(string);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.rs.getTime(n, calendar);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.rs.getTime(string);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.rs.getTime(string, calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rs.getTimestamp(string);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.rs.getTimestamp(string, calendar);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.rs.getUnicodeStream(n);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.rs.getUnicodeStream(string);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return this.rs.getURL(n);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.rs.getURL(string);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.checkOp(7);
        this.rs.updateArray(n, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.checkOp(7);
        this.rs.updateArray(string, array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(n, inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(n, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(n, inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(string, inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(string, inputStream, n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateAsciiStream(string, inputStream, l);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkOp(7);
        this.rs.updateBigDecimal(n, bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkOp(7);
        this.rs.updateBigDecimal(string, bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(string, inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(n, blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(n, inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(n, inputStream, l);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(string, blob);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(string, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateBlob(string, inputStream, l);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkOp(7);
        this.rs.updateBoolean(n, bl);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.checkOp(7);
        this.rs.updateBoolean(string, bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.checkOp(7);
        this.rs.updateByte(n, by);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.checkOp(7);
        this.rs.updateByte(string, by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkOp(7);
        this.rs.updateBytes(n, byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.checkOp(7);
        this.rs.updateBytes(string, byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(n, reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(n, reader, n2);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(string, reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(string, reader, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(n, clob);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(n, reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(n, reader, l);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(string, clob);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(string, reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateClob(string, reader, l);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.checkOp(7);
        this.rs.updateDate(n, date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.checkOp(7);
        this.rs.updateDate(string, date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.checkOp(7);
        this.rs.updateDouble(n, d);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.checkOp(7);
        this.rs.updateDouble(string, d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.checkOp(7);
        this.rs.updateFloat(n, f);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.checkOp(7);
        this.rs.updateFloat(string, f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.checkOp(7);
        this.rs.updateInt(n, n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateInt(string, n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateLong(n, l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateLong(string, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateNCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateNCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateNCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateNCharacterStream(string, reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(n, nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(n, reader);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(n, reader, l);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(string, nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(string, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.checkOp(7);
        this.rs.updateNClob(string, reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.checkOp(7);
        this.rs.updateNString(n, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.checkOp(7);
        this.rs.updateNString(string, string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateNull(n);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.checkOp(7);
        this.rs.updateNull(string);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.checkOp(7);
        this.rs.updateObject(n, object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkOp(7);
        this.rs.updateObject(n, object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.checkOp(7);
        this.rs.updateObject(string, object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.checkOp(7);
        this.rs.updateObject(string, object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.checkOp(7);
        this.rs.updateRef(n, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.checkOp(7);
        this.rs.updateRef(string, ref);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.checkOp(7);
        this.rs.updateRowId(n, rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.checkOp(7);
        this.rs.updateRowId(string, rowId);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.checkOp(7);
        this.rs.updateShort(n, s);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.checkOp(7);
        this.rs.updateShort(string, s);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.checkOp(7);
        this.rs.updateSQLXML(n, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.checkOp(7);
        this.rs.updateSQLXML(string, sQLXML);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.checkOp(7);
        this.rs.updateString(n, string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.checkOp(7);
        this.rs.updateString(string, string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.checkOp(7);
        this.rs.updateTime(n, time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.checkOp(7);
        this.rs.updateTime(string, time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkOp(7);
        this.rs.updateTimestamp(n, timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkOp(7);
        this.rs.updateTimestamp(string, timestamp);
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        return this.metaData.getMatchColumns();
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        int[] nArray = this.metaData.getMatchColumns();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.metaData.getColumnName(nArray[i]);
        }
        return stringArray;
    }

    @Override
    public void setMatchColumn(int n) throws SQLException {
        this.metaData.setMatchColumn(n, true);
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        this.metaData.setMatchColumn(this.findColumn(string), true);
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.setMatchColumn(nArray[i]);
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setMatchColumn(stringArray[i]);
        }
    }

    @Override
    public void unsetMatchColumn(int n) throws SQLException {
        this.metaData.setMatchColumn(n, false);
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        this.metaData.setMatchColumn(this.findColumn(string), false);
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.unsetMatchColumn(nArray[i]);
        }
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.unsetMatchColumn(stringArray[i]);
        }
    }

    @Override
    public void execute() throws SQLException {
        this.checkOp(2);
        this.cstmt = this.getConnection().prepareCall(this.command, this.resultSetType, this.concurrency);
        for (WLParameter wLParameter : this.getParameters()) {
            wLParameter.setParam(this.cstmt);
        }
        this.rs = this.cstmt.executeQuery();
        this.metaData = new CachedRowSetMetaData();
        this.metaData.initialize(this.rs.getMetaData(), this.rs.getStatement().getConnection().getMetaData());
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkOp(8);
        this.rs.insertRow();
        this.rowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkOp(4);
        this.rs.deleteRow();
        this.rowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkOp(8);
        this.rs.updateRow();
        this.rowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.rs.updateRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkOp(8);
        this.rs.cancelRowUpdates();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.cstmt != null) {
                this.cstmt.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.metaData.findColumn(string);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rs.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.rs == null) {
            return false;
        }
        return this.rs.isClosed();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

