/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.JoinRowSet;
import javax.sql.rowset.Joinable;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.xml.stream.XMLInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinRowSetImpl
extends CachedRowSetImpl
implements JoinRowSet {
    private static final long serialVersionUID = 7370178015207304595L;
    private ArrayList rowSets = new ArrayList();
    private String where = null;
    private int joinType = 1;

    @Override
    public void populate(ResultSetMetaData resultSetMetaData) throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void execute() throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public String executeAndGuessTableName() throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public boolean executeAndGuessTableNameAndPrimaryKeys() throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void loadXML(XMLInputStream xMLInputStream) throws IOException, SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    private void validate(CachedRow cachedRow, int[] nArray, CachedRow cachedRow2, int[] nArray2) throws SQLException {
        if (nArray.length != nArray2.length) {
            throw new SQLException("The number of match columns in two Joinables are not the same.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.isJoinable(cachedRow.getColumn(nArray[i]).getClass(), cachedRow2.getColumn(nArray2[i]).getClass());
        }
    }

    @Override
    public void addRowSet(Joinable joinable) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = null;
        if (joinable instanceof CachedRowSetImpl) {
            cachedRowSetImpl = (CachedRowSetImpl)joinable;
        } else if (joinable instanceof RowSet) {
            cachedRowSetImpl = new CachedRowSetImpl();
            cachedRowSetImpl.populate((RowSet)((Object)joinable));
            cachedRowSetImpl.setMatchColumn(joinable.getMatchColumnIndexes());
        } else {
            throw new SQLException(joinable + " can not be added into JoinRowSet.");
        }
        if (this.rowSets.size() == 0) {
            super.populate(cachedRowSetImpl, 1);
            this.setMatchColumn(cachedRowSetImpl.getMatchColumnIndexes());
        } else {
            int n;
            CachedRowSetMetaData cachedRowSetMetaData = this.metaData;
            CachedRowSetMetaData cachedRowSetMetaData2 = (CachedRowSetMetaData)cachedRowSetImpl.getMetaData();
            int[] nArray = cachedRowSetMetaData.getMatchColumns();
            int[] nArray2 = cachedRowSetMetaData2.getMatchColumns();
            if (this.rows.size() != 0 && cachedRowSetImpl.rows.size() != 0) {
                this.validate((CachedRow)this.rows.get(0), nArray, (CachedRow)cachedRowSetImpl.rows.get(0), nArray2);
            }
            ArrayList arrayList = new ArrayList(this.rows);
            ArrayList arrayList2 = new ArrayList(cachedRowSetImpl.rows);
            ArrayList arrayList3 = null;
            if (this.joinType == 0) {
                arrayList3 = this.crossJoin(arrayList, arrayList2);
            } else {
                Collections.sort(arrayList, new JoinSorter(nArray, nArray));
                Collections.sort(arrayList2, new JoinSorter(nArray2, nArray2));
                if (this.joinType == 1) {
                    arrayList3 = this.innerJoin(arrayList, arrayList2, new JoinSorter(nArray, nArray2));
                } else if (this.joinType == 2) {
                    arrayList3 = this.leftJoin(arrayList, arrayList2, new JoinSorter(nArray, nArray2));
                } else if (this.joinType == 3) {
                    arrayList3 = this.rightJoin(arrayList, arrayList2, new JoinSorter(nArray, nArray2));
                } else if (this.joinType == 4) {
                    arrayList3 = this.fullJoin(arrayList, arrayList2, new JoinSorter(nArray, nArray2));
                }
            }
            int n2 = this.metaData.getColumnCount();
            this.metaData.addColumns(cachedRowSetImpl.getMetaData());
            ArrayList<CachedRow> arrayList4 = new ArrayList<CachedRow>();
            for (n = 0; n < arrayList3.size(); ++n) {
                MatchInfo matchInfo = (MatchInfo)arrayList3.get(n);
                CachedRow cachedRow = matchInfo.getLeft();
                CachedRow cachedRow2 = matchInfo.getRight();
                CachedRow cachedRow3 = new CachedRow(this.metaData);
                cachedRow3.copyFrom(cachedRow);
                cachedRow3.copyFrom(n2, cachedRow2);
                arrayList4.add(cachedRow3);
            }
            this.allrows = arrayList4;
            this.filter();
            for (n = 0; n < nArray.length; ++n) {
                if (this.where != null) {
                    this.where = this.where + " AND ";
                }
                this.where = cachedRowSetMetaData.getQualifiedColumnName(nArray[n]) + "=" + cachedRowSetMetaData2.getQualifiedColumnName(nArray2[n]);
            }
        }
        this.rowSets.add(joinable);
    }

    @Override
    public void addRowSet(RowSet rowSet, int n) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = null;
        if (rowSet instanceof CachedRowSetImpl) {
            cachedRowSetImpl = (CachedRowSetImpl)rowSet;
        } else if (rowSet instanceof RowSet) {
            cachedRowSetImpl = new CachedRowSetImpl();
            cachedRowSetImpl.populate(rowSet);
        } else {
            throw new SQLException(rowSet + " can not be added into JoinRowSet.");
        }
        cachedRowSetImpl.setMatchColumn(new int[]{n});
        this.addRowSet(cachedRowSetImpl);
    }

    @Override
    public void addRowSet(RowSet rowSet, String string) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = null;
        if (rowSet instanceof CachedRowSetImpl) {
            cachedRowSetImpl = (CachedRowSetImpl)rowSet;
        } else if (rowSet instanceof RowSet) {
            cachedRowSetImpl = new CachedRowSetImpl();
            cachedRowSetImpl.populate(rowSet);
        } else {
            throw new SQLException(rowSet + " can not be added into JoinRowSet.");
        }
        cachedRowSetImpl.setMatchColumn(new String[]{string});
        this.addRowSet(cachedRowSetImpl);
    }

    @Override
    public void addRowSet(RowSet[] rowSetArray, int[] nArray) throws SQLException {
        for (int i = 0; i < rowSetArray.length; ++i) {
            this.addRowSet(rowSetArray[i], nArray[i]);
        }
    }

    @Override
    public void addRowSet(RowSet[] rowSetArray, String[] stringArray) throws SQLException {
        for (int i = 0; i < rowSetArray.length; ++i) {
            this.addRowSet(rowSetArray[i], stringArray[i]);
        }
    }

    public Collection getRowSets() throws SQLException {
        return this.rowSets;
    }

    @Override
    public String[] getRowSetNames() throws SQLException {
        String[] stringArray = new String[this.rowSets.size()];
        Iterator iterator = this.rowSets.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = ((CachedRowSetImpl)iterator.next()).getTableName();
        }
        return stringArray;
    }

    @Override
    public CachedRowSet toCachedRowSet() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.populate(this);
        return cachedRowSetImpl;
    }

    @Override
    public boolean supportsCrossJoin() {
        return true;
    }

    @Override
    public boolean supportsInnerJoin() {
        return true;
    }

    @Override
    public boolean supportsLeftOuterJoin() {
        return true;
    }

    @Override
    public boolean supportsRightOuterJoin() {
        return true;
    }

    @Override
    public boolean supportsFullJoin() {
        return true;
    }

    @Override
    public int getJoinType() {
        return this.joinType;
    }

    @Override
    public void setJoinType(int n) throws SQLException {
        this.joinType = n;
    }

    @Override
    public String getWhereClause() throws SQLException {
        return this.where;
    }

    ArrayList crossJoin(ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<MatchInfo> arrayList3 = new ArrayList<MatchInfo>();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList3.add(new MatchInfo((CachedRow)arrayList.get(i), (CachedRow)arrayList2.get(j)));
            }
        }
        return arrayList3;
    }

    ArrayList innerJoin(ArrayList arrayList, ArrayList arrayList2, JoinSorter joinSorter) {
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList arrayList5 = new ArrayList();
        if (arrayList == null || arrayList2 == null || arrayList.size() <= 0 || arrayList2.size() <= 0) {
            return arrayList5;
        }
        int n = 0;
        int n2 = 0;
        if (joinSorter.compare(arrayList.get(arrayList.size() - 1), arrayList2.get(arrayList2.size() - 1)) < 0) {
            arrayList4 = arrayList;
            arrayList3 = arrayList2;
            joinSorter.exchange();
        } else {
            arrayList4 = arrayList2;
            arrayList3 = arrayList;
        }
        while (n < arrayList4.size() && n2 < arrayList3.size()) {
            int n3 = joinSorter.compare(arrayList3.get(n2), arrayList4.get(n));
            while (n3 < 0) {
                n3 = joinSorter.compare(arrayList3.get(++n2), arrayList4.get(n));
            }
            if (n3 == 0) {
                ArrayList arrayList6 = new ArrayList();
                ArrayList arrayList7 = new ArrayList();
                do {
                    arrayList6.add(arrayList3.get(n2));
                } while (++n2 < arrayList3.size() && joinSorter.compare(arrayList3.get(n2), arrayList4.get(n)) == 0);
                do {
                    arrayList7.add(arrayList4.get(n));
                } while (++n < arrayList4.size() && joinSorter.compare(arrayList3.get(n2 - 1), arrayList4.get(n)) == 0);
                if (arrayList == arrayList3) {
                    arrayList5.addAll(this.crossJoin(arrayList6, arrayList7));
                    continue;
                }
                arrayList5.addAll(this.crossJoin(arrayList7, arrayList6));
                continue;
            }
            ++n;
        }
        return arrayList5;
    }

    ArrayList leftJoin(ArrayList arrayList, ArrayList arrayList2, JoinSorter joinSorter) {
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList<MatchInfo> arrayList5 = new ArrayList<MatchInfo>();
        if (arrayList == null || arrayList.size() <= 0) {
            return arrayList5;
        }
        if (arrayList2 == null || arrayList2.size() <= 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList.get(i), null));
            }
            return arrayList5;
        }
        int n = 0;
        int n2 = 0;
        if (joinSorter.compare(arrayList.get(arrayList.size() - 1), arrayList2.get(arrayList2.size() - 1)) < 0) {
            arrayList4 = arrayList;
            arrayList3 = arrayList2;
            joinSorter.exchange();
        } else {
            arrayList4 = arrayList2;
            arrayList3 = arrayList;
        }
        while (n < arrayList4.size() && n2 < arrayList3.size()) {
            int n3 = joinSorter.compare(arrayList3.get(n2), arrayList4.get(n));
            while (n3 < 0) {
                if (arrayList3 == arrayList) {
                    arrayList5.add(new MatchInfo((CachedRow)arrayList3.get(n2), null));
                }
                n3 = joinSorter.compare(arrayList3.get(++n2), arrayList4.get(n));
            }
            if (n3 == 0) {
                ArrayList arrayList6 = new ArrayList();
                ArrayList arrayList7 = new ArrayList();
                do {
                    arrayList6.add(arrayList3.get(n2));
                } while (++n2 < arrayList3.size() && joinSorter.compare(arrayList3.get(n2), arrayList4.get(n)) == 0);
                do {
                    arrayList7.add(arrayList4.get(n));
                } while (++n < arrayList4.size() && joinSorter.compare(arrayList3.get(n2 - 1), arrayList4.get(n)) == 0);
                if (arrayList == arrayList3) {
                    arrayList5.addAll(this.crossJoin(arrayList6, arrayList7));
                    continue;
                }
                arrayList5.addAll(this.crossJoin(arrayList7, arrayList6));
                continue;
            }
            if (arrayList4 == arrayList) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList4.get(n), null));
            }
            ++n;
        }
        if (arrayList4 == arrayList) {
            while (n < arrayList4.size()) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList4.get(n++), null));
            }
        } else {
            while (n2 < arrayList3.size()) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList3.get(n2++), null));
            }
        }
        return arrayList5;
    }

    ArrayList rightJoin(ArrayList arrayList, ArrayList arrayList2, JoinSorter joinSorter) {
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList<MatchInfo> arrayList5 = new ArrayList<MatchInfo>();
        if (arrayList2 == null || arrayList2.size() <= 0) {
            return arrayList5;
        }
        if (arrayList == null || arrayList.size() <= 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList2.get(i)));
            }
            return arrayList5;
        }
        int n = 0;
        int n2 = 0;
        if (joinSorter.compare(arrayList.get(arrayList.size() - 1), arrayList2.get(arrayList2.size() - 1)) < 0) {
            arrayList4 = arrayList;
            arrayList3 = arrayList2;
            joinSorter.exchange();
        } else {
            arrayList4 = arrayList2;
            arrayList3 = arrayList;
        }
        while (n < arrayList4.size() && n2 < arrayList3.size()) {
            int n3 = joinSorter.compare(arrayList3.get(n2), arrayList4.get(n));
            while (n3 < 0) {
                if (arrayList3 == arrayList2) {
                    arrayList5.add(new MatchInfo(null, (CachedRow)arrayList3.get(n2)));
                }
                n3 = joinSorter.compare(arrayList3.get(++n2), arrayList4.get(n));
            }
            if (n3 == 0) {
                ArrayList arrayList6 = new ArrayList();
                ArrayList arrayList7 = new ArrayList();
                do {
                    arrayList6.add(arrayList3.get(n2));
                } while (++n2 < arrayList3.size() && joinSorter.compare(arrayList3.get(n2), arrayList4.get(n)) == 0);
                do {
                    arrayList7.add(arrayList4.get(n));
                } while (++n < arrayList4.size() && joinSorter.compare(arrayList3.get(n2 - 1), arrayList4.get(n)) == 0);
                if (arrayList == arrayList3) {
                    arrayList5.addAll(this.crossJoin(arrayList6, arrayList7));
                    continue;
                }
                arrayList5.addAll(this.crossJoin(arrayList7, arrayList6));
                continue;
            }
            if (arrayList4 == arrayList2) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList4.get(n)));
            }
            ++n;
        }
        if (arrayList4 == arrayList2) {
            while (n < arrayList4.size()) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList4.get(n++)));
            }
        } else {
            while (n2 < arrayList3.size()) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList3.get(n2++)));
            }
        }
        return arrayList5;
    }

    ArrayList fullJoin(ArrayList arrayList, ArrayList arrayList2, JoinSorter joinSorter) {
        ArrayList arrayList3;
        ArrayList arrayList4;
        ArrayList<MatchInfo> arrayList5 = new ArrayList<MatchInfo>();
        if (arrayList2 == null || arrayList2.size() <= 0) {
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList5.add(new MatchInfo((CachedRow)arrayList.get(i), null));
                }
            }
            return arrayList5;
        }
        if (arrayList == null || arrayList.size() <= 0) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList2.get(i)));
            }
            return arrayList5;
        }
        int n = 0;
        int n2 = 0;
        if (joinSorter.compare(arrayList.get(arrayList.size() - 1), arrayList2.get(arrayList2.size() - 1)) < 0) {
            arrayList4 = arrayList;
            arrayList3 = arrayList2;
            joinSorter.exchange();
        } else {
            arrayList4 = arrayList2;
            arrayList3 = arrayList;
        }
        while (n < arrayList4.size() && n2 < arrayList3.size()) {
            int n3 = joinSorter.compare(arrayList3.get(n2), arrayList4.get(n));
            while (n3 < 0) {
                if (arrayList3 == arrayList) {
                    arrayList5.add(new MatchInfo((CachedRow)arrayList3.get(n2), null));
                } else {
                    arrayList5.add(new MatchInfo(null, (CachedRow)arrayList3.get(n2)));
                }
                n3 = joinSorter.compare(arrayList3.get(++n2), arrayList4.get(n));
            }
            if (n3 == 0) {
                ArrayList arrayList6 = new ArrayList();
                ArrayList arrayList7 = new ArrayList();
                do {
                    arrayList6.add(arrayList3.get(n2));
                } while (++n2 < arrayList3.size() && joinSorter.compare(arrayList3.get(n2), arrayList4.get(n)) == 0);
                do {
                    arrayList7.add(arrayList4.get(n));
                } while (++n < arrayList4.size() && joinSorter.compare(arrayList3.get(n2 - 1), arrayList4.get(n)) == 0);
                if (arrayList == arrayList3) {
                    arrayList5.addAll(this.crossJoin(arrayList6, arrayList7));
                    continue;
                }
                arrayList5.addAll(this.crossJoin(arrayList7, arrayList6));
                continue;
            }
            if (arrayList4 == arrayList) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList4.get(n), null));
            } else {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList4.get(n)));
            }
            ++n;
        }
        if (arrayList4 == arrayList) {
            while (n < arrayList4.size()) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList4.get(n++), null));
            }
            while (n2 < arrayList3.size()) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList3.get(n2++)));
            }
        } else {
            while (n < arrayList4.size()) {
                arrayList5.add(new MatchInfo(null, (CachedRow)arrayList4.get(n++)));
            }
            while (n2 < arrayList3.size()) {
                arrayList5.add(new MatchInfo((CachedRow)arrayList3.get(n2++), null));
            }
        }
        return arrayList5;
    }

    @Override
    public boolean previousPage() throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public boolean nextPage() throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void populate(ResultSet resultSet, int n) throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        throw new SQLException("This is not supported for JoinRowSet");
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    class JoinSorter
    implements Comparator {
        int[] leftCols = null;
        int[] rightCols = null;

        public JoinSorter(int[] nArray, int[] nArray2) {
            this.leftCols = nArray;
            this.rightCols = nArray2;
        }

        void exchange() {
            int[] nArray = this.leftCols;
            this.leftCols = this.rightCols;
            this.rightCols = nArray;
        }

        public final int compare(Object object, Object object2) {
            int n = 0;
            for (int i = 0; i < this.leftCols.length; ++i) {
                Object object3;
                Object object4;
                try {
                    object4 = ((CachedRow)object).getColumn(this.leftCols[i]);
                    object3 = ((CachedRow)object2).getColumn(this.rightCols[i]);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Failed to retrieve the object to compare.");
                }
                try {
                    Class<?> clazz;
                    if (object4 == null && object3 == null) {
                        return 0;
                    }
                    if (object4 == null) {
                        return -1;
                    }
                    if (object3 == null) {
                        return 1;
                    }
                    Class<?> clazz2 = object4.getClass();
                    if (clazz2 == (clazz = object3.getClass()) && Comparable.class.isAssignableFrom(clazz2)) {
                        n = ((Comparable)object4).compareTo((Comparable)object3);
                    } else if (Number.class.isAssignableFrom(clazz2) || Number.class.isAssignableFrom(clazz)) {
                        if (Number.class.isAssignableFrom(clazz2) || String.class.isAssignableFrom(clazz2)) {
                            object4 = new BigDecimal(object4.toString().trim());
                        }
                        if (Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                            object3 = new BigDecimal(object3.toString().trim());
                        }
                        n = ((Comparable)object4).compareTo((Comparable)object3);
                    } else if (Date.class.isAssignableFrom(clazz2) || Date.class.isAssignableFrom(clazz) || Time.class.isAssignableFrom(clazz2) || Time.class.isAssignableFrom(clazz) || Timestamp.class.isAssignableFrom(clazz2) || Timestamp.class.isAssignableFrom(clazz)) {
                        if (String.class.isAssignableFrom(clazz2)) {
                            object4 = Date.valueOf((String)object4);
                        }
                        if (String.class.isAssignableFrom(clazz)) {
                            object3 = Date.valueOf((String)object3);
                        }
                        n = ((Comparable)object4).compareTo((Comparable)object3);
                    } else if (Boolean.class.isAssignableFrom(clazz2) || Boolean.class.isAssignableFrom(clazz)) {
                        if (String.class.isAssignableFrom(clazz2)) {
                            object4 = new Boolean(object4.toString().trim());
                        }
                        if (String.class.isAssignableFrom(clazz)) {
                            object3 = new Boolean(object3.toString().trim());
                        }
                        n = ((Comparable)object4).compareTo((Comparable)object3);
                    } else {
                        throw new RuntimeException(clazz2 + " can not be joined with " + clazz);
                    }
                    if (n == 0) continue;
                    return n;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(object4.getClass() + " can not be joined with " + object3.getClass());
                }
            }
            return 0;
        }
    }

    class MatchInfo {
        CachedRow left;
        CachedRow right;

        MatchInfo(CachedRow cachedRow, CachedRow cachedRow2) {
            this.left = cachedRow;
            this.right = cachedRow2;
        }

        CachedRow getLeft() {
            return this.left;
        }

        CachedRow getRight() {
            return this.right;
        }
    }
}

