/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.lang.reflect.Field;
import weblogic.jdbc.JDBCLogger;

class LifeCycle {
    private static final int DESIGNING_CODE = 0;
    private static final int POPULATING_CODE = 1;
    private static final int CONFIGURING_METADATA_CODE = 2;
    private static final int MANIPULATING_CODE = 3;
    private static final int INSERTING_CODE = 4;
    private static final int UPDATING_CODE = 5;
    public static final int DESIGN = 0;
    public static final int CONFIGURE_QUERY = 1;
    public static final int POPULATE = 2;
    public static final int CONFIGURE_METADATA = 3;
    public static final int NAVIGATE = 4;
    public static final int MOVE_TO_INSERT = 5;
    public static final int MOVE_TO_CURRENT = 6;
    public static final int UPDATE = 7;
    public static final int FINISH_UPDATE = 8;
    public static final int ACCEPT_CHANGES = 9;
    public static final int ACCEPT_CHANGES_REUSE = 10;
    private static final int OP_COUNT = 11;
    public static final State DESIGNING = new State(0, new int[]{4, 0, 1, 5, 2});
    public static final State POPULATING = new State(1, new int[]{1, 2, 3, 0, 4, 5, 7, 9, 10});
    public static final State CONFIGURING_METADATA = new State(2, new int[]{3, 4, 5, 7});
    public static final State MANIPULATING = new State(3, new int[]{0, 3, 4, 5, 7, 9, 10});
    public static final State INSERTING = new State(4, new int[]{5, 7, 8, 6, 9, 10}){
        private static final long serialVersionUID = 7393324511593576778L;

        State next(int n) {
            switch (n) {
                case 7: 
                case 8: {
                    return INSERTING;
                }
            }
            return NEXT[n];
        }
    };
    public static final State UPDATING = new State(5, new int[]{7, 8});
    private static final State[] NEXT = new State[11];
    private static final int PFS = 25;

    LifeCycle() {
    }

    private static String getOpName(int n) {
        Field[] fieldArray = LifeCycle.class.getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                if ((fieldArray[i].getModifiers() & 0x19) != 25 || fieldArray[i].getType() != Integer.TYPE || fieldArray[i].getInt(null) != n) continue;
                return fieldArray[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            JDBCLogger.logStackTrace((Throwable)illegalAccessException);
        }
        return "unknown op " + n;
    }

    private static String getStateName(State state) {
        Field[] fieldArray = LifeCycle.class.getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                if ((fieldArray[i].getModifiers() & 0x19) != 25 || fieldArray[i].getType() != State.class || fieldArray[i].get(null) != state) continue;
                return fieldArray[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            JDBCLogger.logStackTrace((Throwable)illegalAccessException);
        }
        return "unknown state " + state;
    }

    private static State lookupState(int n) {
        Field[] fieldArray = LifeCycle.class.getFields();
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                State state;
                if ((fieldArray[i].getModifiers() & 0x19) != 25 || fieldArray[i].getType() != State.class || (state = (State)fieldArray[i].get(null)).code != n) continue;
                return state;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            JDBCLogger.logStackTrace((Throwable)illegalAccessException);
        }
        throw new AssertionError(n);
    }

    static {
        LifeCycle.NEXT[0] = DESIGNING;
        LifeCycle.NEXT[1] = POPULATING;
        LifeCycle.NEXT[2] = POPULATING;
        LifeCycle.NEXT[3] = CONFIGURING_METADATA;
        LifeCycle.NEXT[4] = MANIPULATING;
        LifeCycle.NEXT[5] = INSERTING;
        LifeCycle.NEXT[6] = MANIPULATING;
        LifeCycle.NEXT[7] = UPDATING;
        LifeCycle.NEXT[8] = MANIPULATING;
        LifeCycle.NEXT[9] = DESIGNING;
        LifeCycle.NEXT[10] = POPULATING;
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 7867643086257295621L;
        private final int code;
        private final int validOps;
        private String name;

        State(int n, int[] nArray) {
            this.code = n;
            int n2 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                n2 |= 1 << nArray[i];
            }
            this.validOps = n2;
        }

        State next(int n) {
            return NEXT[n];
        }

        String getName() {
            if (this.name == null) {
                this.name = LifeCycle.getStateName(this);
            }
            return this.name;
        }

        State checkOp(int n) {
            if ((this.validOps & 1 << n) == 0) {
                throw new UnsupportedOperationException("Operation class " + LifeCycle.getOpName(n) + " not supported in state " + this.getName());
            }
            return this.next(n);
        }

        private Object readResolve() {
            return LifeCycle.lookupState(this.code);
        }
    }
}

