/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Locale;
import weblogic.jdbc.rowset.TableWriter;
import weblogic.jdbc.rowset.WLRowSetInternal;

public class OracleTableWriter
extends TableWriter {
    OracleTableWriter(WLRowSetInternal wLRowSetInternal, String string, BitSet bitSet) throws SQLException {
        super(wLRowSetInternal, string, bitSet);
    }

    public void issueSQL(Connection connection) throws SQLException {
        this.checkBatchUpdateCounts = false;
        if (this.batchDeletes) {
            this.batchDeletes = false;
            this.groupDeletes = true;
        }
        super.issueSQL(connection);
    }

    protected void executeBatchVerifySelects(Connection connection) throws SQLException {
        if (this.batchVerifyParams.isEmpty()) {
            return;
        }
        int n = 0;
        do {
            this.executeBatchVerifySelects(connection, n);
        } while ((n += this.batchVerifySize) < this.batchVerifyParams.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchVerifySelects(Connection connection, int n) throws SQLException {
        Exception exception3;
        Object object;
        block16: {
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append("SELECT 1 from ").append(this.tableName).append(" WHERE ");
            String string = "";
            int n2 = Math.min(n + this.batchVerifySize, this.batchVerifyParams.size());
            for (int i = n; i < n2; ++i) {
                stringBuffer.append(string);
                string = " OR ";
                object = (TableWriter.BatchVerifyParam)this.batchVerifyParams.get(i);
                stringBuffer.append(((TableWriter.BatchVerifyParam)object).getWhereClause());
            }
            if (connection.getMetaData().getDatabaseProductName().toLowerCase(Locale.ENGLISH).indexOf("oracle") != -1) {
                stringBuffer.append(" FOR UPDATE NOWAIT");
            }
            String string2 = stringBuffer.toString();
            object = null;
            ResultSet resultSet = null;
            try {
                int n3;
                object = connection.prepareStatement(string2);
                int n4 = 1;
                for (n3 = n; n3 < n2; ++n3) {
                    TableWriter.BatchVerifyParam batchVerifyParam = (TableWriter.BatchVerifyParam)this.batchVerifyParams.get(n3);
                    n4 = this.setWhereParameters((PreparedStatement)object, batchVerifyParam.getCols(), batchVerifyParam.getFilter(), n4);
                }
                resultSet = object.executeQuery();
                n3 = 0;
                while (resultSet.next()) {
                    ++n3;
                }
                if (n3 != n2 - n) {
                    this.throwOCE(string2, null);
                }
                Object var13_13 = null;
                if (resultSet == null) break block16;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var13_14 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception exception3) {}
        }
    }
}

