/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import weblogic.jdbc.rowset.RowSetLob;
import weblogic.utils.StackTraceUtils;

public final class RowSetBlob
extends RowSetLob
implements Blob,
Serializable {
    private static final long serialVersionUID = -2526507456741346804L;
    private byte[] data;

    public RowSetBlob() {
        this(new byte[0]);
    }

    public RowSetBlob(byte[] byArray) {
        this.data = byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowSetBlob(Blob blob) throws SQLException {
        if (blob.length() > Integer.MAX_VALUE) {
            throw new SQLException("RowSets cannot read BLOBs greater than 2147483647 bytes.");
        }
        int n = (int)blob.length();
        this.data = new byte[n];
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
                int n2 = 0;
                int n3 = 0;
                while ((n3 = ((InputStream)bufferedInputStream).read(this.data, n2, n - n2)) > 0) {
                    n2 += n3;
                }
                Object var7_7 = null;
                if (bufferedInputStream == null) return;
            }
            catch (IOException iOException) {
                throw new SQLException("Error reading BLOB data: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        ((InputStream)bufferedInputStream).close();
        return;
    }

    public String toString() {
        return "<BLOB length: " + this.data.length + ">";
    }

    public long length() {
        return this.data.length;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L || l > (long)this.data.length) {
            throw new SQLException("Position: " + l + " must be >=0 and less than Blob.length()");
        }
        if (n < 0) {
            throw new SQLException("length must be positive");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, (int)l, byArray, 0, n);
        return byArray;
    }

    public InputStream getBinaryStream() {
        return new ByteArrayInputStream(this.data);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 0L || l >= (long)this.data.length) {
            throw new SQLException("start must be >= 0 and < Blob.length()");
        }
        for (int i = (int)l; i < this.data.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray.length; ++j) {
                if (this.data[i + j] == byArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (blob.length() > Integer.MAX_VALUE) {
            throw new SQLException("RowSets cannot read BLOBs greater than 2147483647 bytes.");
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) {
        this.ensureLength(l + (long)n2);
        System.arraycopy(byArray, n, this.data, (int)l, n2);
        return n2;
    }

    public OutputStream setBinaryStream(final long l) throws SQLException {
        return new OutputStream(){
            int pos;
            {
                this.pos = (int)l - 1;
            }

            public void write(int n) {
                RowSetBlob.this.ensureLength(this.pos + 1);
                ((RowSetBlob)RowSetBlob.this).data[this.pos++] = (byte)n;
            }

            public void write(byte[] byArray, int n, int n2) {
                this.pos += RowSetBlob.this.setBytes(this.pos, byArray, n, n2);
            }
        };
    }

    public void truncate(long l) throws SQLException {
        if (l > (long)this.data.length) {
            throw new SQLException("truncate to length: " + l + " is larger than current size: " + this.data.length);
        }
        this.changeLength(l, (int)l);
    }

    byte[] getData() {
        return this.data;
    }

    private void ensureLength(long l) {
        if (l > (long)this.data.length) {
            this.changeLength(l, this.data.length);
        }
    }

    private void changeLength(long l, int n) {
        byte[] byArray = this.data;
        this.data = new byte[(int)l];
        System.arraycopy(byArray, 0, this.data, 0, n);
    }

    protected Object update(Connection connection, ResultSet resultSet, int n, RowSetLob.UpdateHelper updateHelper) throws SQLException {
        return updateHelper.update(connection, resultSet.getBlob(n), this.data);
    }

    public void free() throws SQLException {
        this.data = null;
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        return new ByteArrayInputStream(this.data, (int)l, (int)l2);
    }
}

