/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import weblogic.jdbc.rowset.RowSetLob;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public class RowSetClob
extends RowSetLob
implements NClob,
Serializable {
    private static final long serialVersionUID = -2055191804143683989L;
    protected char[] data;

    public RowSetClob() {
        this(new char[0]);
    }

    public RowSetClob(String string) {
        this(string.toCharArray());
    }

    public RowSetClob(char[] cArray) {
        this.data = cArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowSetClob(Clob clob) throws SQLException {
        if (clob.length() > Integer.MAX_VALUE) {
            throw new SQLException("RowSets cannot read CLOBs greater than 2147483647 bytes.");
        }
        int n = (int)clob.length();
        this.data = new char[n];
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                int n2 = 0;
                int n3 = 0;
                while ((n3 = bufferedReader.read(this.data, n2, n - n2)) > 0) {
                    n2 += n3;
                }
                Object var7_7 = null;
                if (bufferedReader == null) return;
            }
            catch (IOException iOException) {
                throw new SQLException("Error reading CLOB data: " + StackTraceUtils.throwable2StackTrace((Throwable)iOException));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return;
    }

    public String toString() {
        return "<CLOB length: " + this.data.length + ">";
    }

    private void dumpData() {
        Debug.say((String)("** <CLOB> length:" + this.data.length + " data: " + new String(this.data, 0, this.data.length)));
    }

    char[] getData() {
        return this.data;
    }

    private void checkOffset(long l) throws SQLException {
        if (l < 0L || l > (long)this.data.length) {
            throw new SQLException("Offset : " + l + " is not valid since the data length is: " + this.data.length);
        }
    }

    public long length() {
        return this.data.length;
    }

    public InputStream getAsciiStream() {
        return new StringBufferInputStream(new String(this.data));
    }

    public void truncate(long l) throws SQLException {
        if (l > (long)this.data.length) {
            throw new SQLException("truncate to length:" + l + " is larger than current size: " + this.data.length);
        }
        this.changeLength(l, (int)l);
    }

    private void ensureLength(long l) {
        if (l > (long)this.data.length) {
            this.changeLength(l, this.data.length);
        }
    }

    private void changeLength(long l, int n) {
        char[] cArray = this.data;
        this.data = new char[(int)l];
        System.arraycopy(cArray, 0, this.data, 0, n);
    }

    public String getSubString(long l, int n) throws SQLException {
        this.checkOffset(l);
        int n2 = (int)l;
        return new String(this.data, n2, Math.min(n, this.data.length - n2));
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.data);
    }

    public int setString(long l, String string) {
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) {
        this.ensureLength(l + (long)n2);
        string.getChars(n, n2, this.data, (int)l);
        return n2;
    }

    public long position(String string, long l) throws SQLException {
        this.checkOffset(l);
        char[] cArray = string.toCharArray();
        for (int i = (int)l; i < this.data.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < cArray.length; ++j) {
                if (this.data[i + j] == cArray[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1L;
    }

    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }

    public OutputStream setAsciiStream(final long l) throws SQLException {
        return new OutputStream(){
            int pos;
            {
                this.pos = (int)l - 1;
            }

            public void write(int n) {
                RowSetClob.this.ensureLength(this.pos + 1);
                RowSetClob.this.data[this.pos++] = (char)n;
            }

            public void write(byte[] byArray, int n, int n2) {
                RowSetClob.this.ensureLength(this.pos + n2);
                while (n2 > 0) {
                    RowSetClob.this.data[this.pos++] = (char)byArray[n++];
                    --n2;
                }
            }
        };
    }

    public Writer setCharacterStream(final long l) throws SQLException {
        return new Writer(){
            int pos;
            {
                this.pos = (int)l - 1;
            }

            public void write(char[] cArray, int n, int n2) throws IOException {
                RowSetClob.this.ensureLength(this.pos + n2);
                System.arraycopy(cArray, n, RowSetClob.this.data, this.pos, n2);
                this.pos += n2;
            }

            public void flush() throws IOException {
            }

            public void close() throws IOException {
            }

            public void write(String string, int n, int n2) throws IOException {
                RowSetClob.this.ensureLength(this.pos + n2);
                string.getChars(n, n2, RowSetClob.this.data, this.pos);
                this.pos += n2;
            }
        };
    }

    protected Object update(Connection connection, ResultSet resultSet, int n, RowSetLob.UpdateHelper updateHelper) throws SQLException {
        return updateHelper.update(connection, resultSet.getClob(n), this.data);
    }

    public void free() throws SQLException {
        this.data = null;
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        return new CharArrayReader(this.data, (int)l, (int)l2);
    }
}

