/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.sql.rowset.Predicate;
import weblogic.utils.expressions.Expression;
import weblogic.utils.expressions.ExpressionEvaluationException;
import weblogic.utils.expressions.ExpressionParser;
import weblogic.utils.expressions.ExpressionParserException;
import weblogic.utils.expressions.Variable;
import weblogic.utils.expressions.VariableBinder;

public class SQLPredicate
implements Predicate,
Serializable {
    private Expression expression = null;

    public SQLPredicate(String string) throws ExpressionParserException {
        this.expression = new ExpressionParser().parse(string, (VariableBinder)SQLVariableBinder.THE_ONE);
    }

    public boolean evaluate(RowSet rowSet) {
        try {
            return this.expression.evaluate((Object)rowSet);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }

    public boolean evaluate(Object object, String string) throws SQLException {
        throw new SQLException("This is not supported by SQLPredicate.");
    }

    public boolean evaluate(Object object, int n) throws SQLException {
        throw new SQLException("This is not supported by SQLPredicate.");
    }

    private static class SQLVariable
    implements Variable {
        private final String key;

        private SQLVariable(String string) {
            this.key = string;
        }

        public Object get(Object object) throws ExpressionEvaluationException {
            try {
                return ((RowSet)object).getObject(this.key);
            }
            catch (SQLException sQLException) {
                throw new ExpressionEvaluationException("Could not find field: " + this.key, (Throwable)sQLException);
            }
        }

        public Expression.Type getType() {
            return Expression.Type.ANY;
        }
    }

    private static class SQLVariableBinder
    implements VariableBinder {
        private static final SQLVariableBinder THE_ONE = new SQLVariableBinder();

        private SQLVariableBinder() {
        }

        public Variable getVariable(String string) {
            return new SQLVariable(string);
        }
    }
}

