/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.spi.SyncProviderException;
import javax.transaction.Transaction;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.LifeCycle;
import weblogic.transaction.TransactionHelper;
import weblogic.xml.stream.XMLInputStream;

class SharedRowSetImpl
extends CachedRowSetImpl {
    SharedRowSetImpl(CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        this.baseRowSet = cachedRowSetImpl;
        this.metaData = (CachedRowSetMetaData)this.baseRowSet.metaData.clone();
        this.command = this.baseRowSet.command;
        this.dataSourceName = this.baseRowSet.dataSourceName;
        this.dataSource = this.baseRowSet.dataSource;
        this.url = this.baseRowSet.url;
        this.userName = this.baseRowSet.userName;
        this.password = this.baseRowSet.password;
        this.isolationLevel = this.baseRowSet.isolationLevel;
        this.fetchDirection = this.baseRowSet.fetchDirection;
        this.fetchSize = this.baseRowSet.fetchSize;
        this.typeMap = this.baseRowSet.typeMap;
        this.queryTimeout = this.baseRowSet.queryTimeout;
        this.maxRows = this.baseRowSet.maxRows;
        this.maxFieldSize = this.baseRowSet.maxFieldSize;
        this.escapeProcessing = this.baseRowSet.escapeProcessing;
        this.concurrency = this.baseRowSet.concurrency;
        this.resultSetType = this.baseRowSet.resultSetType;
        this.preferDataSource = this.baseRowSet.preferDataSource;
        this.insertRow = null;
        this.rowSetListeners = new ArrayList();
        this.cachedConnection = null;
        this.pendingConnection = null;
        this.params = new ArrayList();
        this.state = LifeCycle.POPULATING;
        this.repopulate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repopulate() throws SQLException {
        this.checkOp(2);
        this.allrows.clear();
        this.rows.clear();
        this.baseRowSet.lock();
        int n = this.currentPage * this.maxRows;
        try {
            int n2 = 0;
            for (int i = n; i < this.baseRowSet.allrows.size() && (this.maxRows == 0 || n2 <= this.maxRows); ++i) {
                CachedRow cachedRow = (CachedRow)this.baseRowSet.allrows.get(i);
                if (cachedRow.isInsertRow()) continue;
                this.allrows.add(cachedRow.createShared(this.metaData));
                ++n2;
            }
            Object var6_5 = null;
            this.baseRowSet.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.baseRowSet.unlock();
            throw throwable;
        }
        this.filter();
        this.pendingConnection = null;
        this.baseRowSet.attach(this);
    }

    public void populate(ResultSetMetaData resultSetMetaData) throws SQLException {
        throw new SQLException("populate is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    public void populate(ResultSet resultSet) throws SQLException {
        throw new SQLException("populate is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    public void execute() throws SQLException {
        this.repopulate();
        this.rowSetChanged();
    }

    public void execute(Connection connection) throws SQLException {
        this.execute();
    }

    public String executeAndGuessTableName() throws SQLException {
        this.execute();
        return this.metaData.getQualifiedTableName(1);
    }

    public boolean executeAndGuessTableNameAndPrimaryKeys() throws SQLException {
        this.execute();
        return true;
    }

    void updateMemory() throws SQLException {
        for (CachedRow cachedRow : this.getCachedRows()) {
            if (cachedRow.isDeletedRow()) {
                this.allrows.remove(cachedRow);
                this.baseRowSet.allrows.remove(cachedRow.getBaseRow());
            } else if (cachedRow.isInsertRow()) {
                CachedRow cachedRow2 = (CachedRow)cachedRow.clone((CachedRowSetMetaData)this.baseRowSet.getMetaData());
                this.baseRowSet.allrows.add(cachedRow2);
            } else if (cachedRow.isUpdatedRow()) {
                cachedRow.getBaseRow().copyFrom(cachedRow);
            }
            cachedRow.acceptChanges();
        }
        this.filter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void acceptChanges() throws SyncProviderException {
        block29: {
            if (this.isReadOnly()) {
                return;
            }
            Connection connection = null;
            Throwable throwable = null;
            boolean bl = false;
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            try {
                if (transaction != null && transaction.getStatus() == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                throw new SyncProviderException("failed");
            }
            if (bl) {
                if (this.cachedConnection != null) {
                    try {
                        this.cachedConnection.close();
                    }
                    catch (Exception exception) {
                        throw new SyncProviderException("failed");
                    }
                    this.cachedConnection = null;
                }
                if ((connection = this.getConnection()) == null) {
                    throw new SyncProviderException("failed");
                }
                this.state = this.state.checkOp(9);
                throwable = this.sync(connection);
                if (throwable != null) {
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (Exception exception) {
                        throw new SyncProviderException("failed");
                    }
                }
            } else {
                connection = this.getConnection();
                connection.setAutoCommit(false);
                this.state = this.state.checkOp(10);
                this.baseRowSet.lock();
                try {
                    throwable = this.sync(connection);
                    if (throwable == null) {
                        connection.commit();
                        this.updateMemory();
                    } else {
                        connection.rollback();
                    }
                    Object var7_9 = null;
                    this.baseRowSet.unlock();
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    this.baseRowSet.unlock();
                    throw throwable2;
                }
            }
            Object var9_12 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cachedConnection = null;
            if (throwable != null) {
                if (throwable instanceof SyncProviderException) {
                    throw (SyncProviderException)throwable;
                }
                throw new SyncProviderException(throwable.toString());
            }
            break block29;
            {
                catch (Exception exception) {
                    throw new SyncProviderException(exception.toString());
                }
            }
            catch (Throwable throwable3) {
                Object var9_13 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cachedConnection = null;
                if (throwable != null) {
                    if (throwable instanceof SyncProviderException) {
                        throw (SyncProviderException)throwable;
                    }
                    throw new SyncProviderException(throwable.toString());
                }
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acceptChanges(Connection connection) throws SyncProviderException {
        block22: {
            if (this.isReadOnly()) {
                return;
            }
            if (connection == null) {
                throw new SyncProviderException("acceptChanges(java.sql.Connection conn) can not be invoked with null conn");
            }
            SQLException sQLException = null;
            boolean bl = false;
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            try {
                if (transaction != null && transaction.getStatus() == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                throw new SyncProviderException("failed");
            }
            try {
                block21: {
                    try {
                        if (bl) {
                            this.state = this.state.checkOp(9);
                            sQLException = this.sync(connection);
                            if (sQLException == null) break block21;
                            try {
                                transaction.setRollbackOnly();
                                break block21;
                            }
                            catch (Exception exception) {
                                throw new SyncProviderException("failed");
                            }
                        }
                        if (connection == null) {
                            throw new SyncProviderException("failed");
                        }
                        if (connection.getAutoCommit()) {
                            connection.setAutoCommit(false);
                            this.state = this.state.checkOp(10);
                            this.baseRowSet.lock();
                            try {
                                sQLException = this.sync(connection);
                                if (sQLException == null) {
                                    connection.commit();
                                    this.updateMemory();
                                } else {
                                    connection.rollback();
                                }
                                Object var7_8 = null;
                                this.baseRowSet.unlock();
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                this.baseRowSet.unlock();
                                connection.setAutoCommit(true);
                                throw throwable;
                            }
                            connection.setAutoCommit(true);
                            break block21;
                        }
                        this.state = this.state.checkOp(9);
                        sQLException = this.sync(connection);
                        this.pendingConnection = connection;
                    }
                    catch (Exception exception) {
                        throw new SyncProviderException(exception.toString());
                    }
                }
                Object var9_11 = null;
                if (sQLException == null) break block22;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (sQLException == null) {
                    throw throwable;
                }
                if (sQLException instanceof SyncProviderException) {
                    throw (SyncProviderException)sQLException;
                }
                throw new SyncProviderException(sQLException.toString());
            }
            if (sQLException instanceof SyncProviderException) {
                throw (SyncProviderException)sQLException;
            }
            throw new SyncProviderException(sQLException.toString());
        }
    }

    public RowSet createShared() throws SQLException {
        return this.baseRowSet.createShared();
    }

    public CachedRowSet createCopy() throws SQLException {
        return (CachedRowSet)this.createShared();
    }

    public CachedRowSet createCopySchema() throws SQLException {
        return (CachedRowSet)this.createShared();
    }

    public CachedRowSet createCopyNoConstraints() throws SQLException {
        return (CachedRowSet)this.createShared();
    }

    protected Object clone() {
        try {
            return this.createShared();
        }
        catch (Exception exception) {
            throw new RuntimeException(this + " can not be cloned because of " + exception);
        }
    }

    public void close() {
        super.close();
        this.baseRowSet.detach(this);
    }

    protected void finalize() {
        this.close();
    }

    public void loadXML(XMLInputStream xMLInputStream) throws IOException, SQLException {
        throw new SQLException("loadXML is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    public void readXml(XMLInputStream xMLInputStream) throws IOException, SQLException {
        throw new SQLException("readXml is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    public void readXml(Reader reader) throws SQLException {
        throw new SQLException("readXml is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    public void readXml(InputStream inputStream) throws SQLException, IOException {
        throw new SQLException("readXml is not supported by SharedRowSet because SharedRowSet can only populate its data from CachedRowSet object.");
    }

    void toDesign() {
        throw new RuntimeException("Design operations are not supported by SharedRowSet because SharedRowSet populate its data from CachedRowSet object rather than DataSource.");
    }

    void toConfigQuery() {
        throw new RuntimeException("ConfigQuery operations are not supported by SharedRowSet because SharedRowSet populate its data from CachedRowSet object rather than DataSource.");
    }

    public boolean previousPage() {
        throw new RuntimeException("Method not implemented");
    }
}

