/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.util.ArrayList;
import java.util.regex.Pattern;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.ParseException;

final class TableNameParser {
    private static final String EMPTY_STRING = "";
    private static final String SCHEMA_SEPARATOR = ".";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final int PATTERN_CATALOG_SCHEMA_TABLE = 1;
    private static final int PATTERN_CATALOG_SCHEMA_TABLE_X = 2;
    private static final int PATTERN_SCHEMA_TABLE_CATALOG = 3;
    private static final int PATTERN_CATALOG_TABLE = 4;
    private static final int PATTERN_TABLE_CATALOG = 5;
    private static final int PATTERN_SCHEMA_TABLE = 6;
    private static final int PATTERN_TABLE = 7;
    private String qualifiedTableName = null;
    private DatabaseMetaDataHolder metaData = null;

    TableNameParser(String string, DatabaseMetaDataHolder databaseMetaDataHolder) throws ParseException {
        if (string == null || databaseMetaDataHolder == null) {
            throw new ParseException("Invalid parameters, construction is failed.");
        }
        this.qualifiedTableName = string.trim();
        this.metaData = databaseMetaDataHolder;
    }

    String[] parse() throws ParseException {
        String[] stringArray = null;
        int n = this.getPatternType();
        switch (n) {
            case 1: {
                stringArray = this.parsePatternCatalogSchemaTable();
                break;
            }
            case 2: {
                stringArray = this.parsePatternCatalogSchemaTableX();
                break;
            }
            case 3: {
                stringArray = this.parsePatternSchemaTableCatalog();
                break;
            }
            case 4: {
                stringArray = this.parsePatternCatalogTable();
                break;
            }
            case 5: {
                stringArray = this.parsePatternTableCatalog();
                break;
            }
            case 6: {
                stringArray = this.parsePatternSchemaTable();
                break;
            }
            case 7: {
                stringArray = this.parsePatternTable();
                break;
            }
            default: {
                throw new ParseException("Parse error, unknown pattern.");
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.metaData.supportsIdentifierQuoting() && TableNameParser.isQuotedIdentifier(stringArray[i], this.metaData.getIdentifierQuoteString())) {
                if (this.metaData.storesUpperCaseQuotedIdentifiers()) {
                    stringArray[i] = stringArray[i].toUpperCase();
                    continue;
                }
                if (!this.metaData.storesLowerCaseQuotedIdentifiers()) continue;
                stringArray[i] = stringArray[i].toLowerCase();
                continue;
            }
            if (!TableNameParser.isValidIdentifier(stringArray[i])) {
                throw new ParseException("Parse error, identifier should not contain whitespace characters, expected <" + this.getPatternName(n) + ">, " + "got <" + this.qualifiedTableName + ">");
            }
            if (this.metaData.storesUpperCaseIdentifiers()) {
                stringArray[i] = stringArray[i].toUpperCase();
                continue;
            }
            if (!this.metaData.storesLowerCaseIdentifiers()) continue;
            stringArray[i] = stringArray[i].toLowerCase();
        }
        if (stringArray[0].length() > this.metaData.getMaxCatalogNameLength()) {
            throw new ParseException("Parse error, catalog name length must <= " + this.metaData.getMaxCatalogNameLength() + SCHEMA_SEPARATOR);
        }
        if (stringArray[1].length() > this.metaData.getMaxSchemaNameLength()) {
            throw new ParseException("Parse error, schema name length must <= " + this.metaData.getMaxSchemaNameLength() + SCHEMA_SEPARATOR);
        }
        if (stringArray[2].length() > this.metaData.getMaxTableNameLength()) {
            throw new ParseException("Parse error, table name length must <= " + this.metaData.getMaxTableNameLength() + SCHEMA_SEPARATOR);
        }
        return stringArray;
    }

    private int getPatternType() {
        if (this.metaData.supportsCatalogsInDataManipulation()) {
            if (this.metaData.supportsSchemasInDataManipulation()) {
                if (SCHEMA_SEPARATOR.equals(this.metaData.getCatalogSeparator())) {
                    return 1;
                }
                if (this.metaData.isCatalogAtStart()) {
                    return 2;
                }
                return 3;
            }
            if (this.metaData.isCatalogAtStart()) {
                return 4;
            }
            return 5;
        }
        if (this.metaData.supportsSchemasInDataManipulation()) {
            return 6;
        }
        return 7;
    }

    private String getPatternName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "[[catalog.]schema.]table";
                break;
            }
            case 2: {
                string = "[[catalog" + this.metaData.getCatalogSeparator() + "]schema" + SCHEMA_SEPARATOR + "]table";
                break;
            }
            case 3: {
                string = "[schema.]table[" + this.metaData.getCatalogSeparator() + "catalog]";
                break;
            }
            case 4: {
                string = "[catalog" + this.metaData.getCatalogSeparator() + "]table";
                break;
            }
            case 5: {
                string = "table[" + this.metaData.getCatalogSeparator() + "catalog]";
                break;
            }
            case 6: {
                string = "[schema.]table";
                break;
            }
            case 7: {
                string = "table";
                break;
            }
            default: {
                string = "Unknown pattern";
            }
        }
        return string;
    }

    private String[] parsePatternCatalogSchemaTable() throws ParseException {
        String[] stringArray = null;
        stringArray = this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) ? TableNameParser.parseQuotedFull(this.qualifiedTableName, SCHEMA_SEPARATOR, this.getPatternName(1), this.metaData.getIdentifierQuoteString()) : TableNameParser.parseFull(this.qualifiedTableName, SCHEMA_SEPARATOR, this.getPatternName(1));
        if (stringArray.length == 1) {
            return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray[0]};
        }
        if (stringArray.length == 2) {
            return new String[]{EMPTY_STRING, stringArray[0], stringArray[1]};
        }
        return stringArray;
    }

    private String[] parsePatternCatalogSchemaTableX() throws ParseException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        boolean bl = false;
        if (this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString())) {
            bl = true;
        }
        if ((stringArray = bl ? TableNameParser.parseQuotedPart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(2), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(2))).length == 1) {
            stringArray2 = bl ? TableNameParser.parseQuotedPart(stringArray[0], SCHEMA_SEPARATOR, this.getPatternName(6), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(stringArray[0], SCHEMA_SEPARATOR, this.getPatternName(6));
            if (stringArray2.length == 1) {
                return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray2[0]};
            }
            return new String[]{EMPTY_STRING, stringArray2[0], stringArray2[1]};
        }
        stringArray2 = bl ? TableNameParser.parseQuotedPart(stringArray[1], SCHEMA_SEPARATOR, this.getPatternName(6), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(stringArray[1], SCHEMA_SEPARATOR, this.getPatternName(6));
        if (stringArray2.length == 1) {
            return new String[]{stringArray[0], EMPTY_STRING, stringArray2[0]};
        }
        return new String[]{stringArray[0], stringArray2[0], stringArray2[1]};
    }

    private String[] parsePatternSchemaTableCatalog() throws ParseException {
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString())) {
            stringArray = TableNameParser.parseQuotedPart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(3), this.metaData.getIdentifierQuoteString());
            stringArray2 = TableNameParser.parseQuotedPart(stringArray[0], SCHEMA_SEPARATOR, this.getPatternName(6), this.metaData.getIdentifierQuoteString());
        } else {
            stringArray = TableNameParser.parsePart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(3));
            stringArray2 = TableNameParser.parsePart(stringArray[0], SCHEMA_SEPARATOR, this.getPatternName(6));
        }
        if (stringArray.length == 1) {
            if (stringArray2.length == 1) {
                return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray2[0]};
            }
            return new String[]{EMPTY_STRING, stringArray2[0], stringArray2[1]};
        }
        if (stringArray2.length == 1) {
            return new String[]{stringArray[1], EMPTY_STRING, stringArray2[0]};
        }
        return new String[]{stringArray[1], stringArray2[0], stringArray2[1]};
    }

    private String[] parsePatternCatalogTable() throws ParseException {
        String[] stringArray = null;
        stringArray = this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) ? TableNameParser.parseQuotedPart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(4), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(4));
        if (stringArray.length == 1) {
            return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray[0]};
        }
        return new String[]{stringArray[0], EMPTY_STRING, stringArray[1]};
    }

    private String[] parsePatternTableCatalog() throws ParseException {
        String[] stringArray = null;
        stringArray = this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) ? TableNameParser.parseQuotedPart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(5), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(this.qualifiedTableName, this.metaData.getCatalogSeparator(), this.getPatternName(5));
        if (stringArray.length == 1) {
            return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray[0]};
        }
        return new String[]{stringArray[1], EMPTY_STRING, stringArray[0]};
    }

    private String[] parsePatternSchemaTable() throws ParseException {
        String[] stringArray = null;
        stringArray = this.metaData.supportsIdentifierQuoting() && this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) ? TableNameParser.parseQuotedPart(this.qualifiedTableName, SCHEMA_SEPARATOR, this.getPatternName(6), this.metaData.getIdentifierQuoteString()) : TableNameParser.parsePart(this.qualifiedTableName, SCHEMA_SEPARATOR, this.getPatternName(6));
        if (stringArray.length == 1) {
            return new String[]{EMPTY_STRING, EMPTY_STRING, stringArray[0]};
        }
        return new String[]{EMPTY_STRING, stringArray[0], stringArray[1]};
    }

    private String[] parsePatternTable() throws ParseException {
        if (this.qualifiedTableName == null || !EMPTY_STRING.equals(this.qualifiedTableName) || this.metaData.supportsIdentifierQuoting() && (!this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) && this.qualifiedTableName.contains(SCHEMA_SEPARATOR) || this.qualifiedTableName.contains(this.metaData.getIdentifierQuoteString()) && !TableNameParser.isQuotedIdentifier(this.qualifiedTableName, this.metaData.getIdentifierQuoteString()))) {
            throw new ParseException("Parse error, expected <" + this.getPatternName(7) + ">, " + "got <" + this.qualifiedTableName + ">");
        }
        return new String[]{EMPTY_STRING, EMPTY_STRING, this.qualifiedTableName};
    }

    private static String[] parseFull(String string, String string2, String string3) throws ParseException {
        String[] stringArray;
        if (string == null || EMPTY_STRING.equals(string)) {
            throw new ParseException("Parse error, parsed string should not be empty.");
        }
        if (string2 == null || EMPTY_STRING.equals(string2)) {
            throw new ParseException("Parse error, separator should not be empty.");
        }
        if (SCHEMA_SEPARATOR.equals(string2)) {
            string2 = "\\" + string2;
        }
        if ((stringArray = string.split(string2)).length == 0 || stringArray.length > 3 || stringArray.length >= 1 && stringArray[0].length() == 0 || stringArray.length >= 2 && stringArray[1].length() == 0 || stringArray.length >= 3 && stringArray[2].length() == 0) {
            throw new ParseException("Parse error, expected <" + string3 + ">, " + "got <" + string + ">");
        }
        return stringArray;
    }

    private static String[] parseQuotedFull(String string, String string2, String string3, String string4) throws ParseException {
        if (string == null || EMPTY_STRING.equals(string)) {
            throw new ParseException("Parse error, parsed string should not be empty.");
        }
        if (string2 == null || EMPTY_STRING.equals(string2)) {
            throw new ParseException("Parse error, separator should not be empty.");
        }
        String[] stringArray = TableNameParser.split(string, string2, string4);
        if (stringArray.length == 0 || stringArray.length > 3 || stringArray.length >= 1 && stringArray[0].length() == 0 || stringArray.length >= 2 && stringArray[1].length() == 0 || stringArray.length >= 3 && stringArray[2].length() == 0 || !TableNameParser.isQuotedIdentifiers(stringArray, string4)) {
            throw new ParseException("Parse error, expected <" + string3 + ">, " + "got <" + string + ">");
        }
        return stringArray;
    }

    private static String[] parsePart(String string, String string2, String string3) throws ParseException {
        String[] stringArray;
        if (string == null || EMPTY_STRING.equals(string)) {
            throw new ParseException("Parse error, string to be parsed should not be empty.");
        }
        if (string2 == null || EMPTY_STRING.equals(string2)) {
            throw new ParseException("Parse error, separator should not be empty.");
        }
        if (SCHEMA_SEPARATOR.equals(string2)) {
            string2 = "\\" + string2;
        }
        if ((stringArray = string.split(string2)).length == 0 || stringArray.length > 2 || stringArray.length >= 1 && stringArray[0].length() == 0 || stringArray.length >= 2 && stringArray[1].length() == 0) {
            throw new ParseException("Parse error, expected <" + string3 + ">, " + "got <" + string + ">");
        }
        return stringArray;
    }

    private static String[] parseQuotedPart(String string, String string2, String string3, String string4) throws ParseException {
        if (string == null || EMPTY_STRING.equals(string)) {
            throw new ParseException("Parse error, string to be parsed should not be empty.");
        }
        if (string2 == null || EMPTY_STRING.equals(string2)) {
            throw new ParseException("Parse error, separator should not be empty.");
        }
        String[] stringArray = TableNameParser.split(string, string2, string4);
        if (stringArray.length == 0 || stringArray.length > 2 || stringArray.length >= 1 && stringArray[0].length() == 0 || stringArray.length >= 2 && stringArray[1].length() == 0 || !TableNameParser.isQuotedIdentifiers(stringArray, string4)) {
            throw new ParseException("Parse error, expected <" + string3 + ">, " + "got <" + string + ">");
        }
        return stringArray;
    }

    private static String[] split(String string, String string2, String string3) throws ParseException {
        Integer[] integerArray = TableNameParser.getQuoteStringPositions(string, string3);
        if (integerArray.length % 2 != 0 || integerArray.length < 2 || integerArray.length > 6) {
            throw new ParseException("Parse error, string to be parsed is invalid.");
        }
        int n = -string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n2 = string.indexOf(string2, n + string2.length());
            while (n2 != -1 && !TableNameParser.isValidSeparator(string2, n2, string3, integerArray)) {
                n2 = string.indexOf(string2, n2 + string2.length());
            }
            if (n2 == -1) break;
            arrayList.add(string.substring(n + string2.length(), n2));
            n = n2;
        }
        arrayList.add(string.substring(n + string2.length()));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Integer[] getQuoteStringPositions(String string, String string2) {
        if (string == null || EMPTY_STRING.equals(string) || string2 == null || EMPTY_STRING.equals(string2)) {
            return new Integer[0];
        }
        int n = -string2.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while ((n = string.indexOf(string2, n + string2.length())) != -1) {
            arrayList.add(n);
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    private static boolean isValidSeparator(String string, int n, String string2, Integer[] integerArray) {
        if (n + string.length() <= integerArray[0] || integerArray[integerArray.length - 1] + string2.length() <= n) {
            return true;
        }
        for (int i = 0; i < integerArray.length; i += 2) {
            if (integerArray[i] + string2.length() > n || n + string.length() > integerArray[i + 1]) continue;
            return false;
        }
        return true;
    }

    private static boolean isQuotedIdentifiers(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!TableNameParser.isQuotedIdentifier(string2, string)) continue;
            return true;
        }
        return false;
    }

    static boolean isQuotedIdentifier(String string, String string2) {
        return string.startsWith(string2) && string.endsWith(string2);
    }

    private static boolean isValidIdentifier(String string) {
        return !WHITESPACE_PATTERN.matcher(string).matches();
    }

    boolean identifierEqual(String string, String string2) {
        if (string2 == null || EMPTY_STRING.equals(string2)) {
            return true;
        }
        if (string == null || EMPTY_STRING.equals(string)) {
            return false;
        }
        if (this.metaData.supportsIdentifierQuoting()) {
            String string3 = this.metaData.getIdentifierQuoteString();
            if (TableNameParser.isQuotedIdentifier(string2, string3)) {
                string2 = string2.replace(string3, EMPTY_STRING);
            }
            if (TableNameParser.isQuotedIdentifier(string, string3)) {
                string = string.replace(string3, EMPTY_STRING);
            }
        }
        return string2.equals(string);
    }
}

