/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.CharArrayReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.OptimisticConflictException;
import weblogic.jdbc.rowset.WLRowSetInternal;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.utils.AssertionError;
import weblogic.utils.PlatformConstants;

public class TableWriter
implements PlatformConstants {
    protected static final ColumnFilter ALL = new ColumnFilter(){

        public boolean include(int n) {
            return true;
        }
    };
    private final boolean verbose = false;
    protected final String tableName;
    protected final BitSet columnMask;
    private final WLRowSetInternal rowSet;
    protected final WLRowSetMetaData metaData;
    protected final int columnCount;
    private final boolean batchInserts;
    protected boolean batchDeletes;
    private final boolean batchUpdates;
    protected boolean groupDeletes;
    protected final boolean verboseSQL;
    protected DebugLogger JDBCRowsetDebug = null;
    private final Map batchMap;
    private List groupDeleteList = Collections.EMPTY_LIST;
    private String __dont_touch_me_insert_statement = null;
    private String __dont_touch_me_update_header = null;
    private String __dont_touch_me_delete_header = null;
    private final int groupDeleteSize;
    protected boolean checkBatchUpdateCounts = true;
    protected List batchVerifyParams = Collections.EMPTY_LIST;
    protected final int batchVerifySize;

    public TableWriter(WLRowSetInternal wLRowSetInternal, String string, BitSet bitSet) throws SQLException {
        this.rowSet = wLRowSetInternal;
        this.tableName = string;
        this.columnMask = bitSet;
        this.metaData = (WLRowSetMetaData)wLRowSetInternal.getMetaData();
        this.columnCount = this.metaData.getColumnCount();
        this.batchInserts = this.metaData.getBatchInserts();
        this.batchDeletes = this.metaData.getBatchDeletes();
        this.batchUpdates = this.metaData.getBatchUpdates();
        this.groupDeletes = this.metaData.getGroupDeletes();
        this.verboseSQL = this.metaData.getVerboseSQL();
        this.groupDeleteSize = this.metaData.getGroupDeleteSize();
        this.batchVerifySize = this.metaData.getBatchVerifySize();
        if (this.verboseSQL && this.JDBCRowsetDebug == null) {
            this.JDBCRowsetDebug = DebugLogger.createUnregisteredDebugLogger((String)"JDBCRowset", (boolean)true);
        }
        this.batchMap = this.batchInserts || this.batchDeletes || this.batchUpdates ? new HashMap() : Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueSQL(Connection connection) throws SQLException {
        this.groupDeleteList = this.groupDeletes ? new ArrayList() : Collections.EMPTY_LIST;
        if (!this.checkBatchUpdateCounts) {
            this.batchVerifyParams = new ArrayList();
        }
        try {
            for (CachedRow cachedRow : this.rowSet.getCachedRows()) {
                if (cachedRow.isInsertRow() && cachedRow.isDeletedRow()) continue;
                if (cachedRow.isInsertRow() && cachedRow.isUpdatedRow()) {
                    this.updateRow(connection, cachedRow);
                    continue;
                }
                if (cachedRow.isInsertRow()) {
                    this.insertRow(connection, cachedRow);
                    continue;
                }
                if (cachedRow.isDeletedRow()) {
                    this.deleteRow(connection, cachedRow);
                    continue;
                }
                if (!cachedRow.isUpdatedRow()) continue;
                this.updateRow(connection, cachedRow);
            }
            this.executeGroupDeletes(connection);
            this.executeBatchVerifySelects(connection);
            this.executeBatches();
            this.updateLOBs(connection);
            Object var5_4 = null;
            this.cleanupBatches();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanupBatches();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertRow(Connection connection, CachedRow cachedRow) throws SQLException {
        Object[] objectArray = cachedRow.getColumns();
        if (this.verboseSQL) {
            this.printSQL(this.getInsertStatement(), objectArray, new AutoIncFilter(this.metaData));
        }
        if (this.batchInserts) {
            PreparedStatement preparedStatement2 = this.getBatchPS(connection, this.getInsertStatement());
            this.setInsertParameters(connection, preparedStatement2, objectArray);
            preparedStatement2.addBatch();
            return;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.getInsertStatement());
            this.setInsertParameters(connection, preparedStatement, objectArray);
            if (preparedStatement.executeUpdate() == 0) {
                this.throwOCE(this.formatSQL(this.getInsertStatement(), objectArray, new AutoIncFilter(this.metaData)), cachedRow);
            }
            Object var6_6 = null;
            if (preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (preparedStatement == null) throw throwable;
            try {
                preparedStatement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        preparedStatement.close();
    }

    protected BitSet getModifiedColumns(CachedRow cachedRow) {
        return cachedRow.getModifiedColumns();
    }

    protected Object insertedObject(Connection connection, Object object) {
        return object;
    }

    protected Object updatedObject(Object object) {
        return object;
    }

    protected void executeBatchVerifySelects(Connection connection) throws SQLException {
    }

    protected void updateLOBs(Connection connection) throws SQLException {
    }

    private void printSQL(String string) {
        this.JDBCRowsetDebug.debug(string);
    }

    private void printSQL(String string, Object[] objectArray, ColumnFilter columnFilter, Object[] objectArray2, ColumnFilter columnFilter2) throws SQLException {
        this.JDBCRowsetDebug.debug(this.formatSQL(string, objectArray, columnFilter, objectArray2, columnFilter2));
    }

    private String formatSQL(String string, Object[] objectArray, ColumnFilter columnFilter, Object[] objectArray2, ColumnFilter columnFilter2) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(EOL);
        stringBuffer.append("PARAMETERS: ");
        String string2 = "";
        for (n = 0; n < objectArray.length; ++n) {
            if (!this.columnMask.get(n) || !columnFilter.include(n) || this.metaData.isAutoIncrement(n + 1)) continue;
            stringBuffer.append(string2);
            string2 = ", ";
            if (objectArray[n] == null) {
                stringBuffer.append("<NULL>");
                continue;
            }
            stringBuffer.append(objectArray[n].toString());
        }
        for (n = 0; n < objectArray2.length; ++n) {
            if (!this.columnMask.get(n) || !columnFilter2.include(n) || this.isLOB(n) || objectArray2[n] == null) continue;
            stringBuffer.append(string2);
            string2 = ", ";
            stringBuffer.append(objectArray2[n].toString());
        }
        return stringBuffer.toString();
    }

    protected void printSQL(String string, Object[] objectArray, ColumnFilter columnFilter) throws SQLException {
        this.JDBCRowsetDebug.debug(this.formatSQL(string, objectArray, columnFilter));
    }

    private String formatSQL(String string, Object[] objectArray, ColumnFilter columnFilter) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(EOL);
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append("PARAMETERS: ");
            String string2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.columnMask.get(i) || !columnFilter.include(i)) continue;
                stringBuffer.append(string2);
                string2 = ", ";
                if (objectArray[i] == null) {
                    stringBuffer.append("<NULL>");
                    continue;
                }
                stringBuffer.append(objectArray[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    protected void printSQL(String string, Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(EOL);
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append("PARAMETERS: ");
            String string2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(string2);
                string2 = ", ";
                if (objectArray[i] == null) {
                    stringBuffer.append("<NULL>");
                    continue;
                }
                stringBuffer.append(objectArray[i].toString());
            }
        }
        this.JDBCRowsetDebug.debug(stringBuffer.toString());
    }

    private void executeGroupDeletes(Connection connection) throws SQLException {
        if (this.groupDeleteList.isEmpty()) {
            return;
        }
        int n = 0;
        do {
            this.executeGroupDeletes(connection, n);
        } while ((n += this.groupDeleteSize) < this.groupDeleteList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeGroupDeletes(Connection connection, int n) throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append(this.getDeleteHeader()).append("WHERE ");
        String string = "";
        int n2 = Math.min(n + this.groupDeleteSize, this.groupDeleteList.size());
        for (int i = n; i < n2; ++i) {
            stringBuffer.append(string);
            string = " OR ";
            object = (GroupDelete)this.groupDeleteList.get(i);
            stringBuffer.append(((GroupDelete)object).getWhereClause());
        }
        String string2 = stringBuffer.toString();
        if (this.verboseSQL) {
            this.printSQL(string2);
        }
        object = null;
        try {
            object = connection.prepareStatement(string2);
            int n3 = 1;
            for (int i = n; i < n2; ++i) {
                GroupDelete groupDelete = (GroupDelete)this.groupDeleteList.get(i);
                n3 = this.setWhereParameters((PreparedStatement)object, groupDelete.getCols(), groupDelete.getFilter(), n3);
            }
            if (object.executeUpdate() != n2 - n) {
                this.throwOCE(string2, null);
            }
            Object var12_12 = null;
            if (object == null) return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (object == null) throw throwable;
            try {
                object.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            object.close();
            return;
        }
        catch (Exception exception) {}
    }

    protected void throwOCE(String string, CachedRow cachedRow2) throws OptimisticConflictException {
        Connection connection = null;
        try {
            if (!this.metaData.haveSetPKColumns()) {
                throw new OptimisticConflictException("You must use the WLRowSetMetaData.setPrimaryKeyColumn() method to establish primary key columns before updating rows.");
            }
            StringBuffer stringBuffer = new StringBuffer(500);
            String string2 = "";
            for (int i = 0; i < this.columnCount; ++i) {
                if (!this.metaData.isPrimaryKeyColumn(i + 1) || !this.tableName.equals(this.metaData.getQualifiedTableName(i + 1))) continue;
                stringBuffer.append(string2).append(this.metaData.getWriteColumnName(i + 1));
                stringBuffer.append(" = ?");
                string2 = " AND ";
            }
            String string3 = stringBuffer.toString();
            if ("".equals(string3)) {
                throw new OptimisticConflictException("You must use the WLRowSetMetaData.setPrimaryKeyColumn() method to establish primary key columns for table " + this.tableName);
            }
            stringBuffer = new StringBuffer(500);
            string2 = "";
            int[] nArray = new int[this.columnCount];
            int n = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                if (!this.tableName.equals(this.metaData.getQualifiedTableName(i + 1))) continue;
                stringBuffer.append(string2).append(this.metaData.getWriteColumnName(i + 1));
                nArray[n++] = i;
                string2 = ", ";
            }
            if (n < this.columnCount) {
                nArray[n] = -1;
            }
            String string4 = "SELECT " + stringBuffer.toString() + " FROM " + this.tableName + " WHERE " + string3;
            if (this.verboseSQL) {
                this.printSQL(string4);
            }
            connection = this.rowSet.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            if (cachedRow2 == null) {
                for (CachedRow cachedRow2 : this.rowSet.getCachedRows()) {
                    if (!cachedRow2.isInsertRow() && !cachedRow2.isDeletedRow() && !cachedRow2.isUpdatedRow()) continue;
                    int n2 = 1;
                    for (int i = 1; i <= this.columnCount; ++i) {
                        if (!this.metaData.isPrimaryKeyColumn(i) || !this.tableName.equals(this.metaData.getQualifiedTableName(i))) continue;
                        this.setObject(preparedStatement, n2++, i - 1, cachedRow2.getColumn(i));
                    }
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet != null && resultSet.next()) {
                        if (!(!cachedRow2.setConflictValue(resultSet, nArray) || cachedRow2.isInsertRow() && cachedRow2.isDeletedRow())) {
                            if (cachedRow2.isDeletedRow()) {
                                cachedRow2.setStatus(1);
                            } else if (cachedRow2.isUpdatedRow()) {
                                cachedRow2.setStatus(0);
                            } else if (cachedRow2.isInsertRow()) {
                                cachedRow2.setStatus(2);
                            }
                        }
                        resultSet.close();
                        continue;
                    }
                    if (cachedRow2.isInsertRow() && cachedRow2.isDeletedRow()) continue;
                    if (cachedRow2.isUpdatedRow()) {
                        cachedRow2.setStatus(0);
                        continue;
                    }
                    if (!cachedRow2.isInsertRow()) continue;
                    cachedRow2.setStatus(2);
                }
            } else {
                int n3 = 1;
                for (int i = 1; i <= this.columnCount; ++i) {
                    if (!this.metaData.isPrimaryKeyColumn(i) || !this.tableName.equals(this.metaData.getQualifiedTableName(i))) continue;
                    this.setObject(preparedStatement, n3++, i - 1, cachedRow2.getColumn(i));
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null && resultSet.next()) {
                    cachedRow2.setConflictValue(resultSet, nArray);
                    resultSet.close();
                }
                if (!cachedRow2.isInsertRow() || !cachedRow2.isDeletedRow()) {
                    if (cachedRow2.isDeletedRow()) {
                        cachedRow2.setStatus(1);
                    } else if (cachedRow2.isUpdatedRow()) {
                        cachedRow2.setStatus(0);
                    } else if (cachedRow2.isInsertRow()) {
                        cachedRow2.setStatus(2);
                    }
                }
            }
            this.rowSet.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new OptimisticConflictException("Optimistic conflict when issuing sql: " + string, (CachedRowSetImpl)this.rowSet);
    }

    private PreparedStatement getBatchPS(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.batchMap.get(string);
        if (preparedStatement == null) {
            preparedStatement = connection.prepareStatement(string);
            this.batchMap.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    private void executeBatches() throws SQLException {
        for (String string : this.batchMap.keySet()) {
            PreparedStatement preparedStatement = (PreparedStatement)this.batchMap.get(string);
            int[] nArray = preparedStatement.executeBatch();
            if (nArray == null) {
                throw new SQLException("The JDBC Driver returned null from PreparedStatement.executeBatch().  The executed SQL was: " + string);
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    this.throwOCE(string, null);
                    continue;
                }
                if (this.checkBatchUpdateCounts && nArray[i] == -2) {
                    throw new SQLException("The Batch update with SQL: " + string + " returned Statement.SUCCESS_NO_INFO indicating " + "the statement was successful, but we are unable to " + "determine whether an Optimistic conflict occurred.");
                }
                if (nArray[i] != -3) continue;
                throw new SQLException("The Batch update with SQL: " + string + " returned Statement.EXECUTE_FAILED indicating " + "the statement execution failed without providing" + " any additional information.");
            }
        }
    }

    private void cleanupBatches() {
        for (PreparedStatement preparedStatement : this.batchMap.values()) {
            try {
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        this.batchMap.clear();
    }

    private void setObject(PreparedStatement preparedStatement, int n, int n2, Object object) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, this.metaData.getColumnType(n2 + 1));
        } else if (this.metaData.getColumnType(n2 + 1) == 91) {
            if (object instanceof Calendar) {
                preparedStatement.setDate(n, new Date(((Calendar)object).getTimeInMillis()));
            } else if (object instanceof java.util.Date) {
                preparedStatement.setDate(n, new Date(((java.util.Date)object).getTime()));
            } else {
                preparedStatement.setObject(n, object, this.metaData.getColumnType(n2 + 1));
            }
        } else if (object instanceof Integer) {
            preparedStatement.setInt(n, (Integer)object);
        } else if (object instanceof Float) {
            preparedStatement.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof char[]) {
            preparedStatement.setCharacterStream(n, (Reader)new CharArrayReader((char[])object), ((char[])object).length);
        } else {
            preparedStatement.setObject(n, object, this.metaData.getColumnType(n2 + 1));
        }
    }

    private void setInsertParameters(Connection connection, PreparedStatement preparedStatement, Object[] objectArray) throws SQLException {
        int n = 1;
        for (int i = 0; i < this.columnMask.length(); ++i) {
            if (!this.columnMask.get(i) || this.metaData.isAutoIncrement(i + 1)) continue;
            this.setObject(preparedStatement, n++, i, this.insertedObject(connection, objectArray[i]));
        }
    }

    private int setWhereParameters(PreparedStatement preparedStatement, Object[] objectArray, ColumnFilter columnFilter) throws SQLException {
        return this.setWhereParameters(preparedStatement, objectArray, columnFilter, 1);
    }

    protected int setWhereParameters(PreparedStatement preparedStatement, Object[] objectArray, ColumnFilter columnFilter, int n) throws SQLException {
        for (int i = 0; i < this.columnMask.length(); ++i) {
            if (!this.columnMask.get(i) || !columnFilter.include(i) || objectArray[i] == null || this.isLOB(i)) continue;
            this.setObject(preparedStatement, n++, i, objectArray[i]);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteRow(Connection connection, CachedRow cachedRow) throws SQLException {
        OptimisticPolicy optimisticPolicy = TableWriter.getPolicy(this.metaData.getOptimisticPolicy());
        ColumnFilter columnFilter = optimisticPolicy.getColumnFilter(this, cachedRow.getModifiedColumns());
        Object[] objectArray = null;
        objectArray = cachedRow.isUpdatedRow() ? cachedRow.getOldColumns() : cachedRow.getColumns();
        if (this.groupDeletes) {
            this.groupDeleteList.add(new GroupDelete(this.getWhereClause(objectArray, columnFilter), columnFilter, objectArray));
            return;
        }
        String string = this.getDeleteStatement(this.rowSet, objectArray, optimisticPolicy, columnFilter);
        if (this.verboseSQL) {
            this.printSQL(string, objectArray, columnFilter);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.batchDeletes ? this.getBatchPS(connection, string) : connection.prepareStatement(string);
            this.setWhereParameters(preparedStatement, objectArray, columnFilter);
            if (this.batchDeletes) {
                preparedStatement.addBatch();
            } else if (preparedStatement.executeUpdate() == 0) {
                this.throwOCE(this.formatSQL(string, objectArray, columnFilter), cachedRow);
            }
            Object var9_8 = null;
            if (this.batchDeletes || preparedStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.batchDeletes || preparedStatement == null) throw throwable;
            try {
                preparedStatement.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            preparedStatement.close();
            return;
        }
        catch (Exception exception) {}
    }

    private void updateVersionColumns(CachedRow cachedRow) throws SQLException {
        for (int i = 0; i < this.columnMask.length(); ++i) {
            if (!this.columnMask.get(i) || !this.metaData.isAutoVersionColumn(i + 1)) continue;
            Object object = cachedRow.getColumn(i + 1);
            if (object instanceof Integer) {
                int n = (Integer)object + 1;
                cachedRow.updateColumn(i + 1, new Integer(n));
                continue;
            }
            if (object instanceof Long) {
                long l = (Long)object + 1L;
                cachedRow.updateColumn(i + 1, new Long(l));
                continue;
            }
            if (object instanceof Short) {
                short s = (short)((Short)object + 1);
                cachedRow.updateColumn(i + 1, new Short(s));
                continue;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = ((BigDecimal)object).add(BigDecimal.valueOf(1L));
                cachedRow.updateColumn(i + 1, bigDecimal);
                continue;
            }
            throw new SQLException("Column: " + this.metaData.getWriteColumnName(i + 1) + " in table: " + this.tableName + " is marked as a version column, but it is not a numeric type.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateRow(Connection var1_1, CachedRow var2_2) throws SQLException {
        block17: {
            var3_3 = null;
            var4_4 = var2_2.getColumns();
            var5_5 = var2_2.getOldColumns();
            var6_6 = this.getModifiedColumns(var2_2);
            if (var2_2.isInsertRow() && var2_2.isUpdatedRow()) {
                var5_5 = var4_4;
            }
            try {
                var7_7 = var2_2.isInsertRow() != false && var2_2.isUpdatedRow() != false ? TableWriter.getPolicy(4) : TableWriter.getPolicy(this.metaData.getOptimisticPolicy());
                var8_8 = var7_7.getColumnFilter(this, var6_6);
                if (this.metaData.getOptimisticPolicy() == 5) {
                    this.updateVersionColumns(var2_2);
                }
                if ((var9_9 = this.buildUpdateSQL(this.rowSet, var2_2, var7_7, var8_8, var6_6)) != null) break block18;
                var13_10 = null;
                ** if (this.batchUpdates || var3_3 == null) goto lbl-1000
            }
            catch (Throwable var12_18) {
                var13_12 = null;
                if (!this.batchUpdates && var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (Exception var14_15) {
                        // empty catch block
                    }
                }
                throw var12_18;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (Exception var14_13) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block18: {
                    return;
                }
                if (this.verboseSQL) {
                    this.printSQL(var9_9, var4_4, new ModFilter(var6_6), var5_5, var8_8);
                }
                if (this.batchUpdates) {
                    var3_3 = this.getBatchPS(var1_1, var9_9);
                    if (!this.checkBatchUpdateCounts) {
                        this.batchVerifyParams.add(new BatchVerifyParam(this.getWhereClause(var4_4, var8_8), var8_8, var5_5));
                    }
                } else {
                    var3_3 = var1_1.prepareStatement(var9_9);
                }
                var10_16 = 1;
                for (var11_17 = 0; var11_17 < this.columnMask.length(); ++var11_17) {
                    if (!this.columnMask.get(var11_17) || !var6_6.get(var11_17) || this.metaData.isAutoIncrement(var11_17 + 1)) continue;
                    this.setObject((PreparedStatement)var3_3, var10_16++, var11_17, this.updatedObject(var4_4[var11_17]));
                }
                this.setWhereParameters((PreparedStatement)var3_3, var5_5, var8_8, var10_16);
                if (this.batchUpdates) {
                    var3_3.addBatch();
                    break block17;
                }
                if (var3_3.executeUpdate() != 0) break block17;
                this.throwOCE(this.formatSQL(var9_9, var4_4, new ModFilter(var6_6), var5_5, var8_8), var2_2);
            }
        }
        var13_11 = null;
        if (!this.batchUpdates && var3_3 != null) {
            try {
                var3_3.close();
            }
            catch (Exception var14_14) {}
        }
    }

    private String buildUpdateSQL(WLRowSetInternal wLRowSetInternal, CachedRow cachedRow, OptimisticPolicy optimisticPolicy, ColumnFilter columnFilter, BitSet bitSet) throws SQLException {
        String string = this.getSetClause(cachedRow, bitSet);
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getUpdateHeader());
        stringBuffer.append(string);
        stringBuffer.append("WHERE ");
        stringBuffer.append(this.getWhereClause(cachedRow.getOldColumns(), columnFilter));
        return stringBuffer.toString();
    }

    private String getSetClause(CachedRow cachedRow, BitSet bitSet) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.columnMask.get(i) || !bitSet.get(i) || this.metaData.isAutoIncrement(i + 1)) continue;
            bl = false;
            stringBuffer.append(string);
            stringBuffer.append(this.metaData.getWriteColumnName(i + 1));
            stringBuffer.append(" = ?");
            string = ", ";
        }
        if (bl) {
            return null;
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private String getUpdateHeader() {
        if (this.__dont_touch_me_update_header == null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("UPDATE ");
            stringBuffer.append(this.tableName);
            stringBuffer.append(" SET ");
            this.__dont_touch_me_update_header = stringBuffer.toString();
        }
        return this.__dont_touch_me_update_header;
    }

    private String getDeleteHeader() {
        if (this.__dont_touch_me_delete_header == null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("DELETE FROM ");
            stringBuffer.append(this.tableName);
            stringBuffer.append(" ");
            this.__dont_touch_me_delete_header = stringBuffer.toString();
        }
        return this.__dont_touch_me_delete_header;
    }

    private String getInsertStatement() throws SQLException {
        if (this.__dont_touch_me_insert_statement == null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(this.tableName);
            stringBuffer.append(" (");
            String string = "";
            int n2 = 0;
            for (n = 0; n < this.columnCount; ++n) {
                if (!this.columnMask.get(n) || this.metaData.isAutoIncrement(n + 1)) continue;
                ++n2;
                stringBuffer.append(string);
                stringBuffer.append(this.metaData.getWriteColumnName(n + 1));
                string = ", ";
            }
            stringBuffer.append(") VALUES (");
            string = "";
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(string);
                stringBuffer.append("?");
                string = ", ";
            }
            stringBuffer.append(")");
            this.__dont_touch_me_insert_statement = stringBuffer.toString();
        }
        return this.__dont_touch_me_insert_statement;
    }

    private String getDeleteStatement(WLRowSetInternal wLRowSetInternal, Object[] objectArray, OptimisticPolicy optimisticPolicy, ColumnFilter columnFilter) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append(this.getDeleteHeader());
        stringBuffer.append("WHERE ");
        stringBuffer.append(this.getWhereClause(objectArray, columnFilter));
        return stringBuffer.toString();
    }

    protected boolean isLOB(int n) throws SQLException {
        int n2 = this.metaData.getColumnType(n + 1);
        return n2 == 2004 || n2 == 2005 || n2 == 2011;
    }

    protected String getWhereClause(Object[] objectArray, ColumnFilter columnFilter) throws SQLException {
        if (!this.metaData.haveSetPKColumns()) {
            throw new SQLException("You must use the WLRowSetMetaData.setPrimaryKeyColumn() method to establish primary key columns before updating rows.");
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        String string = "";
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.columnMask.get(i) || !columnFilter.include(i) || this.isLOB(i)) continue;
            stringBuffer.append(string).append(this.metaData.getWriteColumnName(i + 1));
            if (objectArray[i] == null) {
                stringBuffer.append(" IS NULL");
            } else {
                stringBuffer.append(" = ?");
            }
            string = " AND ";
        }
        return stringBuffer.toString();
    }

    private void updateRowParameters(PreparedStatement preparedStatement, WLRowSetInternal wLRowSetInternal, CachedRow cachedRow, String string, BitSet bitSet) throws SQLException {
        Object[] objectArray = cachedRow.getColumns();
        Object[] objectArray2 = cachedRow.getOldColumns();
        int n = 1;
        for (int i = 0; i < this.columnMask.length(); ++i) {
            if (!this.columnMask.get(i) || !bitSet.get(i)) continue;
            this.setObject(preparedStatement, n++, i, objectArray[i]);
        }
        ColumnFilter columnFilter = TableWriter.getPolicy(this.metaData.getOptimisticPolicy()).getColumnFilter(this, bitSet);
        for (int i = 0; i < this.columnMask.length(); ++i) {
            if (!this.columnMask.get(i) || !columnFilter.include(i)) continue;
            this.setObject(preparedStatement, n++, i, objectArray2[i]);
        }
        if (preparedStatement.executeUpdate() == 0) {
            this.throwOCE(string, cachedRow);
        }
    }

    static OptimisticPolicy getPolicy(int n) {
        switch (n) {
            case 2: {
                return OptimisticPolicy.VERIFY_MODIFIED_COLUMNS;
            }
            case 3: {
                return OptimisticPolicy.VERIFY_SELECTED_COLUMNS;
            }
            case 4: {
                return OptimisticPolicy.VERIFY_NONE;
            }
            case 5: {
                return OptimisticPolicy.VERIFY_AUTO_VERSION_COLUMNS;
            }
            case 1: {
                return OptimisticPolicy.VERIFY_READ_COLUMNS;
            }
            case 6: {
                return OptimisticPolicy.VERIFY_VERSION_COLUMNS;
            }
        }
        throw new AssertionError("Unexpected OptimisticPolicy: " + n);
    }

    protected static final class BatchVerifyParam {
        private final String whereClause;
        private final ColumnFilter filter;
        private final Object[] params;

        BatchVerifyParam(String string, ColumnFilter columnFilter, Object[] objectArray) {
            this.whereClause = string;
            this.filter = columnFilter;
            this.params = objectArray;
        }

        String getWhereClause() {
            return this.whereClause;
        }

        ColumnFilter getFilter() {
            return this.filter;
        }

        Object[] getCols() {
            return this.params;
        }
    }

    private static final class GroupDelete {
        private final String whereClause;
        private final ColumnFilter filter;
        private final Object[] params;

        GroupDelete(String string, ColumnFilter columnFilter, Object[] objectArray) {
            this.whereClause = string;
            this.filter = columnFilter;
            this.params = objectArray;
        }

        String getWhereClause() {
            return this.whereClause;
        }

        ColumnFilter getFilter() {
            return this.filter;
        }

        Object[] getCols() {
            return this.params;
        }
    }

    static abstract class OptimisticPolicy {
        static OptimisticPolicy VERIFY_READ_COLUMNS = new OptimisticPolicy(){

            int getCode() {
                return 1;
            }

            String getName() {
                return "VERIFY_READ_COLUMNS";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, BitSet bitSet) {
                return ALL;
            }
        };
        static OptimisticPolicy VERIFY_MODIFIED_COLUMNS = new OptimisticPolicy(){

            int getCode() {
                return 2;
            }

            String getName() {
                return "VERIFY_MODIFIED_COLUMNS";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, final BitSet bitSet) {
                final WLRowSetMetaData wLRowSetMetaData = tableWriter.metaData;
                return new ColumnFilter(){

                    public boolean include(int n) throws SQLException {
                        return bitSet.get(n) || wLRowSetMetaData.isPrimaryKeyColumn(n + 1);
                    }
                };
            }
        };
        static OptimisticPolicy VERIFY_SELECTED_COLUMNS = new OptimisticPolicy(){

            int getCode() {
                return 3;
            }

            String getName() {
                return "VERIFY_SELECTED_COLUMNS";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, BitSet bitSet) throws SQLException {
                final WLRowSetMetaData wLRowSetMetaData = tableWriter.metaData;
                return new ColumnFilter(){

                    public boolean include(int n) throws SQLException {
                        return wLRowSetMetaData.isSelectedColumn(n + 1) || wLRowSetMetaData.isPrimaryKeyColumn(n + 1);
                    }
                };
            }
        };
        static OptimisticPolicy VERIFY_NONE = new OptimisticPolicy(){

            int getCode() {
                return 4;
            }

            String getName() {
                return "VERIFY_NONE";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, BitSet bitSet) throws SQLException {
                final WLRowSetMetaData wLRowSetMetaData = tableWriter.metaData;
                return new ColumnFilter(){

                    public boolean include(int n) throws SQLException {
                        return wLRowSetMetaData.isPrimaryKeyColumn(n + 1);
                    }
                };
            }
        };
        static OptimisticPolicy VERIFY_AUTO_VERSION_COLUMNS = new OptimisticPolicy(){

            int getCode() {
                return 5;
            }

            String getName() {
                return "VERIFY_AUTO_VERSION_COLUMNS";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, BitSet bitSet) throws SQLException {
                final WLRowSetMetaData wLRowSetMetaData = tableWriter.metaData;
                return new ColumnFilter(){

                    public boolean include(int n) throws SQLException {
                        return wLRowSetMetaData.isAutoVersionColumn(n + 1) || wLRowSetMetaData.isPrimaryKeyColumn(n + 1);
                    }
                };
            }
        };
        static OptimisticPolicy VERIFY_VERSION_COLUMNS = new OptimisticPolicy(){

            int getCode() {
                return 6;
            }

            String getName() {
                return "VERIFY_VERSION_COLUMNS";
            }

            ColumnFilter getColumnFilter(TableWriter tableWriter, BitSet bitSet) throws SQLException {
                final WLRowSetMetaData wLRowSetMetaData = tableWriter.metaData;
                return new ColumnFilter(){

                    public boolean include(int n) throws SQLException {
                        return wLRowSetMetaData.isVersionColumn(n + 1) || wLRowSetMetaData.isPrimaryKeyColumn(n + 1);
                    }
                };
            }
        };

        OptimisticPolicy() {
        }

        abstract int getCode();

        abstract String getName();

        abstract ColumnFilter getColumnFilter(TableWriter var1, BitSet var2) throws SQLException;
    }

    private static final class ModFilter
    implements ColumnFilter {
        private final BitSet modColMask;

        private ModFilter(BitSet bitSet) {
            this.modColMask = bitSet;
        }

        public boolean include(int n) throws SQLException {
            return this.modColMask.get(n);
        }
    }

    private static final class AutoIncFilter
    implements ColumnFilter {
        private WLRowSetMetaData metaData;

        private AutoIncFilter(WLRowSetMetaData wLRowSetMetaData) {
            this.metaData = wLRowSetMetaData;
        }

        public boolean include(int n) throws SQLException {
            return !this.metaData.isAutoIncrement(n + 1);
        }
    }

    static interface ColumnFilter {
        public boolean include(int var1) throws SQLException;
    }
}

