/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.CharArrayReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.OracleTableWriter;
import weblogic.jdbc.rowset.RowSetBlob;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.RowSetLob;
import weblogic.jdbc.rowset.RowSetNClob;
import weblogic.jdbc.rowset.TableWriter;
import weblogic.jdbc.rowset.WLRowSetInternal;

public class ThinOracleTableWriter
extends OracleTableWriter {
    private List lobUpdateRows = null;
    protected boolean needs2PhaseInsert;
    private Map canonicalLOBUpdateColumns;

    public ThinOracleTableWriter(WLRowSetInternal wLRowSetInternal, String string, BitSet bitSet) throws SQLException {
        super(wLRowSetInternal, string, bitSet);
    }

    protected void insertRow(Connection connection, CachedRow cachedRow) throws SQLException {
        this.needs2PhaseInsert = false;
        super.insertRow(connection, cachedRow);
        if (this.needs2PhaseInsert) {
            this.addUpdateRow(cachedRow);
        }
    }

    private void addUpdateRow(CachedRow cachedRow) {
        if (this.lobUpdateRows == null) {
            this.lobUpdateRows = new ArrayList();
        }
        try {
            for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
                if (!this.isLOB(i) || !this.tableName.equals(this.metaData.getQualifiedTableName(i + 1)) || (!cachedRow.isUpdatedRow() || !cachedRow.isModified(i + 1)) && !cachedRow.isInsertRow()) continue;
                this.lobUpdateRows.add(cachedRow);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object insertedObject(Connection connection, Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == RowSetNClob.class) {
            return this.emptyNClob(connection);
        }
        if (clazz == RowSetClob.class) {
            return this.emptyClob(connection);
        }
        if (clazz == RowSetBlob.class) {
            return this.emptyBlob(connection);
        }
        return object;
    }

    protected Object emptyClob(Connection connection) {
        this.needs2PhaseInsert = true;
        try {
            return connection.createClob();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Object emptyNClob(Connection connection) {
        this.needs2PhaseInsert = true;
        try {
            return connection.createNClob();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected Object emptyBlob(Connection connection) {
        this.needs2PhaseInsert = true;
        try {
            return connection.createBlob();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    protected BitSet getModifiedColumns(CachedRow cachedRow) {
        BitSet bitSet = cachedRow.getModifiedColumns();
        BitSet bitSet2 = null;
        Object[] objectArray = cachedRow.getColumns();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            if (objectArray[n] instanceof RowSetBlob || objectArray[n] instanceof RowSetClob) {
                if (bitSet2 == null) {
                    bitSet2 = (BitSet)bitSet.clone();
                    this.addUpdateRow(cachedRow);
                }
                bitSet2.clear(n);
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return bitSet2 != null ? bitSet2 : bitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLOBs(Connection connection) throws SQLException {
        Iterator iterator;
        if (this.lobUpdateRows == null) {
            return;
        }
        this.canonicalLOBUpdateColumns = new HashMap();
        try {
            Iterator iterator2 = this.lobUpdateRows.iterator();
            while (iterator2.hasNext()) {
                this.updateLOBs(connection, (CachedRow)iterator2.next());
            }
            Object var4_3 = null;
            iterator = this.canonicalLOBUpdateColumns.values().iterator();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Iterator iterator3 = this.canonicalLOBUpdateColumns.values().iterator();
            while (iterator3.hasNext()) {
                ((LOBUpdateColumns)iterator3.next()).closeStatements();
            }
            this.canonicalLOBUpdateColumns = null;
            throw throwable;
        }
        while (iterator.hasNext()) {
            ((LOBUpdateColumns)iterator.next()).closeStatements();
        }
        {
        }
        this.canonicalLOBUpdateColumns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateLOBs(Connection connection, CachedRow cachedRow) throws SQLException {
        LOBUpdateColumns lOBUpdateColumns = this.getLOBUpdateColumns(connection, cachedRow);
        ResultSet resultSet = null;
        for (int i = 0; i < 3; ++i) {
            Object var7_6;
            block4: {
                try {
                    resultSet = lOBUpdateColumns.selectForUpdate(cachedRow);
                    if (!resultSet.next()) {
                        this.throwOCE(lOBUpdateColumns.selectSql, cachedRow);
                    }
                    if (!lOBUpdateColumns.executeUpdate(connection, resultSet, cachedRow)) break block4;
                    var7_6 = null;
                    if (resultSet == null) return;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    if (resultSet == null) throw throwable;
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return;
            }
            var7_6 = null;
            if (resultSet == null) continue;
            resultSet.close();
            {
                continue;
            }
        }
        throw new SQLException("Failed to update row in three passes");
    }

    private LOBUpdateColumns getLOBUpdateColumns(Connection connection, CachedRow cachedRow) throws SQLException {
        LOBUpdateColumns lOBUpdateColumns = this.newLOBUpdateColumns(cachedRow);
        LOBUpdateColumns lOBUpdateColumns2 = (LOBUpdateColumns)this.canonicalLOBUpdateColumns.get(lOBUpdateColumns);
        if (lOBUpdateColumns2 != null) {
            return lOBUpdateColumns2;
        }
        lOBUpdateColumns.cacheAll(connection);
        this.canonicalLOBUpdateColumns.put(lOBUpdateColumns, lOBUpdateColumns);
        return lOBUpdateColumns;
    }

    protected LOBUpdateColumns newLOBUpdateColumns(CachedRow cachedRow) throws SQLException {
        return new LOBUpdateColumns(cachedRow);
    }

    class LOBUpdateColumns
    extends RowSetLob.UpdateHelper {
        private final BitSet lobCols = new BitSet();
        private BitSet keyCols;
        private String selectSql;
        private String updateSql;
        private PreparedStatement selectPS;
        private PreparedStatement updatePS;
        protected boolean updateAgain;

        LOBUpdateColumns(CachedRow cachedRow) throws SQLException {
            Object[] objectArray = cachedRow.getColumns();
            BitSet bitSet = cachedRow.getModifiedColumns();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (objectArray[n] instanceof RowSetLob && ThinOracleTableWriter.this.tableName.equals(ThinOracleTableWriter.this.metaData.getQualifiedTableName(n + 1))) {
                    this.lobCols.set(n);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }

        public boolean equals(Object object) {
            return object instanceof LOBUpdateColumns && this.lobCols.equals(((LOBUpdateColumns)object).lobCols);
        }

        public int hashCode() {
            return this.lobCols.hashCode();
        }

        void cacheAll(Connection connection) throws SQLException {
            this.keyCols = new BitSet();
            int n = ThinOracleTableWriter.this.metaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                if (!ThinOracleTableWriter.this.metaData.isPrimaryKeyColumn(i) || !ThinOracleTableWriter.this.tableName.equals(ThinOracleTableWriter.this.metaData.getQualifiedTableName(i))) continue;
                this.keyCols.set(i - 1);
            }
            this.selectSql = this.getSelectSql();
            this.updateSql = this.getUpdateSql();
            this.selectPS = connection.prepareStatement(this.selectSql);
            this.updatePS = connection.prepareStatement(this.updateSql);
        }

        private String getSelectSql() throws SQLException {
            if (!ThinOracleTableWriter.this.metaData.haveSetPKColumns()) {
                throw new SQLException("You must use the WLRowSetMetaData.setPrimaryKeyColumn() method to establish primary key columns before updating rows.");
            }
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("SELECT ");
            String string = "";
            int n = this.lobCols.nextSetBit(0);
            while (n >= 0) {
                stringBuffer.append(string);
                stringBuffer.append(ThinOracleTableWriter.this.metaData.getWriteColumnName(n + 1));
                string = ", ";
                n = this.lobCols.nextSetBit(n + 1);
            }
            stringBuffer.append(" FROM ").append(ThinOracleTableWriter.this.tableName).append(" WHERE ");
            TableWriter.ColumnFilter columnFilter = TableWriter.getPolicy(ThinOracleTableWriter.this.metaData.getOptimisticPolicy()).getColumnFilter(ThinOracleTableWriter.this, this.lobCols);
            boolean bl = false;
            string = "";
            for (int i = 0; i < ThinOracleTableWriter.this.metaData.getColumnCount(); ++i) {
                if (!ThinOracleTableWriter.this.columnMask.get(i) || ThinOracleTableWriter.this.isLOB(i) || !columnFilter.include(i) || !ThinOracleTableWriter.this.tableName.equals(ThinOracleTableWriter.this.metaData.getQualifiedTableName(i + 1))) continue;
                String string2 = ThinOracleTableWriter.this.metaData.getWriteColumnName(i + 1);
                if (ThinOracleTableWriter.this.metaData.isPrimaryKeyColumn(i + 1)) {
                    stringBuffer.append(string).append(string2).append("=? ");
                    bl = true;
                } else {
                    stringBuffer.append(string).append("(").append(string2).append("=? OR ");
                    stringBuffer.append("(1=? AND ").append(string2).append(" IS NULL))");
                }
                string = " AND ";
            }
            if (!bl) {
                throw new SQLException("You must use the WLRowSetMetaData.setPrimaryKeyColumn() method to establish primary key columns for table " + ThinOracleTableWriter.this.tableName + " before updating rows.");
            }
            return stringBuffer.append(" FOR UPDATE NOWAIT").toString();
        }

        private String getUpdateSql() throws SQLException {
            StringBuffer stringBuffer = new StringBuffer(300);
            stringBuffer.append("UPDATE ").append(ThinOracleTableWriter.this.tableName).append(" SET ");
            String string = "";
            int n = this.lobCols.nextSetBit(0);
            while (n >= 0) {
                stringBuffer.append(string);
                stringBuffer.append(ThinOracleTableWriter.this.metaData.getWriteColumnName(n + 1)).append("=?");
                string = ", ";
                n = this.lobCols.nextSetBit(n + 1);
            }
            string = "";
            stringBuffer.append(" WHERE ");
            n = this.keyCols.nextSetBit(0);
            while (n >= 0) {
                stringBuffer.append(string);
                stringBuffer.append(ThinOracleTableWriter.this.metaData.getWriteColumnName(n + 1)).append("=?");
                string = " AND ";
                n = this.keyCols.nextSetBit(n + 1);
            }
            return stringBuffer.toString();
        }

        void closeStatements() {
            try {
                this.selectPS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.updatePS.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        ResultSet selectForUpdate(CachedRow cachedRow) throws SQLException {
            Object[] objectArray = cachedRow.getColumns();
            ArrayList<Object> arrayList = ThinOracleTableWriter.this.verboseSQL ? new ArrayList<Object>() : null;
            int n = 1;
            TableWriter.ColumnFilter columnFilter = TableWriter.getPolicy(ThinOracleTableWriter.this.metaData.getOptimisticPolicy()).getColumnFilter(ThinOracleTableWriter.this, this.lobCols);
            for (int i = 0; i < ThinOracleTableWriter.this.columnCount; ++i) {
                if (!ThinOracleTableWriter.this.columnMask.get(i) || ThinOracleTableWriter.this.isLOB(i) || !columnFilter.include(i) || !ThinOracleTableWriter.this.tableName.equals(ThinOracleTableWriter.this.metaData.getQualifiedTableName(i + 1))) continue;
                if (objectArray[i] instanceof Integer) {
                    this.selectPS.setInt(n++, (Integer)objectArray[i]);
                } else if (objectArray[i] instanceof Float) {
                    this.selectPS.setFloat(n++, ((Float)objectArray[i]).floatValue());
                } else if (objectArray[i] instanceof char[]) {
                    this.selectPS.setCharacterStream(n++, (Reader)new CharArrayReader((char[])objectArray[i]), ((char[])objectArray[i]).length);
                } else {
                    this.selectPS.setObject(n++, objectArray[i], ThinOracleTableWriter.this.metaData.getColumnType(i + 1));
                }
                if (ThinOracleTableWriter.this.verboseSQL) {
                    arrayList.add(objectArray[i]);
                }
                if (ThinOracleTableWriter.this.metaData.isPrimaryKeyColumn(i + 1)) continue;
                int n2 = objectArray[i] == null ? 1 : 0;
                this.selectPS.setInt(n++, n2);
                if (!ThinOracleTableWriter.this.verboseSQL) continue;
                arrayList.add(new Integer(n2));
            }
            if (ThinOracleTableWriter.this.verboseSQL) {
                ThinOracleTableWriter.this.printSQL(this.selectSql, arrayList.toArray(new Object[arrayList.size()]));
            }
            return this.selectPS.executeQuery();
        }

        boolean executeUpdate(Connection connection, ResultSet resultSet, CachedRow cachedRow) throws SQLException {
            this.updateAgain = false;
            int n = 1;
            Object[] objectArray = cachedRow.getColumns();
            ArrayList<Object> arrayList = ThinOracleTableWriter.this.verboseSQL ? new ArrayList<Object>() : null;
            int n2 = this.lobCols.nextSetBit(0);
            while (n2 >= 0) {
                Object object = ((RowSetLob)objectArray[n2]).update(connection, resultSet, n, this);
                if (object instanceof NClob) {
                    this.updatePS.setNClob(n++, (NClob)object);
                } else {
                    this.updatePS.setObject(n++, object, ThinOracleTableWriter.this.metaData.getColumnType(n2 + 1));
                }
                if (ThinOracleTableWriter.this.verboseSQL) {
                    arrayList.add(object);
                }
                n2 = this.lobCols.nextSetBit(n2 + 1);
            }
            n2 = this.keyCols.nextSetBit(0);
            while (n2 >= 0) {
                this.updatePS.setObject(n++, objectArray[n2], ThinOracleTableWriter.this.metaData.getColumnType(n2 + 1));
                if (ThinOracleTableWriter.this.verboseSQL) {
                    arrayList.add(objectArray[n2]);
                }
                n2 = this.keyCols.nextSetBit(n2 + 1);
            }
            if (ThinOracleTableWriter.this.verboseSQL) {
                ThinOracleTableWriter.this.printSQL(this.updateSql, arrayList.toArray(new Object[arrayList.size()]));
            }
            this.updatePS.execute();
            return !this.updateAgain;
        }

        private int setBits(BitSet bitSet) {
            int n = 0;
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                ++n;
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            return n;
        }

        protected Object update(Connection connection, Blob blob, byte[] byArray) throws SQLException {
            if (blob == null || blob.length() > (long)byArray.length) {
                this.updateAgain = true;
                return connection.createBlob();
            }
            blob.setBytes(1L, byArray);
            return blob;
        }

        protected Object update(Connection connection, Clob clob, char[] cArray) throws SQLException {
            if (clob == null || clob.length() > (long)cArray.length) {
                this.updateAgain = true;
                return connection.createClob();
            }
            Writer writer = clob.setCharacterStream(1L);
            try {
                writer.write(cArray);
                writer.flush();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
            return clob;
        }

        protected Object update(Connection connection, NClob nClob, char[] cArray) throws SQLException {
            if (nClob == null || nClob.length() > (long)cArray.length) {
                this.updateAgain = true;
                return connection.createNClob();
            }
            Writer writer = nClob.setCharacterStream(1L);
            try {
                writer.write(cArray);
                writer.flush();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
            return nClob;
        }
    }
}

