/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.RowSetNClob;

class WLParameter
implements Serializable {
    private static final long serialVersionUID = 7248152094879848380L;
    static final int DUMMY_INDEX = 0;
    static final int DUMMY_PS = 0;
    static final int ARRAY_PS = 1;
    static final int ASCII_ISTR_PS = 2;
    static final int ASCII_ISTR_LEN_PS = 3;
    static final int BIGD_PS = 4;
    static final int BINSTR_ISTR_PS = 5;
    static final int BINSTR_ISTR_LEN_PS = 6;
    static final int BLOB_PS = 7;
    static final int BLOB_ISTR_PS = 8;
    static final int BLOB_ISTR_LEN_PS = 9;
    static final int BOOL_PS = 10;
    static final int BYTE_PS = 11;
    static final int BYTEARR_PS = 12;
    static final int CHARSTR_READER_PS = 13;
    static final int CHARSTR_READER_LEN_PS = 14;
    static final int CLOB_PS = 15;
    static final int CLOB_READER_PS = 16;
    static final int CLOB_READER_LEN_PS = 17;
    static final int DATE_PS = 18;
    static final int DATE_CAL_PS = 19;
    static final int DOUBLE_PS = 20;
    static final int FLOAT_PS = 21;
    static final int INT_PS = 22;
    static final int LONG_PS = 23;
    static final int NCHARSTR_READER_PS = 24;
    static final int NCHARSTR_READER_LEN_PS = 25;
    static final int NCLOB_PS = 26;
    static final int NCLOB_READER_PS = 27;
    static final int NCLOB_READER_LEN_PS = 28;
    static final int NSTRING_PS = 29;
    static final int NULL_PS = 30;
    static final int NULL_TYPE_PS = 31;
    static final int OBJ_PS = 32;
    static final int OBJ_TYPE_PS = 33;
    static final int OBJ_TYPE_SCALE_PS = 34;
    static final int REF_PS = 35;
    static final int ROWID_PS = 36;
    static final int SHORT_PS = 37;
    static final int SQLXML_PS = 38;
    static final int STRING_PS = 39;
    static final int TIME_PS = 40;
    static final int TIME_CAL_PS = 41;
    static final int TIMESTAMP_PS = 42;
    static final int TIMESTAMP_CAL_PS = 43;
    static final int URL_PS = 44;
    private int index = 0;
    private String name = null;
    private int type = 0;
    private Object[] params = null;

    WLParameter(int n, String string, int n2, Object[] objectArray) throws SQLException {
        if (string == null || string.equals("")) {
            if (n < 1) {
                throw new SQLException("CallableStatement parameters must be >= 1.");
            }
        } else if (n != 0) {
            throw new SQLException("Invalid CallableStatement parameters.");
        }
        this.index = n;
        this.name = string;
        this.type = n2;
        this.params = objectArray;
    }

    WLParameter(int n, int n2, Object[] objectArray) throws SQLException {
        this(n, null, n2, objectArray);
    }

    WLParameter(String string, int n, Object[] objectArray) throws SQLException {
        this(0, string, n, objectArray);
    }

    void setParam(CallableStatement callableStatement) throws SQLException {
        switch (this.type) {
            case 1: {
                callableStatement.setArray(this.index, (Array)this.params[0]);
                break;
            }
            case 2: {
                if (this.name != null) {
                    callableStatement.setAsciiStream(this.name, (InputStream)this.params[0]);
                    break;
                }
                callableStatement.setAsciiStream(this.index, (InputStream)this.params[0]);
                break;
            }
            case 3: {
                if (this.name != null) {
                    callableStatement.setAsciiStream(this.name, (InputStream)this.params[0], (int)((Integer)this.params[1]));
                    break;
                }
                callableStatement.setAsciiStream(this.index, (InputStream)this.params[0], (int)((Integer)this.params[1]));
                break;
            }
            case 4: {
                if (this.name != null) {
                    callableStatement.setBigDecimal(this.name, (BigDecimal)this.params[0]);
                    break;
                }
                callableStatement.setBigDecimal(this.index, (BigDecimal)this.params[0]);
                break;
            }
            case 5: {
                if (this.name != null) {
                    callableStatement.setBinaryStream(this.name, (InputStream)this.params[0]);
                    break;
                }
                callableStatement.setBinaryStream(this.index, (InputStream)this.params[0]);
                break;
            }
            case 6: {
                if (this.name != null) {
                    callableStatement.setBinaryStream(this.name, (InputStream)this.params[0], (int)((Integer)this.params[1]));
                    break;
                }
                callableStatement.setBinaryStream(this.index, (InputStream)this.params[0], (int)((Integer)this.params[1]));
                break;
            }
            case 7: {
                if (this.name != null) {
                    callableStatement.setBlob(this.name, (Blob)this.params[0]);
                    break;
                }
                callableStatement.setBlob(this.index, (Blob)this.params[0]);
                break;
            }
            case 8: {
                if (this.name != null) {
                    callableStatement.setBlob(this.name, (InputStream)this.params[0]);
                    break;
                }
                callableStatement.setBlob(this.index, (InputStream)this.params[0]);
                break;
            }
            case 9: {
                if (this.name != null) {
                    callableStatement.setBlob(this.name, (InputStream)this.params[0], (long)((Long)this.params[1]));
                    break;
                }
                callableStatement.setBlob(this.index, (InputStream)this.params[0], (long)((Long)this.params[1]));
                break;
            }
            case 10: {
                if (this.name != null) {
                    callableStatement.setBoolean(this.name, (boolean)((Boolean)this.params[0]));
                    break;
                }
                callableStatement.setBoolean(this.index, (boolean)((Boolean)this.params[0]));
                break;
            }
            case 11: {
                if (this.name != null) {
                    callableStatement.setByte(this.name, (byte)((Byte)this.params[0]));
                    break;
                }
                callableStatement.setByte(this.index, (byte)((Byte)this.params[0]));
                break;
            }
            case 12: {
                if (this.name != null) {
                    callableStatement.setBytes(this.name, (byte[])this.params[0]);
                    break;
                }
                callableStatement.setBytes(this.index, (byte[])this.params[0]);
                break;
            }
            case 13: {
                if (this.name != null) {
                    callableStatement.setCharacterStream(this.name, (Reader)this.params[0]);
                    break;
                }
                callableStatement.setCharacterStream(this.index, (Reader)this.params[0]);
                break;
            }
            case 14: {
                if (this.name != null) {
                    callableStatement.setCharacterStream(this.name, (Reader)this.params[0], (int)((Integer)this.params[1]));
                    break;
                }
                callableStatement.setCharacterStream(this.index, (Reader)this.params[0], (int)((Integer)this.params[1]));
                break;
            }
            case 15: {
                Clob clob = (Clob)this.params[0];
                if (clob instanceof RowSetClob) {
                    if (this.name != null) {
                        callableStatement.setClob(this.name, clob.getCharacterStream());
                        break;
                    }
                    callableStatement.setClob(this.index, clob.getCharacterStream());
                    break;
                }
                if (this.name != null) {
                    callableStatement.setClob(this.name, clob);
                    break;
                }
                callableStatement.setClob(this.index, clob);
                break;
            }
            case 16: {
                if (this.name != null) {
                    callableStatement.setClob(this.name, (Reader)this.params[0]);
                    break;
                }
                callableStatement.setClob(this.index, (Reader)this.params[0]);
                break;
            }
            case 17: {
                if (this.name != null) {
                    callableStatement.setClob(this.name, (Reader)this.params[0], (long)((Long)this.params[1]));
                    break;
                }
                callableStatement.setClob(this.index, (Reader)this.params[0], (long)((Long)this.params[1]));
                break;
            }
            case 18: {
                if (this.name != null) {
                    callableStatement.setDate(this.name, (Date)this.params[0]);
                    break;
                }
                callableStatement.setDate(this.index, (Date)this.params[0]);
                break;
            }
            case 19: {
                if (this.name != null) {
                    callableStatement.setDate(this.name, (Date)this.params[0], (Calendar)this.params[1]);
                    break;
                }
                callableStatement.setDate(this.index, (Date)this.params[0], (Calendar)this.params[1]);
                break;
            }
            case 20: {
                if (this.name != null) {
                    callableStatement.setDouble(this.name, (double)((Double)this.params[0]));
                    break;
                }
                callableStatement.setDouble(this.index, (double)((Double)this.params[0]));
                break;
            }
            case 21: {
                if (this.name != null) {
                    callableStatement.setFloat(this.name, ((Float)this.params[0]).floatValue());
                    break;
                }
                callableStatement.setFloat(this.index, ((Float)this.params[0]).floatValue());
                break;
            }
            case 22: {
                if (this.name != null) {
                    callableStatement.setInt(this.name, (int)((Integer)this.params[0]));
                    break;
                }
                callableStatement.setInt(this.index, (int)((Integer)this.params[0]));
                break;
            }
            case 23: {
                if (this.name != null) {
                    callableStatement.setLong(this.name, (long)((Long)this.params[0]));
                    break;
                }
                callableStatement.setLong(this.index, (long)((Long)this.params[0]));
                break;
            }
            case 24: {
                if (this.name != null) {
                    callableStatement.setCharacterStream(this.name, (Reader)this.params[0]);
                    break;
                }
                callableStatement.setCharacterStream(this.index, (Reader)this.params[0]);
                break;
            }
            case 25: {
                if (this.name != null) {
                    callableStatement.setNCharacterStream(this.name, (Reader)this.params[0], (long)((Long)this.params[1]));
                    break;
                }
                callableStatement.setNCharacterStream(this.index, (Reader)this.params[0], (long)((Long)this.params[1]));
                break;
            }
            case 26: {
                NClob nClob = (NClob)this.params[0];
                if (nClob instanceof RowSetNClob) {
                    if (this.name != null) {
                        callableStatement.setNClob(this.name, nClob.getCharacterStream());
                        break;
                    }
                    callableStatement.setNClob(this.index, nClob.getCharacterStream());
                    break;
                }
                if (this.name != null) {
                    callableStatement.setNClob(this.name, nClob);
                    break;
                }
                callableStatement.setNClob(this.index, nClob);
                break;
            }
            case 27: {
                if (this.name != null) {
                    callableStatement.setNClob(this.name, (Reader)this.params[0]);
                    break;
                }
                callableStatement.setNClob(this.index, (Reader)this.params[0]);
                break;
            }
            case 28: {
                if (this.name != null) {
                    callableStatement.setNClob(this.name, (Reader)this.params[0], (long)((Long)this.params[1]));
                    break;
                }
                callableStatement.setNClob(this.index, (Reader)this.params[0], (long)((Long)this.params[1]));
                break;
            }
            case 29: {
                if (this.name != null) {
                    callableStatement.setNString(this.name, (String)this.params[0]);
                    break;
                }
                callableStatement.setNString(this.index, (String)this.params[0]);
                break;
            }
            case 30: {
                if (this.name != null) {
                    callableStatement.setNull(this.name, (int)((Integer)this.params[0]));
                    break;
                }
                callableStatement.setNull(this.index, (int)((Integer)this.params[0]));
                break;
            }
            case 31: {
                if (this.name != null) {
                    callableStatement.setNull(this.name, (int)((Integer)this.params[0]), (String)this.params[1]);
                    break;
                }
                callableStatement.setNull(this.index, (int)((Integer)this.params[0]), (String)this.params[1]);
                break;
            }
            case 32: {
                if (this.name != null) {
                    callableStatement.setObject(this.name, this.params[0]);
                    break;
                }
                callableStatement.setObject(this.index, this.params[0]);
                break;
            }
            case 33: {
                if (this.name != null) {
                    callableStatement.setObject(this.name, this.params[0], (int)((Integer)this.params[1]));
                    break;
                }
                callableStatement.setObject(this.index, this.params[0], (int)((Integer)this.params[1]));
                break;
            }
            case 34: {
                if (this.name != null) {
                    callableStatement.setObject(this.name, this.params[0], (int)((Integer)this.params[1]), (int)((Integer)this.params[2]));
                    break;
                }
                callableStatement.setObject(this.index, this.params[0], (int)((Integer)this.params[1]), (int)((Integer)this.params[2]));
                break;
            }
            case 35: {
                callableStatement.setRef(this.index, (Ref)this.params[0]);
                break;
            }
            case 36: {
                if (this.name != null) {
                    callableStatement.setRowId(this.name, (RowId)this.params[0]);
                    break;
                }
                callableStatement.setRowId(this.index, (RowId)this.params[0]);
                break;
            }
            case 37: {
                if (this.name != null) {
                    callableStatement.setShort(this.name, (short)((Short)this.params[0]));
                    break;
                }
                callableStatement.setShort(this.index, (short)((Short)this.params[0]));
                break;
            }
            case 38: {
                if (this.name != null) {
                    callableStatement.setSQLXML(this.name, (SQLXML)this.params[0]);
                    break;
                }
                callableStatement.setSQLXML(this.index, (SQLXML)this.params[0]);
                break;
            }
            case 39: {
                if (this.name != null) {
                    callableStatement.setString(this.name, (String)this.params[0]);
                    break;
                }
                callableStatement.setString(this.index, (String)this.params[0]);
                break;
            }
            case 40: {
                if (this.name != null) {
                    callableStatement.setTime(this.name, (Time)this.params[0]);
                    break;
                }
                callableStatement.setTime(this.index, (Time)this.params[0]);
                break;
            }
            case 41: {
                if (this.name != null) {
                    callableStatement.setTime(this.name, (Time)this.params[0], (Calendar)this.params[1]);
                    break;
                }
                callableStatement.setTime(this.index, (Time)this.params[0], (Calendar)this.params[1]);
                break;
            }
            case 42: {
                if (this.name != null) {
                    callableStatement.setTimestamp(this.index, (Timestamp)this.params[0]);
                    break;
                }
                callableStatement.setTimestamp(this.index, (Timestamp)this.params[0]);
                break;
            }
            case 43: {
                if (this.name != null) {
                    callableStatement.setTimestamp(this.index, (Timestamp)this.params[0], (Calendar)this.params[1]);
                    break;
                }
                callableStatement.setTimestamp(this.index, (Timestamp)this.params[0], (Calendar)this.params[1]);
                break;
            }
            case 44: {
                if (this.name != null) {
                    callableStatement.setURL(this.name, (URL)this.params[0]);
                    break;
                }
                callableStatement.setURL(this.index, (URL)this.params[0]);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected type: " + this.type));
            }
        }
    }

    Object getObject() {
        return this.params;
    }

    int getIndex() {
        return this.index;
    }

    String getName() {
        return this.name;
    }

    int getType() {
        return this.type;
    }

    Object[] getParams() {
        return this.params;
    }
}

