/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.spi.SyncFactory;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.util.TypeFilter;

public final class WebRowSetReader
implements XMLSchemaConstants {
    private static final boolean DEBUG = false;
    private CachedRowSetImpl rowSet;
    private CachedRowSetMetaData metaData;
    private XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();
    private ArrayList keys = new ArrayList();

    public WebRowSetReader(CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        this.rowSet = cachedRowSetImpl;
        this.metaData = (CachedRowSetMetaData)cachedRowSetImpl.getMetaData();
    }

    public void loadXML(XMLInputStream xMLInputStream) throws IOException, SQLException {
        XMLInputStream xMLInputStream2 = this.factory.newInputStream(xMLInputStream, (ElementFilter)new TypeFilter(22));
        this.parseRowSet(xMLInputStream2);
    }

    private void parseRowSet(XMLInputStream xMLInputStream) throws IOException, SQLException {
        boolean bl = this.metaData.getColumnCount() > 0;
        xMLInputStream.next();
        while (xMLInputStream.hasNext()) {
            String string = this.getName(xMLInputStream.peek());
            if ("webRowSet".equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("properties".equals(string)) {
                this.parseProperties(xMLInputStream);
                continue;
            }
            if ("metadata".equals(string)) {
                this.parseMetaData(xMLInputStream);
                bl = true;
                continue;
            }
            if ("data".equals(string)) {
                if (bl) {
                    this.parseData(xMLInputStream);
                    continue;
                }
                throw new IOException("metadata must be established before data get parsed.");
            }
            throw new IOException("XML document has incorrect format. The current element is " + string);
        }
    }

    private int parseSimpleElements4Int(XMLInputStream xMLInputStream) throws IOException, SQLException {
        return Integer.parseInt(this.parseSimpleElements(xMLInputStream));
    }

    private boolean parseSimpleElements4Boolean(XMLInputStream xMLInputStream) throws IOException, SQLException {
        return new Boolean(this.parseSimpleElements(xMLInputStream));
    }

    private String parseSimpleElements(XMLInputStream xMLInputStream) throws IOException, SQLException {
        String string = null;
        String string2 = null;
        XMLEvent xMLEvent = xMLInputStream.next();
        if (!(xMLEvent instanceof StartElement)) {
            throw new IOException("XML document has incorrect format.");
        }
        string = this.getName(xMLEvent);
        xMLEvent = xMLInputStream.next();
        if (xMLEvent instanceof CharacterData) {
            string2 = ((CharacterData)xMLEvent).getContent();
            xMLEvent = xMLInputStream.next();
            if (!(xMLEvent instanceof EndElement) || !string.equals(this.getName(xMLEvent))) {
                throw new IOException("XML document has incorrect format. The current element is " + this.getName(xMLEvent));
            }
        } else if (!(xMLEvent instanceof EndElement) || !string.equals(this.getName(xMLEvent))) {
            throw new IOException("XML document has incorrect format. The current element is " + this.getName(xMLEvent));
        }
        return string2;
    }

    private void parseProperties(XMLInputStream xMLInputStream) throws IOException, SQLException {
        xMLInputStream.next();
        block4: while (xMLInputStream.hasNext()) {
            Object object;
            String string = this.getName(xMLInputStream.peek());
            if ("properties".equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("map".equals(string)) {
                object = new HashMap();
                xMLInputStream.next();
                while (xMLInputStream.hasNext()) {
                    string = this.getName(xMLInputStream.peek());
                    if ("map".equals(string)) {
                        xMLInputStream.next();
                        break;
                    }
                    if ("type".equals(string)) {
                        try {
                            ((HashMap)object).put(this.parseSimpleElements(xMLInputStream), Class.forName(this.parseSimpleElements(xMLInputStream)));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        continue;
                    }
                    throw new IOException("XML document has incorrect format. The current element is " + string);
                }
                this.rowSet.setTypeMap((Map)object);
                continue;
            }
            if ("key-columns".equals(string)) {
                xMLInputStream.next();
                while (xMLInputStream.hasNext()) {
                    string = this.getName(xMLInputStream.peek());
                    if ("key-columns".equals(string)) {
                        xMLInputStream.next();
                        continue block4;
                    }
                    if ("column".equals(string)) {
                        this.keys.add(this.parseSimpleElements(xMLInputStream));
                        continue;
                    }
                    throw new IOException("XML document has incorrect format. The current element is " + string);
                }
                continue;
            }
            if ("sync-provider".equals(string)) {
                xMLInputStream.next();
                while (xMLInputStream.hasNext()) {
                    string = this.getName(xMLInputStream.peek());
                    if ("sync-provider".equals(string)) {
                        xMLInputStream.next();
                        continue block4;
                    }
                    if ("sync-provider-name".equals(string)) {
                        object = this.parseSimpleElements(xMLInputStream);
                        try {
                            Class.forName((String)object);
                            SyncFactory.registerProvider((String)object);
                            this.rowSet.setSyncProvider((String)object);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        continue;
                    }
                    if ("sync-provider-vendor".equals(string)) {
                        this.parseSimpleElements(xMLInputStream);
                        continue;
                    }
                    if ("sync-provider-version".equals(string)) {
                        this.parseSimpleElements(xMLInputStream);
                        continue;
                    }
                    if ("sync-provider-grade".equals(string)) {
                        this.parseSimpleElements(xMLInputStream);
                        continue;
                    }
                    if ("data-source-lock".equals(string)) {
                        this.rowSet.getSyncProvider().setDataSourceLock(this.parseSimpleElements4Int(xMLInputStream));
                        continue;
                    }
                    throw new IOException("XML document has incorrect format. The current element is " + string);
                }
                continue;
            }
            if ("command".equals(string)) {
                this.rowSet.setCommand(this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("concurrency".equals(string)) {
                this.rowSet.setConcurrency(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("datasource".equals(string)) {
                this.rowSet.setDataSourceName(this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("escape-processing".equals(string)) {
                this.rowSet.setEscapeProcessing(this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("fetch-direction".equals(string)) {
                this.rowSet.setFetchDirection(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("fetch-size".equals(string)) {
                this.rowSet.setFetchSize(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("isolation-level".equals(string)) {
                this.rowSet.setTransactionIsolation(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("max-field-size".equals(string)) {
                this.rowSet.setMaxFieldSize(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("max-rows".equals(string)) {
                this.rowSet.setMaxRows(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("query-timeout".equals(string)) {
                this.rowSet.setQueryTimeout(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("read-only".equals(string)) {
                this.rowSet.setReadOnlyInternal(this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("rowset-type".equals(string)) {
                this.rowSet.setType(this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("show-deleted".equals(string)) {
                this.rowSet.setShowDeleted(this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("table-name".equals(string)) {
                this.rowSet.setTableName(this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("url".equals(string)) {
                this.rowSet.setUrl(this.parseSimpleElements(xMLInputStream));
                continue;
            }
            throw new IOException("XML document has incorrect format. The current element is " + string);
        }
    }

    private void parseMetaData(XMLInputStream xMLInputStream) throws IOException, SQLException {
        int n;
        int n2 = 0;
        int n3 = 0;
        xMLInputStream.next();
        while (xMLInputStream.hasNext()) {
            String string = this.getName(xMLInputStream.peek());
            if ("metadata".equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("column-count".equals(string)) {
                n2 = this.parseSimpleElements4Int(xMLInputStream);
                this.metaData.setColumnCountInternal(n2);
                continue;
            }
            if ("column-definition".equals(string)) {
                this.parseColumnDef(xMLInputStream);
                if (++n3 <= n2) continue;
                throw new IOException("column-count " + n2 + " doesn't match with the number of column-definition.");
            }
            throw new IOException("XML document has incorrect format. The current element is " + string);
        }
        if ((n = this.keys.size()) > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.metaData.findColumn((String)this.keys.get(i));
            }
            this.rowSet.setKeyColumns(nArray);
        }
    }

    private void parseColumnDef(XMLInputStream xMLInputStream) throws IOException, SQLException {
        xMLInputStream.next();
        int n = 1;
        while (xMLInputStream.hasNext()) {
            String string = this.getName(xMLInputStream.peek());
            if ("column-definition".equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("column-index".equals(string)) {
                n = this.parseSimpleElements4Int(xMLInputStream);
                continue;
            }
            if ("auto-increment".equals(string)) {
                this.metaData.setAutoIncrement(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("definitely-writable".equals(string)) {
                this.metaData.setDefinitelyWritable(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("case-sensitive".equals(string)) {
                this.metaData.setCaseSensitive(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("currency".equals(string)) {
                this.metaData.setCurrency(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("nullable".equals(string)) {
                this.metaData.setNullable(n, this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("signed".equals(string)) {
                this.metaData.setSigned(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("searchable".equals(string)) {
                this.metaData.setSearchable(n, this.parseSimpleElements4Boolean(xMLInputStream));
                continue;
            }
            if ("column-display-size".equals(string)) {
                this.metaData.setColumnDisplaySize(n, this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("column-label".equals(string)) {
                this.metaData.setColumnLabel(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("column-name".equals(string)) {
                this.metaData.setColumnName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("column-class-name".equals(string)) {
                this.metaData.setColumnClassName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("schema-name".equals(string)) {
                this.metaData.setSchemaName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("column-precision".equals(string)) {
                this.metaData.setPrecision(n, this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("column-scale".equals(string)) {
                this.metaData.setScale(n, this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("table-name".equals(string)) {
                this.metaData.setTableName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("catalog-name".equals(string)) {
                this.metaData.setCatalogName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            if ("column-type".equals(string)) {
                this.metaData.setColumnType(n, this.parseSimpleElements4Int(xMLInputStream));
                continue;
            }
            if ("column-type-name".equals(string)) {
                this.metaData.setColumnTypeName(n, this.parseSimpleElements(xMLInputStream));
                continue;
            }
            throw new IOException("XML document has incorrect format. The current element is " + string);
        }
    }

    private CachedRow parseRow(XMLInputStream xMLInputStream) throws IOException, SQLException {
        CachedRow cachedRow = new CachedRow(this.metaData);
        String string = this.getName(xMLInputStream.next());
        int n = 0;
        while (xMLInputStream.hasNext()) {
            Object object;
            String string2 = this.getName(xMLInputStream.peek());
            if (string2.equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("columnValue".equals(string2)) {
                object = TypeMapper.getJavaValue(this.metaData.getColumnType(++n), this.parseSimpleElements(xMLInputStream));
                cachedRow.setOriginal(n, object);
                continue;
            }
            if ("updateValue".equals(string2)) {
                object = TypeMapper.getJavaValue(this.metaData.getColumnType(n), this.parseSimpleElements(xMLInputStream));
                cachedRow.updateColumn(n, object);
                continue;
            }
            throw new IOException("XML document has incorrect format. The current element is " + string2);
        }
        return cachedRow;
    }

    private void parseData(XMLInputStream xMLInputStream) throws IOException, SQLException {
        ArrayList<CachedRow> arrayList = new ArrayList<CachedRow>();
        CachedRow cachedRow = null;
        xMLInputStream.next();
        while (xMLInputStream.hasNext()) {
            String string = this.getName(xMLInputStream.peek());
            if ("data".equals(string)) {
                xMLInputStream.next();
                break;
            }
            if ("currentRow".equals(string)) {
                cachedRow = this.parseRow(xMLInputStream);
                cachedRow.setUpdatedRow(false);
                cachedRow.setDeletedRow(false);
                cachedRow.setInsertRow(false);
            } else if ("insertRow".equals(string)) {
                cachedRow = this.parseRow(xMLInputStream);
                cachedRow.setInsertRow(true);
                cachedRow.setDeletedRow(false);
            } else if ("deleteRow".equals(string)) {
                cachedRow = this.parseRow(xMLInputStream);
                cachedRow.setDeletedRow(true);
                cachedRow.setInsertRow(false);
            } else if ("modifyRow".equals(string)) {
                cachedRow = this.parseRow(xMLInputStream);
                cachedRow.setUpdatedRow(true);
                cachedRow.setDeletedRow(false);
                cachedRow.setInsertRow(false);
            } else {
                throw new IOException("XML document has incorrect format. The current element is " + string);
            }
            arrayList.add(cachedRow);
        }
        this.rowSet.getCachedRows().addAll(arrayList);
    }

    private String getName(XMLEvent xMLEvent) {
        return xMLEvent.getName().getLocalName();
    }
}

