/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.sql.rowset.spi.SyncProvider;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;

public final class WebRowSetWriter
implements XMLSchemaConstants {
    private CachedRowSetImpl rowSet;
    private WLRowSetMetaData metaData;

    public WebRowSetWriter(CachedRowSetImpl cachedRowSetImpl) throws SQLException {
        this.rowSet = cachedRowSetImpl;
        this.metaData = (WLRowSetMetaData)cachedRowSetImpl.getMetaData();
    }

    private Attribute getAttr(String string, String string2) {
        return ElementFactory.createAttribute((String)string, (String)string2);
    }

    private Attribute getAttr(XMLName xMLName, String string) {
        return ElementFactory.createAttribute((XMLName)xMLName, (String)string);
    }

    private Attribute getDefaultNS(String string) {
        return ElementFactory.createNamespaceAttribute(null, (String)string);
    }

    public void writeXML(XMLOutputStream xMLOutputStream, int n) throws SQLException, IOException {
        XMLWriter xMLWriter = new XMLWriter(xMLOutputStream, "http://java.sun.com/xml/ns/jdbc");
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = this.getDefaultNS("http://java.sun.com/xml/ns/jdbc");
        arrayList.add(attribute);
        arrayList.add(SCHEMA_INSTANCE_NAMESPACE);
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        arrayList2.add(this.getAttr(SCHEMA_LOCATION_NAME, "http://java.sun.com/xml/ns/jdbc/webrowset.xsd"));
        xMLWriter.writeStartElement("webRowSet", arrayList2.iterator(), arrayList.iterator());
        this.writeProperties(xMLWriter);
        this.writeMetaData(xMLWriter);
        this.writeData(xMLWriter);
        xMLWriter.writeEndElement("webRowSet");
        xMLOutputStream.flush();
    }

    private void writeProperties(XMLWriter xMLWriter) throws SQLException, IOException {
        Object var2_2 = null;
        xMLWriter.writeStartElement("properties");
        xMLWriter.writeSimpleElements("command", this.rowSet.getCommand());
        xMLWriter.writeSimpleElements("concurrency", this.rowSet.getConcurrency());
        xMLWriter.writeSimpleElements("datasource", this.rowSet.getDataSourceName());
        xMLWriter.writeSimpleElements("escape-processing", this.rowSet.getEscapeProcessing());
        xMLWriter.writeSimpleElements("fetch-direction", this.rowSet.getFetchDirection());
        xMLWriter.writeSimpleElements("fetch-size", this.rowSet.getFetchSize());
        xMLWriter.writeSimpleElements("isolation-level", this.rowSet.getTransactionIsolation());
        xMLWriter.writeStartElement("key-columns");
        int[] nArray = this.rowSet.getKeyColumns();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                xMLWriter.writeSimpleElements("column", this.metaData.getColumnName(nArray[i]));
            }
        }
        xMLWriter.writeEndElement("key-columns");
        xMLWriter.writeStartElement("map");
        Map map = this.rowSet.getTypeMap();
        if (map != null && !map.isEmpty()) {
            for (String string : map.keySet()) {
                xMLWriter.writeSimpleElements("type", string);
                xMLWriter.writeSimpleElements("class", ((Class)map.get(string)).getName());
            }
        }
        xMLWriter.writeEndElement("map");
        xMLWriter.writeSimpleElements("max-field-size", this.rowSet.getMaxFieldSize());
        xMLWriter.writeSimpleElements("max-rows", this.rowSet.getMaxRows());
        xMLWriter.writeSimpleElements("query-timeout", this.rowSet.getQueryTimeout());
        xMLWriter.writeSimpleElements("read-only", this.rowSet.isReadOnly());
        xMLWriter.writeSimpleElements("rowset-type", this.rowSet.getType());
        xMLWriter.writeSimpleElements("show-deleted", this.rowSet.getShowDeleted());
        xMLWriter.writeSimpleElements("table-name", this.rowSet.getTableName());
        xMLWriter.writeSimpleElements("url", this.rowSet.getUrl());
        xMLWriter.writeStartElement("sync-provider");
        SyncProvider syncProvider = this.rowSet.getSyncProvider();
        xMLWriter.writeSimpleElements("sync-provider-name", syncProvider.getProviderID());
        xMLWriter.writeSimpleElements("sync-provider-vendor", "unknown");
        xMLWriter.writeSimpleElements("sync-provider-version", "unknown");
        xMLWriter.writeSimpleElements("sync-provider-grade", syncProvider.getProviderGrade());
        xMLWriter.writeSimpleElements("data-source-lock", syncProvider.getDataSourceLock());
        xMLWriter.writeEndElement("sync-provider");
        xMLWriter.writeEndElement("properties");
    }

    private void writeMetaData(XMLWriter xMLWriter) throws SQLException, IOException {
        xMLWriter.writeStartElement("metadata");
        xMLWriter.writeSimpleElements("column-count", this.metaData.getColumnCount());
        for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
            xMLWriter.writeStartElement("column-definition");
            xMLWriter.writeSimpleElements("column-index", i);
            xMLWriter.writeSimpleElements("auto-increment", this.metaData.isAutoIncrement(i));
            xMLWriter.writeSimpleElements("column-class-name", this.metaData.isDefinitelyWritable(i));
            xMLWriter.writeSimpleElements("definitely-writable", this.metaData.isDefinitelyWritable(i));
            xMLWriter.writeSimpleElements("case-sensitive", this.metaData.isCaseSensitive(i));
            xMLWriter.writeSimpleElements("currency", this.metaData.isCurrency(i));
            xMLWriter.writeSimpleElements("nullable", this.metaData.isNullable(i));
            xMLWriter.writeSimpleElements("signed", this.metaData.isSigned(i));
            xMLWriter.writeSimpleElements("searchable", this.metaData.isSearchable(i));
            xMLWriter.writeSimpleElements("column-display-size", this.metaData.getColumnDisplaySize(i));
            xMLWriter.writeSimpleElements("column-label", this.metaData.getColumnLabel(i));
            xMLWriter.writeSimpleElements("column-name", this.metaData.getColumnName(i));
            xMLWriter.writeSimpleElements("column-class-name", this.metaData.getColumnClassName(i));
            xMLWriter.writeSimpleElements("schema-name", this.metaData.getSchemaName(i));
            xMLWriter.writeSimpleElements("column-precision", this.metaData.getPrecision(i));
            xMLWriter.writeSimpleElements("column-scale", this.metaData.getScale(i));
            xMLWriter.writeSimpleElements("table-name", this.metaData.getTableName(i));
            xMLWriter.writeSimpleElements("catalog-name", this.metaData.getCatalogName(i));
            xMLWriter.writeSimpleElements("column-type", this.metaData.getColumnType(i));
            xMLWriter.writeSimpleElements("column-type-name", this.metaData.getColumnTypeName(i));
            xMLWriter.writeEndElement("column-definition");
        }
        xMLWriter.writeEndElement("metadata");
    }

    private void writeData(XMLWriter xMLWriter) throws SQLException, IOException {
        xMLWriter.writeStartElement("data");
        Iterator iterator = this.rowSet.getCachedRows().iterator();
        while (iterator.hasNext()) {
            this.writeRow((CachedRow)iterator.next(), xMLWriter);
        }
        xMLWriter.writeEndElement("data");
    }

    private void writeRow(CachedRow cachedRow, XMLWriter xMLWriter) throws SQLException, IOException {
        if (cachedRow.isInsertRow()) {
            xMLWriter.writeStartElement("insertRow");
            this.writeColumns(cachedRow, xMLWriter);
            xMLWriter.writeEndElement("insertRow");
        } else if (cachedRow.isDeletedRow()) {
            xMLWriter.writeStartElement("deleteRow");
            this.writeColumns(cachedRow, xMLWriter);
            xMLWriter.writeEndElement("deleteRow");
        } else if (cachedRow.isUpdatedRow()) {
            xMLWriter.writeStartElement("modifyRow");
            this.writeColumns(cachedRow, xMLWriter);
            xMLWriter.writeEndElement("modifyRow");
        } else {
            xMLWriter.writeStartElement("currentRow");
            this.writeColumns(cachedRow, xMLWriter);
            xMLWriter.writeEndElement("currentRow");
        }
    }

    private void writeColumns(CachedRow cachedRow, XMLWriter xMLWriter) throws SQLException, IOException {
        for (int i = 0; i < cachedRow.getColumnCount(); ++i) {
            if (cachedRow.isUpdatedRow() && cachedRow.isModified(i + 1)) {
                xMLWriter.writeStartElement("columnValue");
                xMLWriter.writeCharacterData(TypeMapper.getXMLValue(this.metaData.getColumnType(i + 1), cachedRow.getOldColumn(i + 1)));
                xMLWriter.writeEndElement("columnValue");
                xMLWriter.writeStartElement("updateValue");
                xMLWriter.writeCharacterData(TypeMapper.getXMLValue(this.metaData.getColumnType(i + 1), cachedRow.getColumn(i + 1)));
                xMLWriter.writeEndElement("updateValue");
                continue;
            }
            xMLWriter.writeStartElement("columnValue");
            xMLWriter.writeCharacterData(TypeMapper.getXMLValue(this.metaData.getColumnType(i + 1), cachedRow.getColumn(i + 1)));
            xMLWriter.writeEndElement("columnValue");
        }
    }
}

