/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.WLCachedRowSet;
import weblogic.jdbc.rowset.WLRowSetInternal;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLUtils;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.util.TypeFilter;

public final class XMLInstanceReader
implements XMLSchemaConstants {
    private static final int ROW_UNCHANGED = 1;
    private static final int ROW_INSERTED = 2;
    private static final int ROW_MODIFIED = 4;
    private static final int ROW_MODIFIED_ORIGINAL = 8;
    private static final int ROW_DELETED_ORIGINAL = 16;
    private WLCachedRowSet rowSet;
    private WLRowSetMetaData metaData;
    private XMLName rowName;
    private XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();

    public XMLInstanceReader(WLCachedRowSet wLCachedRowSet) throws SQLException {
        this.rowSet = wLCachedRowSet;
        this.metaData = (WLRowSetMetaData)wLCachedRowSet.getMetaData();
        this.rowName = ElementFactory.createXMLName((String)this.metaData.getDefaultNamespace(), (String)this.metaData.getRowName());
    }

    private BitSet readRow(XMLInputStream xMLInputStream, CachedRow cachedRow) throws IOException, SQLException {
        String string = null;
        BitSet bitSet = new BitSet();
        while (xMLInputStream.hasNext()) {
            int n;
            XMLEvent xMLEvent = xMLInputStream.next();
            if (xMLEvent instanceof StartElement) {
                string = xMLEvent.getName().getLocalName();
                if (XMLUtils.getOptionalBooleanAttribute((StartElement)xMLEvent, NIL_NAME)) {
                    if (string == null) {
                        throw new IOException("Found null column value:  with no corresponding column name.");
                    }
                    n = this.metaData.findColumn(string);
                    cachedRow.setColumn(n, null);
                    bitSet.set(n - 1);
                }
            } else if (xMLEvent instanceof CharacterData) {
                if (string == null) {
                    throw new IOException("Found column value: " + ((CharacterData)xMLEvent).getContent() + " with no corresponding column name.");
                }
                n = this.metaData.findColumn(string);
                Object object = TypeMapper.getJavaValue(this.metaData.getColumnType(n), ((CharacterData)xMLEvent).getContent());
                cachedRow.setColumn(n, object);
                bitSet.set(n - 1);
            }
            if (!((xMLEvent = xMLInputStream.peek()) instanceof StartElement) || !this.rowName.equals(((StartElement)xMLEvent).getName())) continue;
            return bitSet;
        }
        return bitSet;
    }

    private int getRowId(StartElement startElement) throws IOException {
        Attribute attribute = startElement.getAttributeByName(WLDD_ROWID);
        if (attribute == null) {
            throw new IOException("Unable to find required id attribute on row");
        }
        String string = attribute.getValue();
        if (string == null) {
            throw new IOException("Row's id attribute was found, but the value was null");
        }
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Could not convert row's id value: " + string + " into an integer value: " + numberFormatException);
        }
    }

    private int getRowState(StartElement startElement) throws IOException {
        Attribute attribute = startElement.getAttributeByName(WLDD_ROWSTATE);
        if (attribute == null) {
            return 1;
        }
        String string = attribute.getValue();
        if ("unchanged".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("inserted".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("modified".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("modifiedoriginal".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("deletedoriginal".equalsIgnoreCase(string)) {
            return 16;
        }
        throw new IOException("Unrecognized row state: " + string);
    }

    private void setRowStateFlags(CachedRow cachedRow, int n) throws SQLException {
        switch (n) {
            case 1: {
                cachedRow.setInsertRow(false);
                cachedRow.setDeletedRow(false);
                cachedRow.setUpdatedRow(false);
                break;
            }
            case 2: {
                cachedRow.setInsertRow(true);
                cachedRow.setDeletedRow(false);
                cachedRow.setUpdatedRow(false);
                break;
            }
            case 4: {
                cachedRow.setInsertRow(false);
                cachedRow.setDeletedRow(false);
                cachedRow.setUpdatedRow(true);
                break;
            }
            case 8: {
                cachedRow.setInsertRow(false);
                cachedRow.setDeletedRow(false);
                cachedRow.setUpdatedRow(false);
                break;
            }
            case 16: {
                cachedRow.setInsertRow(false);
                cachedRow.setDeletedRow(true);
                cachedRow.setUpdatedRow(false);
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
    }

    private void addRow(Map map, Map map2, CachedRow cachedRow, int n, int n2) throws IOException, SQLException {
        Integer n3 = new Integer(n);
        CachedRow cachedRow2 = (CachedRow)map.get(n3);
        if (cachedRow2 == null) {
            this.setRowStateFlags(cachedRow, n2);
            map.put(n3, cachedRow);
        } else {
            BitSet bitSet = (BitSet)map2.get(n3);
            if (n2 == 4) {
                cachedRow2.mergeNewValues(cachedRow, bitSet);
            } else if (n2 == 8) {
                cachedRow2.mergeOriginalValues(cachedRow, bitSet);
            } else {
                throw new IOException("Found multiple rows with an id: " + n + ", but the row states did not indicate they were the same row");
            }
        }
    }

    private void readRows(XMLInputStream xMLInputStream) throws IOException, SQLException {
        TreeMap treeMap = new TreeMap();
        HashMap<Integer, BitSet> hashMap = new HashMap<Integer, BitSet>();
        while (xMLInputStream.hasNext()) {
            StartElement startElement = (StartElement)xMLInputStream.next();
            CachedRow cachedRow = new CachedRow(this.metaData);
            BitSet bitSet = this.readRow(xMLInputStream, cachedRow);
            int n = this.getRowId(startElement);
            int n2 = this.getRowState(startElement);
            if (n2 == 8) {
                hashMap.put(new Integer(n), bitSet);
            }
            this.addRow(treeMap, hashMap, cachedRow, n, n2);
        }
        ((WLRowSetInternal)this.rowSet).getCachedRows().addAll(treeMap.values());
    }

    public void loadXML(XMLInputStream xMLInputStream) throws IOException, SQLException {
        XMLInputStream xMLInputStream2 = this.factory.newInputStream(xMLInputStream, (ElementFilter)new TypeFilter(18));
        this.parseRowSet(xMLInputStream2);
    }

    private void parseRowSet(XMLInputStream xMLInputStream) throws IOException, SQLException {
        if (!xMLInputStream.hasNext()) {
            throw new IOException("XML Instance document is empty");
        }
        StartElement startElement = (StartElement)xMLInputStream.next();
        String string = XMLUtils.getOptionalStringAttribute(startElement, SCHEMA_LOCATION_NAME);
        if (string != null) {
            this.metaData.setXMLSchemaLocation(string);
        }
        xMLInputStream.skip(this.rowName);
        this.readRows(xMLInputStream);
    }
}

