/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.WLCachedRowSet;
import weblogic.jdbc.rowset.WLRowSetInternal;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLWriter;
import weblogic.utils.AssertionError;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;

public final class XMLInstanceWriter
implements XMLSchemaConstants {
    private WLRowSetInternal rowSet;
    private WLRowSetMetaData metaData;
    private static ColumnFilter all = new ColumnFilter(){

        public boolean include(CachedRow cachedRow, int n) {
            return true;
        }
    };
    private static ColumnFilter mod = new ColumnFilter(){

        public boolean include(CachedRow cachedRow, int n) throws SQLException {
            return cachedRow.isModified(n + 1);
        }
    };

    public XMLInstanceWriter(WLCachedRowSet wLCachedRowSet) throws SQLException {
        this.rowSet = (WLRowSetInternal)wLCachedRowSet;
        this.metaData = (WLRowSetMetaData)wLCachedRowSet.getMetaData();
    }

    private Attribute getAttr(String string, String string2) {
        return ElementFactory.createAttribute((String)string, (String)string2);
    }

    private Attribute getAttr(XMLName xMLName, String string) {
        return ElementFactory.createAttribute((XMLName)xMLName, (String)string);
    }

    private Attribute getDefaultNS(String string) {
        return ElementFactory.createNamespaceAttribute(null, (String)string);
    }

    public void writeXML(XMLOutputStream xMLOutputStream, int n) throws SQLException, IOException {
        XMLWriter xMLWriter = new XMLWriter(xMLOutputStream, this.metaData.getDefaultNamespace());
        RowWriter rowWriter = RowWriter.getWriter(xMLWriter, this.metaData, n);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = this.getDefaultNS(this.metaData.getDefaultNamespace());
        arrayList.add(attribute);
        arrayList.add(SCHEMA_INSTANCE_NAMESPACE);
        arrayList.add(WLDATA_NAMESPACE);
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        arrayList2.add(this.getAttr(SCHEMA_LOCATION_NAME, this.metaData.getXMLSchemaLocation()));
        xMLWriter.writeStartElement(this.metaData.getRowSetName(), arrayList2.iterator(), arrayList.iterator());
        List list = this.rowSet.getCachedRows();
        int n2 = 0;
        for (CachedRow cachedRow : list) {
            rowWriter.writeRow(cachedRow, n2++);
        }
        xMLWriter.writeEndElement(this.metaData.getRowSetName());
        xMLOutputStream.flush();
    }

    private static class AllRowsWriter
    extends RowWriter {
        AllRowsWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            this.writeRow(cachedRow, true, n, all);
            if (cachedRow.isUpdatedRow() && !cachedRow.isInsertRow()) {
                this.writeRow(cachedRow, false, n, mod);
            }
        }
    }

    private static class ChangedAllWriter
    extends RowWriter {
        ChangedAllWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            if (cachedRow.isInsertRow() || cachedRow.isDeletedRow() || cachedRow.isUpdatedRow()) {
                this.writeRow(cachedRow, true, n, all);
                if (cachedRow.isUpdatedRow()) {
                    this.writeRow(cachedRow, false, n, mod);
                }
            }
        }
    }

    private static class CurrentAllWriter
    extends RowWriter {
        CurrentAllWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            this.writeRow(cachedRow, true, n, all);
        }
    }

    private static class ChangedOriginalWriter
    extends RowWriter {
        ChangedOriginalWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            if (cachedRow.isUpdatedRow()) {
                this.writeRow(cachedRow, false, n, mod);
            }
        }
    }

    private static class ChangedCurrentWriter
    extends RowWriter {
        ChangedCurrentWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            if (cachedRow.isInsertRow() || cachedRow.isDeletedRow() || cachedRow.isUpdatedRow()) {
                this.writeRow(cachedRow, true, n, all);
            }
        }
    }

    private static class UnchangedCurrentWriter
    extends RowWriter {
        UnchangedCurrentWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            super(xMLWriter, wLRowSetMetaData);
        }

        void writeRow(CachedRow cachedRow, int n) throws SQLException, IOException {
            if (cachedRow.isInsertRow() || cachedRow.isDeletedRow() || cachedRow.isUpdatedRow()) {
                return;
            }
            this.writeRow(cachedRow, true, n, all);
        }
    }

    private static abstract class RowWriter {
        private WLRowSetMetaData metaData;
        private XMLWriter writer;

        static RowWriter getWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData, int n) {
            switch (n) {
                case 1: {
                    return new UnchangedCurrentWriter(xMLWriter, wLRowSetMetaData);
                }
                case 2: {
                    return new ChangedCurrentWriter(xMLWriter, wLRowSetMetaData);
                }
                case 4: {
                    return new ChangedOriginalWriter(xMLWriter, wLRowSetMetaData);
                }
                case 8: {
                    return new CurrentAllWriter(xMLWriter, wLRowSetMetaData);
                }
                case 16: {
                    return new ChangedAllWriter(xMLWriter, wLRowSetMetaData);
                }
                case 32: {
                    return new AllRowsWriter(xMLWriter, wLRowSetMetaData);
                }
            }
            throw new AssertionError("Unexpected rowStates: " + n);
        }

        RowWriter(XMLWriter xMLWriter, WLRowSetMetaData wLRowSetMetaData) {
            this.writer = xMLWriter;
            this.metaData = wLRowSetMetaData;
        }

        abstract void writeRow(CachedRow var1, int var2) throws SQLException, IOException;

        private String getRowStateString(CachedRow cachedRow, boolean bl) {
            if (cachedRow.isInsertRow()) {
                return "Inserted";
            }
            if (cachedRow.isUpdatedRow() && bl) {
                return "Modified";
            }
            if (cachedRow.isUpdatedRow() && !bl) {
                return "ModifiedOriginal";
            }
            if (cachedRow.isDeletedRow()) {
                return "DeletedOriginal";
            }
            throw new AssertionError("Unexpected row: " + cachedRow);
        }

        protected void writeRow(CachedRow cachedRow, boolean bl, int n, ColumnFilter columnFilter) throws SQLException, IOException {
            if (!bl || cachedRow.isUpdatedRow() || cachedRow.isInsertRow() || cachedRow.isDeletedRow()) {
                this.writer.writeStartElement(this.metaData.getRowName(), XMLSchemaConstants.WLDD_ROWID, String.valueOf(n), XMLSchemaConstants.WLDD_ROWSTATE, this.getRowStateString(cachedRow, bl));
            } else {
                this.writer.writeStartElement(this.metaData.getRowName(), XMLSchemaConstants.WLDD_ROWID, String.valueOf(n));
            }
            for (int i = 0; i < cachedRow.getColumnCount(); ++i) {
                if (!columnFilter.include(cachedRow, i)) continue;
                String string = this.metaData.getColumnName(i + 1);
                Object object = null;
                object = bl ? (cachedRow.isDeletedRow() && cachedRow.isUpdatedRow() ? cachedRow.getOldColumn(i + 1) : cachedRow.getColumn(i + 1)) : cachedRow.getOldColumn(i + 1);
                if (object == null) {
                    this.writer.writeStartElement(string, XMLSchemaConstants.NIL_NAME, "true");
                } else {
                    this.writer.writeStartElement(string);
                    this.writer.writeCharacterData(TypeMapper.getXMLValue(this.metaData.getColumnType(i + 1), object));
                }
                this.writer.writeEndElement(string);
            }
            this.writer.writeEndElement(this.metaData.getRowName());
        }
    }

    private static interface ColumnFilter {
        public boolean include(CachedRow var1, int var2) throws SQLException;
    }
}

