/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLUtils;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.util.TypeFilter;

public final class XMLSchemaReader
implements XMLSchemaConstants {
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = true;
    private CachedRowSetMetaData metaData;
    private XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();

    public XMLSchemaReader(WLRowSetMetaData wLRowSetMetaData) {
        this.metaData = (CachedRowSetMetaData)wLRowSetMetaData;
    }

    public void loadSchema(XMLInputStream xMLInputStream) throws IOException, SQLException {
        this.parse(this.factory.newInputStream(xMLInputStream, (ElementFilter)new TypeFilter(2)));
    }

    private void parse(XMLInputStream xMLInputStream) throws IOException, SQLException {
        while (xMLInputStream.skip(ELEMENT_NAME)) {
            StartElement startElement = this.getNext(xMLInputStream);
            String string = XMLUtils.getRequiredAttribute(startElement, "name").getValue();
            if (!this.metaData.claimSchema(string)) continue;
            this.parseRowSet(xMLInputStream, startElement);
            return;
        }
        throw new IOException("XMLInputStream did not contain a row set matching the name: " + this.metaData.getRowSetName() + ".  Please ensure your XMLInputStream does contain a rowset " + "schema.  Also ensure that the WLRowSetMetaData.getRowSetName()" + " matches the name attribute in the schema");
    }

    private void parseRowSet(XMLInputStream xMLInputStream, StartElement startElement) throws IOException, SQLException {
        int n;
        String string = XMLUtils.getRequiredAttribute(startElement, WLDD_DEFAULT_NAMESPACE).getValue();
        this.metaData.setDefaultNamespace(string);
        String string2 = XMLUtils.getRequiredAttribute(startElement, "name").getValue();
        this.metaData.setRowSetName(string2);
        String string3 = XMLUtils.getOptionalStringAttribute(startElement, WLDD_WRITE_TABLE_NAME);
        this.metaData.setWriteTableName(string3);
        String string4 = XMLUtils.getOptionalStringAttribute(startElement, WLDD_OPTPOLICY);
        if (string4 != null) {
            this.metaData.setOptimisticPolicyAsString(string4);
        }
        try {
            n = Integer.parseInt(XMLUtils.getOptionalStringAttribute(startElement, WLDD_METADATA_VERSION));
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        this.metaData.setVersion(n);
        if (n >= 2) {
            boolean bl = XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_VALID_METADATA);
            DatabaseMetaDataHolder databaseMetaDataHolder = null;
            if (bl) {
                databaseMetaDataHolder = new DatabaseMetaDataHolder(Integer.parseInt(XMLUtils.getOptionalStringAttribute(startElement, WLDD_MAX_CATALOG_NAME_LENGTH)), Integer.parseInt(XMLUtils.getOptionalStringAttribute(startElement, WLDD_MAX_SCHEMA_NAME_LENGTH)), Integer.parseInt(XMLUtils.getOptionalStringAttribute(startElement, WLDD_MAX_TABLE_NAME_LENGTH)), XMLUtils.getOptionalStringAttribute(startElement, WLDD_IDENTIFIER_QUOTE_STRING), XMLUtils.getOptionalStringAttribute(startElement, WLDD_CATALOG_SEPARATOR), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_CATALOG_AT_START), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_SUPPORTS_SCHEMAS_IN_DML), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_SUPPORTS_CATALOGS_IN_DML), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_UPPER_CASE_IDENTIFIERS), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_LOWER_CASE_IDENTIFIERS), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_MIXED_CASE_IDENTIFIERS), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_UPPER_CASE_QUOTED_IDENTIFIERS), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_LOWER_CASE_QUOTED_IDENTIFIERS), XMLUtils.getOptionalBooleanAttribute(startElement, WLDD_STORES_MIXED_CASE_QUOTED_IDENTIFIERS));
            }
            this.metaData.setMetaDataHolder(databaseMetaDataHolder);
        } else {
            this.metaData.setMetaDataHolder(null);
        }
        xMLInputStream.skip(ELEMENT_NAME);
        this.parseRow(xMLInputStream);
    }

    private void parseRow(XMLInputStream xMLInputStream) throws IOException, SQLException {
        StartElement startElement = this.getNext(xMLInputStream);
        this.checkName(startElement, ELEMENT_NAME);
        this.metaData.readRowAttributes(startElement);
        String string = XMLUtils.getRequiredAttribute(startElement, "name").getValue();
        this.metaData.setRowName(string);
        xMLInputStream.skip(ELEMENT_NAME);
        this.parseColumns(xMLInputStream);
    }

    private void parseColumns(XMLInputStream xMLInputStream) throws IOException, SQLException {
        StartElement startElement;
        List<StartElement> list = new ArrayList();
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.peek();
            if (xMLEvent instanceof StartElement) {
                if (!ELEMENT_NAME.equals(xMLEvent.getName())) break;
                startElement = (StartElement)xMLInputStream.next();
                list.add(startElement);
                continue;
            }
            xMLInputStream.next();
        }
        if (this.metaData.getColumnCount() > 0) {
            list = this.pruneColumnList(list);
        } else {
            this.metaData.setColumnCount(list.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            startElement = (StartElement)list.get(i);
            this.metaData.readXMLAttributes(i, startElement);
        }
    }

    private List pruneColumnList(List list) throws IOException, SQLException {
        int n;
        CharSequence charSequence;
        Object object;
        if (this.metaData.getColumnCount() > list.size()) {
            throw new IOException("Existing WLCachedRowSetMetaData contains " + this.metaData.getColumnCount() + " columns, but the XML Schema contains " + list.size() + " columns.  The XML Schema must be a " + "superset of the existing WLCachedRowSetMetaData.");
        }
        Iterator iterator = list.iterator();
        ArrayList<StartElement> arrayList = new ArrayList<StartElement>();
        int n2 = 1;
        while (iterator.hasNext()) {
            object = (StartElement)iterator.next();
            charSequence = XMLUtils.getRequiredAttribute(object, "name").getValue();
            try {
                n = this.metaData.findColumn((String)charSequence);
                if (n == n2) {
                    arrayList.add((StartElement)object);
                    ++n2;
                    continue;
                }
                throw new IOException("The column named: " + (String)charSequence + " was found in the existing WLCachedRowSetMetaData at " + "column " + n + " however we expected it at " + n2 + ".  This could indicate the column " + this.metaData.getColumnName(n2) + " is not in the XML Schema" + ", or the order of columns in the schema is not the same " + "as the order of columns in the WLCachedRowSetMetaData.");
            }
            catch (SQLException sQLException) {
            }
        }
        if (n2 != this.metaData.getColumnCount() + 1) {
            object = "";
            charSequence = new StringBuffer();
            n = this.metaData.getColumnCount() + 1;
            while (n2 != n) {
                ((StringBuffer)charSequence).append((String)object);
                object = ", ";
                ((StringBuffer)charSequence).append(this.metaData.getColumnName(n2));
                ++n2;
            }
            throw new IOException("The following columns are in the existing WLCachedRowSetMetaData, but are not in the XML Schema: " + ((StringBuffer)charSequence).toString() + ".  The XML Schema must be a superset of the " + "existing WLCachedRowSetMetaData.");
        }
        return arrayList;
    }

    private StartElement getNext(XMLInputStream xMLInputStream) throws IOException {
        if (xMLInputStream.hasNext()) {
            return (StartElement)xMLInputStream.next();
        }
        return null;
    }

    private void checkName(StartElement startElement, XMLName xMLName) throws IOException {
        if (startElement == null) {
            throw new IOException("Expected Element: " + xMLName + " but found end of file (EOF)");
        }
        if (!xMLName.equals(startElement.getName())) {
            throw new IOException("Expected Element: " + xMLName + " but found " + startElement.getName());
        }
    }
}

