/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.TypeMapper;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.jdbc.rowset.XMLUtils;
import weblogic.jdbc.rowset.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;

public final class XMLSchemaWriter
implements XMLSchemaConstants {
    private CachedRowSetMetaData metaData;

    public XMLSchemaWriter(WLRowSetMetaData wLRowSetMetaData) {
        this.metaData = (CachedRowSetMetaData)wLRowSetMetaData;
    }

    private Attribute getAttr(String string, String string2) {
        return ElementFactory.createAttribute((String)string, (String)string2);
    }

    private Attribute getAttr(XMLName xMLName, String string) {
        return ElementFactory.createAttribute((XMLName)xMLName, (String)string);
    }

    private Attribute getAttr(XMLName xMLName, boolean bl) {
        return ElementFactory.createAttribute((XMLName)xMLName, (String)(bl ? "true" : "false"));
    }

    private Attribute getAttr(XMLName xMLName, int n) {
        return ElementFactory.createAttribute((XMLName)xMLName, (String)("" + n));
    }

    private Attribute getDefaultNS(String string) {
        return ElementFactory.createNamespaceAttribute(null, (String)string);
    }

    private void writeRowSet(XMLWriter xMLWriter) throws IOException, SQLException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(this.getAttr("name", this.metaData.getRowSetName()));
        arrayList.add(this.getAttr(WLDD_DEFAULT_NAMESPACE, this.metaData.getDefaultNamespace()));
        arrayList.add(ISROWSET_ATTR);
        if (this.metaData.isReadOnly()) {
            arrayList.add(ISREADONLY_ATTR);
        } else {
            int n;
            String string = this.metaData.getWriteTableName();
            if (string != null && !"".equals(string)) {
                arrayList.add(this.getAttr(WLDD_WRITE_TABLE_NAME, string));
            }
            if (this.metaData.getOptimisticPolicy() != 1) {
                arrayList.add(this.getAttr(WLDD_OPTPOLICY, this.metaData.getOptimisticPolicyAsString()));
            }
            if ((n = this.metaData.getVersion()) >= 2) {
                arrayList.add(this.getAttr(WLDD_METADATA_VERSION, n));
                boolean bl = this.metaData.isValidMetaData();
                arrayList.add(this.getAttr(WLDD_VALID_METADATA, bl));
                if (bl) {
                    DatabaseMetaDataHolder databaseMetaDataHolder = this.metaData.getMetaDataHolder();
                    arrayList.add(this.getAttr(WLDD_MAX_CATALOG_NAME_LENGTH, databaseMetaDataHolder.getMaxCatalogNameLength()));
                    arrayList.add(this.getAttr(WLDD_MAX_SCHEMA_NAME_LENGTH, databaseMetaDataHolder.getMaxSchemaNameLength()));
                    arrayList.add(this.getAttr(WLDD_MAX_TABLE_NAME_LENGTH, databaseMetaDataHolder.getMaxTableNameLength()));
                    arrayList.add(this.getAttr(WLDD_IDENTIFIER_QUOTE_STRING, databaseMetaDataHolder.getIdentifierQuoteString()));
                    arrayList.add(this.getAttr(WLDD_CATALOG_SEPARATOR, databaseMetaDataHolder.getCatalogSeparator()));
                    arrayList.add(this.getAttr(WLDD_CATALOG_AT_START, databaseMetaDataHolder.isCatalogAtStart()));
                    arrayList.add(this.getAttr(WLDD_SUPPORTS_SCHEMAS_IN_DML, databaseMetaDataHolder.supportsSchemasInDataManipulation()));
                    arrayList.add(this.getAttr(WLDD_SUPPORTS_CATALOGS_IN_DML, databaseMetaDataHolder.supportsCatalogsInDataManipulation()));
                    arrayList.add(this.getAttr(WLDD_STORES_UPPER_CASE_IDENTIFIERS, databaseMetaDataHolder.storesUpperCaseIdentifiers()));
                    arrayList.add(this.getAttr(WLDD_STORES_LOWER_CASE_IDENTIFIERS, databaseMetaDataHolder.storesLowerCaseIdentifiers()));
                    arrayList.add(this.getAttr(WLDD_STORES_MIXED_CASE_IDENTIFIERS, databaseMetaDataHolder.storesMixedCaseIdentifiers()));
                    arrayList.add(this.getAttr(WLDD_STORES_UPPER_CASE_QUOTED_IDENTIFIERS, databaseMetaDataHolder.storesUpperCaseQuotedIdentifiers()));
                    arrayList.add(this.getAttr(WLDD_STORES_LOWER_CASE_QUOTED_IDENTIFIERS, databaseMetaDataHolder.storesLowerCaseQuotedIdentifiers()));
                    arrayList.add(this.getAttr(WLDD_STORES_MIXED_CASE_QUOTED_IDENTIFIERS, databaseMetaDataHolder.storesMixedCaseQuotedIdentifiers()));
                }
            }
        }
        xMLWriter.writeStartElement(ELEMENT_NAME, arrayList.iterator());
        xMLWriter.writeStartElement(COMPLEX_TYPE_NAME);
        xMLWriter.writeStartElement(CHOICE_NAME, "maxOccurs", "unbounded");
        this.writeRow(xMLWriter);
        xMLWriter.writeEndElement(CHOICE_NAME);
        xMLWriter.writeEndElement(COMPLEX_TYPE_NAME);
        xMLWriter.writeEndElement(ELEMENT_NAME);
    }

    private void writeRow(XMLWriter xMLWriter) throws IOException, SQLException {
        Map map = this.metaData.getAllRowAttributes();
        if (map.isEmpty()) {
            xMLWriter.writeStartElement(ELEMENT_NAME, "name", this.metaData.getRowName());
        } else {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            arrayList.add(this.getAttr("name", this.metaData.getRowName()));
            XMLUtils.addAttributesFromPropertyMap(arrayList, map);
            xMLWriter.writeStartElement(ELEMENT_NAME, arrayList.iterator());
        }
        xMLWriter.writeStartElement(COMPLEX_TYPE_NAME);
        this.writeColumns(xMLWriter);
        xMLWriter.writeEndElement(COMPLEX_TYPE_NAME);
        xMLWriter.writeEndElement(ELEMENT_NAME);
    }

    private void writeColumns(XMLWriter xMLWriter) throws IOException, SQLException {
        xMLWriter.writeStartElement(SEQUENCE_NAME);
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            arrayList.add(this.getAttr("name", this.metaData.getColumnName(i + 1)));
            int n = this.metaData.getColumnType(i + 1);
            XMLName xMLName = TypeMapper.getXSDType(n);
            arrayList.add(this.getAttr("type", xMLName.getPrefix() + ":" + xMLName.getLocalName()));
            arrayList.add(this.getAttr(WLDD_JDBC_TYPE, TypeMapper.getJDBCTypeAsString(n)));
            arrayList.add(this.getAttr("minOccurs", "0"));
            this.metaData.setXMLAttributes(i, arrayList);
            xMLWriter.writeStartElement(ELEMENT_NAME, arrayList.iterator());
            xMLWriter.writeEndElement(ELEMENT_NAME);
        }
        xMLWriter.writeEndElement(SEQUENCE_NAME);
        if (!this.metaData.isReadOnly()) {
            xMLWriter.writeStartElement(ANY_ATTRIBUTE_NAME, "namespace", "http://www.bea.com/2002/10/weblogicdata", "processContents", "skip");
            xMLWriter.writeEndElement(ANY_ATTRIBUTE_NAME);
        }
    }

    public void writeSchema(XMLOutputStream xMLOutputStream) throws IOException, SQLException {
        XMLWriter xMLWriter = new XMLWriter(xMLOutputStream);
        Attribute attribute = this.getAttr("targetNamespace", this.metaData.getDefaultNamespace());
        Attribute attribute2 = this.getDefaultNS(this.metaData.getDefaultNamespace());
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(attribute);
        arrayList.add(attribute2);
        arrayList.add(SCHEMA_NAMESPACE);
        arrayList.add(WLDATA_NAMESPACE);
        arrayList.add(ELEMENT_FORM_DEFAULT_ATTR);
        arrayList.add(ATTRIBUTE_FORM_DEFAULT_ATTR);
        xMLWriter.writeStartElement(SCHEMA_NAME, arrayList.iterator());
        this.writeRowSet(xMLWriter);
        xMLWriter.writeEndElement(SCHEMA_NAME);
        xMLOutputStream.flush();
    }
}

