/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.rowset.XMLSchemaConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.Location;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLName;

final class XMLUtils
implements XMLSchemaConstants {
    XMLUtils() {
    }

    private static String loc(StartElement startElement) {
        Location location = startElement.getLocation();
        return "line: " + location.getLineNumber() + " column: " + location.getColumnNumber();
    }

    public static boolean getOptionalBooleanAttribute(StartElement startElement, XMLName xMLName) throws IOException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute == null) {
            return false;
        }
        try {
            return new Boolean(attribute.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Expected true or false, but found " + attribute.getValue() + " for attribute: " + xMLName + " on element: " + startElement + " at " + XMLUtils.loc(startElement));
        }
    }

    public static String getOptionalStringAttribute(StartElement startElement, XMLName xMLName) throws IOException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public static Attribute getRequiredAttribute(StartElement startElement, String string) throws IOException {
        return XMLUtils.getRequiredAttribute(startElement, ElementFactory.createXMLName((String)string));
    }

    public static Attribute getRequiredAttribute(StartElement startElement, XMLName xMLName) throws IOException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute == null) {
            throw new IOException("Element " + startElement.getName() + " at " + XMLUtils.loc(startElement) + " does not contain required attribute: " + xMLName.getLocalName());
        }
        return attribute;
    }

    public static void addAttributesFromPropertyMap(List list, Map map) {
        for (XMLName xMLName : map.keySet()) {
            String string = xMLName.getNamespaceUri();
            String string2 = xMLName.getPrefix();
            if (string != null && string2 != null) {
                list.add(ElementFactory.createNamespaceAttribute((String)string2, (String)string));
            }
            Properties properties = (Properties)map.get(xMLName);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                XMLName xMLName2 = ElementFactory.createXMLName((String)string, (String)string3, (String)string2);
                list.add(ElementFactory.createAttribute((XMLName)xMLName2, (String)string4));
            }
        }
    }

    public static Map readPropertyMapFromAttributes(StartElement startElement) {
        HashMap<XMLName, Properties> hashMap = new HashMap<XMLName, Properties>();
        AttributeIterator attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            XMLName xMLName = attribute.getName();
            String string = xMLName.getNamespaceUri();
            if ("http://www.w3.org/2001/XMLSchema".equals(string) || "http://www.bea.com/2002/10/weblogicdata".equals(string) || string == null) continue;
            XMLName xMLName2 = ElementFactory.createXMLName((String)xMLName.getNamespaceUri(), (String)"", (String)xMLName.getPrefix());
            Properties properties = (Properties)hashMap.get(xMLName2);
            if (properties == null) {
                properties = new Properties();
                hashMap.put(xMLName2, properties);
            }
            properties.put(xMLName.getLocalName(), attribute.getValue());
        }
        return hashMap;
    }
}

