/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.jdbc.common.internal.ParentLogger;
import weblogic.management.configuration.JDBCConnectionPoolMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDataSource
extends ParentLogger
implements DataSource {
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private Driver dbDriver;
    private PrintWriter debugWriter;
    private JDBCConnectionPoolMBean poolBean;
    private JDBCDriverParamsBean driverParamsBean;
    private String url;
    private Properties properties;
    private String password;
    static final long serialVersionUID = 7022603236273910391L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_JDBC_After_Connection_Internal;
    public static final DelegatingMonitor _WLDF$INST_FLD_JDBC_Before_Connection_Internal;
    public static final DelegatingMonitor _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public BasicDataSource(JDBCDataSourceBean jDBCDataSourceBean) throws SQLException {
        this(jDBCDataSourceBean, null);
    }

    public BasicDataSource(JDBCDataSourceBean jDBCDataSourceBean, String string) throws SQLException {
        if (jDBCDataSourceBean == null) {
            throw new SQLException("No JDBCDataSourceBean was specified");
        }
        this.password = string;
        this.driverParamsBean = jDBCDataSourceBean.getJDBCDriverParams();
        this.loadDriver(this.driverParamsBean.getDriverName());
    }

    public BasicDataSource(JDBCConnectionPoolMBean jDBCConnectionPoolMBean) throws SQLException {
        this(jDBCConnectionPoolMBean, null);
    }

    public BasicDataSource(JDBCConnectionPoolMBean jDBCConnectionPoolMBean, String string) throws SQLException {
        if (jDBCConnectionPoolMBean == null) {
            throw new SQLException("No JDBCConnectionPoolMBean was specified");
        }
        this.poolBean = jDBCConnectionPoolMBean;
        this.password = string;
        this.loadDriver(jDBCConnectionPoolMBean.getDriverName());
    }

    public BasicDataSource(String string, String string2, Properties properties, String string3) throws SQLException {
        this.url = string;
        this.properties = properties;
        this.password = string3;
        this.loadDriver(string2);
    }

    private void loadDriver(String string) throws SQLException {
        Class<?> clazz;
        if (string == null || string.length() == 0) {
            throw new SQLException("No JDBC driver class was specified");
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw BasicDataSource.makeSQLException("JDBC driver class \"" + string + "\" not found", classNotFoundException);
        }
        try {
            this.dbDriver = (Driver)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw BasicDataSource.makeSQLException("JDBC driver instance of class \"" + string + "\" cannot be created: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw BasicDataSource.makeSQLException("JDBC driver instance of class \"" + string + "\" cannot be created: " + illegalAccessException, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw BasicDataSource.makeSQLException("JDBC driver class \"" + string + "\" does not implement the java.sql.Driver interface", classCastException);
        }
    }

    public static Properties parsePropertiesString(String string) {
        Properties properties = new Properties();
        if (string == null) {
            return properties;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            String string3 = null;
            String string4 = null;
            if (stringTokenizer2.hasMoreElements()) {
                string3 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreElements()) {
                string4 = stringTokenizer2.nextToken();
            }
            if (string3 == null) continue;
            properties.put(string3, string4);
        }
        return properties;
    }

    private Properties getPropsFromBean(JDBCDriverParamsBean jDBCDriverParamsBean) {
        Properties properties = new Properties();
        JDBCPropertiesBean jDBCPropertiesBean = jDBCDriverParamsBean.getProperties();
        if (jDBCPropertiesBean != null) {
            JDBCPropertyBean[] jDBCPropertyBeanArray = jDBCPropertiesBean.getProperties();
            for (int i = 0; jDBCPropertyBeanArray != null && i < jDBCPropertyBeanArray.length; ++i) {
                properties.put(jDBCPropertyBeanArray[i].getName(), jDBCPropertyBeanArray[i].getValue());
            }
        }
        return properties;
    }

    public boolean isDataSource() {
        return this.dbDriver instanceof DataSource;
    }

    public boolean isXADataSource() {
        return this.dbDriver instanceof XADataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection() throws SQLException {
        Connection connection;
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block18: {
            Connection connection2;
            block17: {
                Connection connection3;
                block16: {
                    DynamicJoinPoint dynamicJoinPoint;
                    Object[] objectArray;
                    if (_WLDF$INST_FLD_JDBC_Before_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_JDBC_Before_Connection_Internal.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)1);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Before_Connection_Internal;
                        InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                    }
                    bl = _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var7_6 = null;
                    if (bl) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)1);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    try {
                        String string = this.password != null && this.password.length() > 0 ? this.password : null;
                        if (this.driverParamsBean != null) {
                            Object var5_9 = null;
                            connection3 = this.connectInternal(this.driverParamsBean.getUrl(), this.getPropsFromBean(this.driverParamsBean), null, string == null ? this.driverParamsBean.getPassword() : string);
                            break block16;
                        }
                        if (this.poolBean != null) {
                            connection2 = this.connectInternal(this.poolBean.getURL(), this.poolBean.getProperties(), null, string == null ? this.poolBean.getPassword() : string);
                            break block17;
                        }
                        connection = this.connectInternal(this.url, this.properties, null, this.password);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var5_12 = null;
                        Object var4_16 = null;
                        if (bl) {
                            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                        }
                        if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var4_16), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                        }
                        throw throwable;
                    }
                }
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                    InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connection3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                }
                return connection3;
            }
            Object var5_10 = null;
            Connection connection4 = connection2;
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connection4), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            return connection2;
        }
        Object var5_11 = null;
        Connection connection5 = connection;
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connection5), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block18: {
            Connection connection2;
            block17: {
                Connection connection3;
                block16: {
                    DynamicJoinPoint dynamicJoinPoint;
                    Object[] objectArray;
                    if (_WLDF$INST_FLD_JDBC_Before_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_JDBC_Before_Connection_Internal.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)3);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Before_Connection_Internal;
                        InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                    }
                    bl = _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var8_8 = null;
                    if (bl) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)3);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    try {
                        if (this.driverParamsBean != null) {
                            Object var6_10 = null;
                            connection3 = this.connectInternal(this.driverParamsBean.getUrl(), this.getPropsFromBean(this.driverParamsBean), string, string2);
                            break block16;
                        }
                        if (this.poolBean != null) {
                            connection2 = this.connectInternal(this.poolBean.getURL(), this.poolBean.getProperties(), string, string2);
                            break block17;
                        }
                        connection = this.connectInternal(this.url, this.properties, string, string2);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var6_13 = null;
                        Object var5_17 = null;
                        if (bl) {
                            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                        }
                        if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, null, var5_17), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                        }
                        throw throwable;
                    }
                }
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                }
                if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                    InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, null, (Object)connection3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                }
                return connection3;
            }
            Object var6_11 = null;
            Connection connection4 = connection2;
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
                InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, null, (Object)connection4), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            return connection2;
        }
        Object var6_12 = null;
        Connection connection5 = connection;
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_JDBC_After_Connection_Internal.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_After_Connection_Internal;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, null, (Object)connection5), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        return connection;
    }

    private Connection connectInternal(String string, Properties properties, String string2, String string3) throws SQLException {
        if (properties == null) {
            properties = new Properties();
        }
        if (string2 != null && string2.length() > 0) {
            properties.put(USER_PROPERTY_NAME, string2);
        }
        if (string3 != null && string3.length() > 0) {
            properties.put(PASSWORD_PROPERTY_NAME, string3);
        }
        return this.dbDriver.connect(string, properties);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.debugWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.debugWriter = printWriter;
    }

    private static SQLException makeSQLException(String string, Throwable throwable) {
        SQLException sQLException = new SQLException(string);
        sQLException.initCause(throwable);
        return sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.jdbc.utils.BasicDataSource");
        _WLDF$INST_FLD_JDBC_After_Connection_Internal = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"JDBC_After_Connection_Internal");
        _WLDF$INST_FLD_JDBC_Before_Connection_Internal = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"JDBC_Before_Connection_Internal");
        _WLDF$INST_FLD_JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"JDBC_Diagnostic_Datasource_Get_Connection_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BasicDataSource.java", (String)"weblogic.jdbc.utils.BasicDataSource", (String)"getConnection", (String)"()Ljava/sql/Connection;", (int)254, null, (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BasicDataSource.java", (String)"weblogic.jdbc.utils.BasicDataSource", (String)"getConnection", (String)"(Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", (int)290, null, (boolean)false);
    }
}

