/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class DDInformixJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        if (!this.isValid(this.getInformixServer(jDBCDriverInfo))) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().informixSvrNameReqd());
        }
        return "jdbc:datadirect:informix://" + jDBCDriverInfo.getDbmsHost() + ":" + jDBCDriverInfo.getDbmsPort() + ";informixServer=" + this.getInformixServer(jDBCDriverInfo) + ";databaseName=" + jDBCDriverInfo.getDbmsName();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Properties properties = new Properties();
        properties.put("serverName", jDBCDriverInfo.getDbmsHost());
        properties.put("portNumber", jDBCDriverInfo.getDbmsPort());
        properties.put("user", jDBCDriverInfo.getUserName());
        properties.put("databaseName", jDBCDriverInfo.getDbmsName());
        properties.put("informixServer", this.getInformixServer(jDBCDriverInfo));
        return properties;
    }

    private String getInformixServer(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("informixserver")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return "";
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return "";
    }
}

