/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class DDSybaseJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        String string = "jdbc:datadirect:sybase://" + jDBCDriverInfo.getDbmsHost();
        if (jDBCDriverInfo.getDbmsPort() != null) {
            string = string + ":" + jDBCDriverInfo.getDbmsPort();
        }
        return string;
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        Properties properties = new Properties();
        properties.put("url", this.getURL());
        properties.put("serverName", jDBCDriverInfo.getDbmsHost());
        properties.put("portNumber", jDBCDriverInfo.getDbmsPort());
        properties.put("user", jDBCDriverInfo.getUserName());
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            properties.put("databaseName", jDBCDriverInfo.getDbmsName());
        }
        return properties;
    }
}

