/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class EDBJDBCDriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        String string = "jdbc:edb://" + jDBCDriverInfo.getDbmsHost();
        if (this.isValid(jDBCDriverInfo.getDbmsPort())) {
            string = string + ":" + jDBCDriverInfo.getDbmsPort();
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        return string + "/" + jDBCDriverInfo.getDbmsName();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Properties properties = new Properties();
        if (this.isValid(jDBCDriverInfo.getUserName())) {
            properties.put("user", jDBCDriverInfo.getUserName());
        }
        return properties;
    }
}

