/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfoFactory;
import weblogic.jdbc.utils.MetaJDBCDriverInfo;
import weblogic.jdbc.utils.ParseException;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.util.TypeFilter;

public final class JDBCConnectionMetaDataParser {
    private XMLInputStreamFactory factory = XMLInputStreamFactory.newInstance();
    private static final String XML_FILE_NAME = "jdbcdrivers.xml";
    private List driverInfos = new ArrayList();
    private JDBCDriverInfoFactory theFactory = null;
    private static final XMLName BASE_ATTRIBUTE = ElementFactory.createXMLName((String)"JDBC-Drivers");
    private static final XMLName NAME_ATTRIBUTE = ElementFactory.createXMLName((String)"Name");
    private static final XMLName DRIVER_ATTRIBUTE = ElementFactory.createXMLName((String)"Driver");
    private static final XMLName DRIVER_DBMS_ATTRIBUTE = ElementFactory.createXMLName((String)"Database");
    private static final XMLName DRIVER_VENDOR_ATTRIBUTE = ElementFactory.createXMLName((String)"Vendor");
    private static final XMLName DRIVER_TYPE_ATTRIBUTE = ElementFactory.createXMLName((String)"Type");
    private static final XMLName DRIVER_DBMS_VERSION_ATTRIBUTE = ElementFactory.createXMLName((String)"DatabaseVersion");
    private static final XMLName DRIVER_FORXA_ATTRIBUTE = ElementFactory.createXMLName((String)"ForXA");
    private static final XMLName DRIVER_CERT_ATTRIBUTE = ElementFactory.createXMLName((String)"Cert");
    private static final XMLName DRIVER_CLASSNAME_ATTRIBUTE = ElementFactory.createXMLName((String)"ClassName");
    private static final XMLName DRIVER_URLCLASSNAME_ATTRIBUTE = ElementFactory.createXMLName((String)"URLHelperClassname");
    private static final XMLName DRIVER_TEST_SQL_ATTRIBUTE = ElementFactory.createXMLName((String)"TestSql");
    private static final XMLName DRIVER_INSTALL_URL_ATTRIBUTE = ElementFactory.createXMLName((String)"InstallationUrl");
    private static final XMLName DRIVER_DESCRIPTION_ATTRIBUTE = ElementFactory.createXMLName((String)"Description");
    private static final XMLName ATTRIBUTE_ATTRIBUTE = ElementFactory.createXMLName((String)"Attribute");
    private static final XMLName ATTRIBUTE_DISPLAY_NAME = ElementFactory.createXMLName((String)"DisplayName");
    private static final XMLName ATTRIBUTE_PROP_NAME = ElementFactory.createXMLName((String)"PropertyName");
    private static final XMLName ATTRIBUTE_URL_ATTRIBUTE = ElementFactory.createXMLName((String)"InURL");
    private static final XMLName ATTRIBUTE_REQUIRED_ATTRIBUTE = ElementFactory.createXMLName((String)"Required");
    private static final XMLName ATTRIBUTE_DEFAULT_VALUE_ATTRIBUTE = ElementFactory.createXMLName((String)"DefaultValue");
    private static final XMLName ATTRIBUTE_DESCRIPTION_ATTRIBUTE = ElementFactory.createXMLName((String)"Description");

    public JDBCConnectionMetaDataParser() throws IOException, ParseException {
        this.loadSchema(this.getClass().getResourceAsStream("/jdbcdrivers.xml"));
    }

    public JDBCConnectionMetaDataParser(String string) throws IOException, ParseException {
        this.loadSchema(string);
    }

    public JDBCConnectionMetaDataParser(InputStream inputStream) throws IOException, ParseException {
        this.loadSchema(inputStream);
    }

    public JDBCDriverInfoFactory getJDBCDriverInfoFactory() {
        if (this.theFactory == null) {
            this.theFactory = new JDBCDriverInfoFactory(this.driverInfos);
        }
        return this.theFactory;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Usage weblogic.jdbc.utils.JDBCConnectionMetaDataParser <xml file>");
            System.exit(1);
        }
        JDBCConnectionMetaDataParser jDBCConnectionMetaDataParser = new JDBCConnectionMetaDataParser(stringArray[0]);
    }

    private Attribute getRequiredAttribute(StartElement startElement, XMLName xMLName) throws ParseException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute != null) {
            return attribute;
        }
        throw new ParseException("Expected required attribute: " + xMLName.getLocalName() + " on element: " + startElement.getName().getLocalName());
    }

    private String getNonRequiredAttribute(StartElement startElement, XMLName xMLName) throws ParseException {
        Attribute attribute = startElement.getAttributeByName(xMLName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    private void checkLocalName(String string, XMLEvent xMLEvent) throws ParseException {
        this.checkLocalName(string, xMLEvent.getName());
    }

    private void checkLocalName(String string, XMLName xMLName) throws ParseException {
        if (!string.equals(xMLName.getLocalName())) {
            throw new ParseException("Expected name: '" + string + "' but found '" + xMLName.getLocalName() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchema(String string) throws IOException, ParseException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            this.loadSchema(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchema(InputStream inputStream) throws IOException, ParseException {
        XMLInputStream xMLInputStream = null;
        try {
            xMLInputStream = this.factory.newInputStream(inputStream, (ElementFilter)new TypeFilter(2));
            this.parseSchema(xMLInputStream);
        }
        finally {
            if (xMLInputStream != null) {
                xMLInputStream.close();
            }
        }
    }

    private void parseSchema(XMLInputStream xMLInputStream) throws IOException, ParseException {
        StartElement startElement = (StartElement)xMLInputStream.next();
        this.checkLocalName(BASE_ATTRIBUTE.getLocalName(), (XMLEvent)startElement);
        this.parseDrivers(xMLInputStream);
    }

    private void parseDrivers(XMLInputStream xMLInputStream) throws IOException, ParseException {
        while (xMLInputStream.hasNext()) {
            this.parseDriver(xMLInputStream);
        }
    }

    private void parseDriver(XMLInputStream xMLInputStream) throws IOException, ParseException {
        StartElement startElement = (StartElement)xMLInputStream.next();
        this.checkLocalName(DRIVER_ATTRIBUTE.getLocalName(), startElement.getName());
        MetaJDBCDriverInfo metaJDBCDriverInfo = new MetaJDBCDriverInfo();
        metaJDBCDriverInfo.setDbmsVendor(this.getRequiredAttribute(startElement, DRIVER_DBMS_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setDriverVendor(this.getRequiredAttribute(startElement, DRIVER_VENDOR_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setDriverClassName(this.getRequiredAttribute(startElement, DRIVER_CLASSNAME_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setURLHelperClassName(this.getRequiredAttribute(startElement, DRIVER_URLCLASSNAME_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setType(this.getRequiredAttribute(startElement, DRIVER_TYPE_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setDbmsVersion(this.getRequiredAttribute(startElement, DRIVER_DBMS_VERSION_ATTRIBUTE).getValue());
        metaJDBCDriverInfo.setForXA(this.getNonRequiredAttribute(startElement, DRIVER_FORXA_ATTRIBUTE));
        metaJDBCDriverInfo.setCert(this.getNonRequiredAttribute(startElement, DRIVER_CERT_ATTRIBUTE));
        metaJDBCDriverInfo.setTestSQL(this.getNonRequiredAttribute(startElement, DRIVER_TEST_SQL_ATTRIBUTE));
        metaJDBCDriverInfo.setInstallURL(this.getNonRequiredAttribute(startElement, DRIVER_INSTALL_URL_ATTRIBUTE));
        metaJDBCDriverInfo.setDescription(this.getNonRequiredAttribute(startElement, DRIVER_DESCRIPTION_ATTRIBUTE));
        this.parseAttributes(xMLInputStream, metaJDBCDriverInfo);
        this.driverInfos.add(metaJDBCDriverInfo);
    }

    private void parseAttributes(XMLInputStream xMLInputStream, MetaJDBCDriverInfo metaJDBCDriverInfo) throws IOException, ParseException {
        while (xMLInputStream.hasNext()) {
            XMLName xMLName = xMLInputStream.peek().getName();
            if (ATTRIBUTE_ATTRIBUTE.equals(xMLName)) {
                this.parseAtribute(xMLInputStream, metaJDBCDriverInfo);
                continue;
            }
            return;
        }
    }

    private void parseAtribute(XMLInputStream xMLInputStream, MetaJDBCDriverInfo metaJDBCDriverInfo) throws IOException, ParseException {
        StartElement startElement = (StartElement)xMLInputStream.next();
        this.checkLocalName(ATTRIBUTE_ATTRIBUTE.getLocalName(), (XMLEvent)startElement);
        JDBCDriverAttribute jDBCDriverAttribute = new JDBCDriverAttribute(metaJDBCDriverInfo);
        jDBCDriverAttribute.setName(this.getRequiredAttribute(startElement, NAME_ATTRIBUTE).getValue());
        jDBCDriverAttribute.setDisplayName(this.getNonRequiredAttribute(startElement, ATTRIBUTE_DISPLAY_NAME));
        jDBCDriverAttribute.setPropertyName(this.getNonRequiredAttribute(startElement, ATTRIBUTE_PROP_NAME));
        jDBCDriverAttribute.setDefaultValue(this.getNonRequiredAttribute(startElement, ATTRIBUTE_DEFAULT_VALUE_ATTRIBUTE));
        jDBCDriverAttribute.setInURL(this.getNonRequiredAttribute(startElement, ATTRIBUTE_URL_ATTRIBUTE));
        jDBCDriverAttribute.setIsRequired(this.getNonRequiredAttribute(startElement, ATTRIBUTE_REQUIRED_ATTRIBUTE));
        jDBCDriverAttribute.setDesription(this.getNonRequiredAttribute(startElement, ATTRIBUTE_DESCRIPTION_ATTRIBUTE));
        metaJDBCDriverInfo.setDriverAttribute(jDBCDriverAttribute.getName(), jDBCDriverAttribute);
    }
}

