/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.jdbc.common.internal.AddressList;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.MetaJDBCDriverInfo;

public class JDBCDriverInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = 6919106869180583924L;
    private static boolean debug = false;
    private boolean triedToLoadDriver = false;
    private boolean driverLoaded = false;
    private Exception loadDriverException;
    private MetaJDBCDriverInfo metaInfo = null;
    private Map myJDBCDriverAtributes = null;
    private Map unknownDriverAttributes = null;
    private AddressList hostPorts = new AddressList();
    public static final String DB_HOST = "DbmsHost";
    public static final String DB_PORT = "DbmsPort";
    public static final String DB_SERVERNAME = "DbmsName";
    public static final String DB_USER = "DbmsUsername";
    public static final String DB_PASS = "DbmsPassword";
    public static final String[] WELL_KNOWN_KEYS = new String[]{"DbmsHost", "DbmsPort", "DbmsName", "DbmsUsername", "DbmsPassword"};

    JDBCDriverInfo(MetaJDBCDriverInfo metaJDBCDriverInfo) {
        this.metaInfo = metaJDBCDriverInfo;
    }

    public String getDriverPK() {
        return this.metaInfo.toString();
    }

    public List getDbmsVersionList() {
        return this.metaInfo.getDbmsVersionList();
    }

    public String getDbmsVersion() {
        return this.metaInfo.getDbmsVersion();
    }

    public String getDbmsVendor() {
        return this.metaInfo.getDbmsVendor();
    }

    public String getDriverVendor() {
        return this.metaInfo.getDriverVendor();
    }

    public String getDriverClassName() {
        return this.metaInfo.getDriverClassName();
    }

    public String getURLHelperClassName() {
        return this.metaInfo.getURLHelperClassName();
    }

    public String getType() {
        return this.metaInfo.getType();
    }

    public String getTestSQL() {
        return this.metaInfo.getTestSQL();
    }

    public String getInstallURL() {
        return this.metaInfo.getInstallURL();
    }

    public String getDescription() {
        return this.metaInfo.getDescription();
    }

    public boolean isForXA() {
        return this.metaInfo.isForXA();
    }

    public boolean isCert() {
        return this.metaInfo.isCert();
    }

    public void setDbmsName(String string) {
        this.setWellKnownAttribute(DB_SERVERNAME, string);
    }

    public String getDbmsName() {
        return this.getWellKnownAttribute(DB_SERVERNAME);
    }

    public String getDbmsNameDefault() {
        return this.getDefaultFor(DB_SERVERNAME);
    }

    public void setDbmsHost(String string) {
        this.setWellKnownAttribute(DB_HOST, string);
    }

    public String getDbmsHost() {
        return this.getWellKnownAttribute(DB_HOST);
    }

    public String getDbmsHostDefault() {
        return this.getDefaultFor(DB_HOST);
    }

    public void setDbmsPort(String string) {
        this.setWellKnownAttribute(DB_PORT, string);
    }

    public String getDbmsPort() {
        return this.getWellKnownAttribute(DB_PORT);
    }

    public String getDbmsPortDefault() {
        return this.getDefaultFor(DB_PORT);
    }

    public void setPassword(String string) {
        this.setWellKnownAttribute(DB_PASS, string);
    }

    public String getPassword() {
        return this.getWellKnownAttribute(DB_PASS);
    }

    public void setUserName(String string) {
        this.setWellKnownAttribute(DB_USER, string);
    }

    public String getUserName() {
        return this.getWellKnownAttribute(DB_USER);
    }

    public void setUknownAttribute(String string, String string2) {
        this.setUnknownAttribute(string, string2);
    }

    public boolean isServerNameRequired() {
        return this.isAttributeRequired(DB_SERVERNAME);
    }

    public boolean isPortRequired() {
        return this.isAttributeRequired(DB_PORT);
    }

    public boolean isHostNameRequired() {
        return this.isAttributeRequired(DB_HOST);
    }

    public boolean isUserNameRequired() {
        return this.isAttributeRequired(DB_USER);
    }

    public boolean isPassWordRequired() {
        return this.isAttributeRequired(DB_PASS);
    }

    public void addHostPort(String string, int n) {
        this.hostPorts.add(string, n);
    }

    public void setHostPortAddressList(AddressList addressList) {
        this.hostPorts = addressList;
    }

    public boolean removeHostPort(String string, int n) {
        return this.hostPorts.remove(string, n);
    }

    public AddressList getHostPorts() {
        return this.hostPorts;
    }

    public Map getUnknownDriverAttributes() {
        if (this.unknownDriverAttributes == null) {
            this.unknownDriverAttributes = new LinkedHashMap(this.getUnknownDriverAttributesKeys().size());
            Set set = this.getUnknownDriverAttributesKeys();
            Iterator iterator = set.iterator();
            Map map = this.getDriverAttributes();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.unknownDriverAttributes.put(e, map.get(e));
            }
        }
        return this.unknownDriverAttributes;
    }

    public Map getDriverAttributes() {
        if (this.myJDBCDriverAtributes == null) {
            this.myJDBCDriverAtributes = this.metaInfo.getDriverAttributes();
        }
        return this.myJDBCDriverAtributes;
    }

    public Set getUnknownDriverAttributesKeys() {
        return this.metaInfo.getUnknownDriverAttributesKeys();
    }

    public boolean isDriverInClasspath() {
        if (!this.triedToLoadDriver) {
            try {
                Class.forName(this.getDriverClassName()).newInstance();
                this.driverLoaded = true;
            }
            catch (Exception exception) {
                this.loadDriverException = exception;
            }
        }
        return this.driverLoaded;
    }

    public Exception exceptionEncounteredLoadingDriver() {
        return this.loadDriverException;
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isCert()) {
            stringBuffer.append("*");
        }
        stringBuffer.append(this.getDriverVendor());
        stringBuffer.append("'s ");
        if (!this.getDriverVendor().equals(this.getDbmsVendor())) {
            stringBuffer.append(this.getDbmsVendor() + " ");
        }
        stringBuffer.append("Type ");
        stringBuffer.append(this.getType());
        stringBuffer.append(" Driver ");
        if (this.isForXA()) {
            stringBuffer.append("for Distributed Transactions (XA) ");
        }
        stringBuffer.append(" - Versions : " + this.getDbmsVersion());
        return stringBuffer.toString();
    }

    public String toString() {
        return this.metaInfo.toString();
    }

    public String toVerboseString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DBMS Vendor      :  " + (this.getDbmsVendor() == null ? "null" : this.getDbmsVendor()) + "\n");
        stringBuffer.append("Driver Vendor    :  " + (this.getDriverVendor() == null ? "null" : this.getDriverVendor()) + "\n");
        stringBuffer.append("Driver Type      :  " + (this.getType() == null ? "null" : this.getType()) + "\n");
        stringBuffer.append("Driver Class     :  " + (this.getDriverClassName() == null ? "null" : this.getDriverClassName()) + "\n");
        stringBuffer.append("XA ?             :  " + new Boolean(this.isForXA()).toString() + "\n");
        stringBuffer.append("URLHelperClass   :  " + (this.getURLHelperClassName() == null ? "null" : this.getURLHelperClassName()) + "\n");
        stringBuffer.append("DBMS Version     :  " + (this.getDbmsVersion() == null ? "null" : this.getDbmsVersion()) + "\n");
        stringBuffer.append("DBMS Name        :  " + (this.getDbmsName() == null ? "null" : this.getDbmsName()) + "\n");
        stringBuffer.append("DBMS Host        :  " + (this.getDbmsHost() == null ? "null" : this.getDbmsHost()) + "\n");
        stringBuffer.append("isHostRequired   :  " + new Boolean(this.isHostNameRequired()).toString() + "\n");
        stringBuffer.append("DBMS Port        :  " + (this.getDbmsPort() == null ? "null" : this.getDbmsPort()) + "\n");
        stringBuffer.append("isPortRequired   :  " + new Boolean(this.isPortRequired()).toString() + "\n");
        stringBuffer.append("DBMS password    :  " + (this.getPassword() == null ? "null" : this.getPassword()) + "\n");
        stringBuffer.append("DBMS user        :  " + (this.getUserName() == null ? "null" : this.getUserName()) + "\n");
        stringBuffer.append("DBMS test sql    :  " + (this.getTestSQL() == null ? "null" : this.getTestSQL()) + "\n");
        stringBuffer.append("Description      :  " + (this.getDescription() == null ? "null" : this.getDescription()) + "\n");
        return stringBuffer.toString();
    }

    private void setWellKnownAttribute(String string, String string2) {
        JDBCDriverAttribute jDBCDriverAttribute = null;
        if (this.getDriverAttributes().containsKey(string)) {
            jDBCDriverAttribute = (JDBCDriverAttribute)this.getDriverAttributes().get(string);
        } else {
            jDBCDriverAttribute = new JDBCDriverAttribute(this.metaInfo);
            jDBCDriverAttribute.setName(string2);
        }
        jDBCDriverAttribute.setValue(string2);
        this.getDriverAttributes().put(string, jDBCDriverAttribute);
    }

    private void setUnknownAttribute(String string, String string2) {
        if (!this.getDriverAttributes().containsKey(string)) {
            throw new AssertionError((Object)("Trying to set a value '" + string2 + "' on an unknown attribute '" + string + "'"));
        }
        JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)this.getDriverAttributes().get(string);
        jDBCDriverAttribute.setValue(string2);
        this.getDriverAttributes().put(string, jDBCDriverAttribute);
    }

    private String getWellKnownAttribute(String string) {
        return this.getWellKnownAttribute(string, false);
    }

    private String getWellKnownAttribute(String string, boolean bl) {
        if (this.getDriverAttributes().containsKey(string)) {
            JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)this.getDriverAttributes().get(string);
            if (jDBCDriverAttribute.getValue() != null) {
                return jDBCDriverAttribute.getValue();
            }
            if (bl && jDBCDriverAttribute.getDefaultValue() != null) {
                return jDBCDriverAttribute.getDefaultValue();
            }
        }
        return null;
    }

    private String getDefaultFor(String string) {
        if (this.getAttribute(string) != null) {
            return this.getAttribute(string).getDefaultValue();
        }
        return null;
    }

    private JDBCDriverAttribute getAttribute(String string) {
        if (this.getDriverAttributes().containsKey(string)) {
            return (JDBCDriverAttribute)this.getDriverAttributes().get(string);
        }
        return null;
    }

    private boolean isAttributeRequired(String string) {
        if (this.getDriverAttributes().containsKey(string)) {
            JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)this.getDriverAttributes().get(string);
            return jDBCDriverAttribute.isRequired();
        }
        return false;
    }

    public int compareTo(Object object) throws ClassCastException {
        JDBCDriverInfo jDBCDriverInfo = (JDBCDriverInfo)object;
        return this.getDriverPK().compareTo(jDBCDriverInfo.getDriverPK());
    }
}

