/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.MetaJDBCDriverInfo;

public final class JDBCDriverInfoFactory {
    private List driverInfos = null;
    private String[] dbVendorNames;

    JDBCDriverInfoFactory(List list) {
        this.driverInfos = list;
    }

    public String[] getDBMSVendorNames() {
        if (this.driverInfos == null) {
            return null;
        }
        if (this.dbVendorNames == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (MetaJDBCDriverInfo metaJDBCDriverInfo : this.driverInfos) {
                hashSet.add(metaJDBCDriverInfo.getDbmsVendor());
            }
            this.dbVendorNames = new String[hashSet.size()];
            this.dbVendorNames = hashSet.toArray(this.dbVendorNames);
            Arrays.sort(this.dbVendorNames);
        }
        return this.dbVendorNames;
    }

    public JDBCDriverInfo[] getDriverInfos(String string) throws Exception {
        Object[] objectArray2;
        TreeSet<JDBCDriverInfo> treeSet = new TreeSet<JDBCDriverInfo>();
        for (Object[] objectArray2 : this.driverInfos) {
            if (objectArray2.getDescription() != null && objectArray2.getDescription().indexOf("GridLink") != -1 || !objectArray2.getDbmsVendor().equals(string)) continue;
            treeSet.add(new JDBCDriverInfo((MetaJDBCDriverInfo)objectArray2));
        }
        objectArray2 = new JDBCDriverInfo[treeSet.size()];
        objectArray2 = treeSet.toArray(objectArray2);
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public JDBCDriverInfo[] getGridLinkDriverInfos() throws Exception {
        Object[] objectArray2;
        TreeSet<JDBCDriverInfo> treeSet = new TreeSet<JDBCDriverInfo>();
        for (Object[] objectArray2 : this.driverInfos) {
            if (objectArray2.getDescription() == null || objectArray2.getDescription().indexOf("GridLink") == -1) continue;
            treeSet.add(new JDBCDriverInfo((MetaJDBCDriverInfo)objectArray2));
        }
        objectArray2 = new JDBCDriverInfo[treeSet.size()];
        objectArray2 = treeSet.toArray(objectArray2);
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public JDBCDriverInfo getDriverInfo(String string) throws JDBCDriverInfoException {
        for (MetaJDBCDriverInfo metaJDBCDriverInfo : this.driverInfos) {
            if (!metaJDBCDriverInfo.toString().equals(string)) continue;
            return new JDBCDriverInfo(metaJDBCDriverInfo);
        }
        return null;
    }

    public JDBCDriverInfo getDriverInfoByClass(String string) {
        for (MetaJDBCDriverInfo metaJDBCDriverInfo : this.driverInfos) {
            if (!metaJDBCDriverInfo.getDriverClassName().equals(string)) continue;
            return new JDBCDriverInfo(metaJDBCDriverInfo);
        }
        return null;
    }

    public JDBCDriverInfo getDriverInfoByClass(String string, boolean bl) {
        for (MetaJDBCDriverInfo metaJDBCDriverInfo : this.driverInfos) {
            if (metaJDBCDriverInfo.isForXA() != bl || !metaJDBCDriverInfo.getDriverClassName().equals(string)) continue;
            return new JDBCDriverInfo(metaJDBCDriverInfo);
        }
        return null;
    }

    List getJDBCDriverInfos() {
        ArrayList<JDBCDriverInfo> arrayList = new ArrayList<JDBCDriverInfo>();
        for (MetaJDBCDriverInfo metaJDBCDriverInfo : this.driverInfos) {
            if (metaJDBCDriverInfo.getDescription() != null && metaJDBCDriverInfo.getDescription().indexOf("GridLink") != -1) continue;
            arrayList.add(new JDBCDriverInfo(metaJDBCDriverInfo));
        }
        return arrayList;
    }
}

