/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.List;
import java.util.Properties;
import weblogic.jdbc.utils.JDBCConnectionMetaDataParser;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoFactory;
import weblogic.jdbc.utils.JDBCURLHelper;
import weblogic.jdbc.utils.JDBCURLHelperFactory;

public class JDBCTest {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Usage JDBCTest <files ...>");
            System.exit(1);
        }
        JDBCConnectionMetaDataParser jDBCConnectionMetaDataParser = new JDBCConnectionMetaDataParser(stringArray[0]);
        JDBCURLHelperFactory jDBCURLHelperFactory = JDBCURLHelperFactory.newInstance();
        JDBCDriverInfoFactory jDBCDriverInfoFactory = jDBCConnectionMetaDataParser.getJDBCDriverInfoFactory();
        String[] stringArray2 = jDBCDriverInfoFactory.getDBMSVendorNames();
        System.out.println("List of DataBase Vendors");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(stringArray2[i]);
        }
        System.out.println("\n\n");
        List list = jDBCDriverInfoFactory.getJDBCDriverInfos();
        for (JDBCDriverInfo jDBCDriverInfo : list) {
            System.out.println("==========================================================================");
            System.out.println(jDBCDriverInfo.displayString());
            System.out.println(jDBCDriverInfo.getDriverClassName() + "  " + jDBCDriverInfo.getURLHelperClassName());
            if (jDBCDriverInfo.isServerNameRequired()) {
                System.out.println("ServerName is required");
                System.out.println("           setting to testdb");
                jDBCDriverInfo.setDbmsName("testdb");
            }
            if (jDBCDriverInfo.isPortRequired()) {
                System.out.println("PortName is required");
                System.out.println("         default is : " + jDBCDriverInfo.getDbmsPortDefault());
                System.out.println("         setting to 7777");
                jDBCDriverInfo.setDbmsPort("7777");
            }
            if (jDBCDriverInfo.isHostNameRequired()) {
                System.out.println("HostName is required");
                System.out.println("         default is : " + jDBCDriverInfo.getDbmsHostDefault());
                System.out.println("         setting to localhost");
                jDBCDriverInfo.setDbmsHost("localhost");
            }
            if (jDBCDriverInfo.isUserNameRequired()) {
                System.out.println("UserName is required");
                System.out.println("         setting to scott");
                jDBCDriverInfo.setUserName("scott");
            }
            if (jDBCDriverInfo.isPassWordRequired()) {
                System.out.println("Password is required");
                System.out.println("         setting to tiger");
                jDBCDriverInfo.setPassword("tiger");
            }
            System.out.println("isDriverInClasspath() : " + jDBCDriverInfo.isDriverInClasspath());
            JDBCURLHelper jDBCURLHelper = jDBCURLHelperFactory.getJDBCURLHelper(jDBCDriverInfo);
            System.out.println("URL is : " + jDBCURLHelper.getURL());
            Properties properties = jDBCURLHelper.getProperties();
            System.out.print("Properties are : ");
            if (properties != null) {
                System.out.print("\n");
                for (String string : properties.keySet()) {
                    System.out.print(string + " : " + (String)properties.get(string) + "\n");
                }
            } else {
                System.out.print("none");
            }
            System.out.println("\n");
        }
    }
}

