/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCURLHelper;
import weblogic.jdbc.utils.JDBCURLHelperException;
import weblogic.utils.AssertionError;

public class JDBCURLHelperFactory {
    private JDBCURLHelperFactory() {
    }

    public static JDBCURLHelperFactory newInstance() {
        return new JDBCURLHelperFactory();
    }

    public JDBCURLHelper getJDBCURLHelper(JDBCDriverInfo jDBCDriverInfo) throws JDBCURLHelperException {
        if (jDBCDriverInfo == null) {
            throw new AssertionError("JDBCDriverInfo can't be null");
        }
        String string = jDBCDriverInfo.getURLHelperClassName();
        if (string == null || string.length() < 1) {
            throw new JDBCURLHelperException("URLHelperClassName is invalid for " + jDBCDriverInfo.getDriverVendor() + "'s " + jDBCDriverInfo.getDbmsVendor() + " driver");
        }
        try {
            JDBCURLHelper jDBCURLHelper = (JDBCURLHelper)Class.forName(string).newInstance();
            jDBCURLHelper.setJDBCDriverInfo(jDBCDriverInfo);
            return jDBCURLHelper;
        }
        catch (ClassCastException classCastException) {
            throw new JDBCURLHelperException("Exception instantiating JDBCURLHelperClass", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JDBCURLHelperException("Exception instantiating JDBCURLHelperClass", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JDBCURLHelperException("Exception instantiating JDBCURLHelperClass", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JDBCURLHelperException("Exception instantiating JDBCURLHelperClass", illegalAccessException);
        }
    }
}

