/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class JnetDirectJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        return "jdbc:JSQLConnect://" + jDBCDriverInfo.getDbmsHost() + ":" + jDBCDriverInfo.getDbmsPort();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Properties properties = new Properties();
        if (this.isValid(jDBCDriverInfo.getUserName())) {
            properties.put("user", jDBCDriverInfo.getUserName());
        }
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            properties.put("databaseName", jDBCDriverInfo.getDbmsName());
        }
        return properties;
    }
}

