/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class MSSQLJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        return "jdbc:microsoft:sqlserver://" + jDBCDriverInfo.getDbmsHost() + ":" + jDBCDriverInfo.getDbmsPort();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        Properties properties = new Properties();
        properties.put("serverName", jDBCDriverInfo.getDbmsHost());
        properties.put("dataSourceName", "SQL2000JDBC");
        properties.put("user", jDBCDriverInfo.getUserName());
        properties.put("userName", jDBCDriverInfo.getUserName());
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            properties.put("databaseName", jDBCDriverInfo.getDbmsName());
        }
        properties.put("selectMethod", "cursor");
        properties.put("url", this.getURL());
        return properties;
    }
}

