/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;

public class MetaJDBCDriverInfo
implements Serializable {
    private static final long serialVersionUID = 184401685166623934L;
    private String dbmsVendor;
    private String dbmsDriverVendor;
    private String driverClassName;
    private String driverType;
    private String urlHelperClassname;
    private String testSQL;
    private String versionString;
    private String installURL;
    private String description;
    private String datasourceTemplateName = null;
    private String jdbcProviderTemplateName = null;
    private List versionList = new ArrayList();
    private Map driverAttributes = new LinkedHashMap(20);
    private Map unknownDriverAttributeKeys = new LinkedHashMap(20);
    private boolean forXA;
    private boolean cert = false;

    MetaJDBCDriverInfo() {
    }

    public void setDbmsVersion(String string) {
        this.versionString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.versionList.add(string2);
        }
    }

    public List getDbmsVersionList() {
        return this.versionList;
    }

    public String getDbmsVersion() {
        return this.versionString;
    }

    public void setDbmsVendor(String string) {
        this.dbmsVendor = string;
    }

    public String getDbmsVendor() {
        return this.dbmsVendor;
    }

    public void setDriverVendor(String string) {
        this.dbmsDriverVendor = string;
    }

    public String getDriverVendor() {
        return this.dbmsDriverVendor;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setURLHelperClassName(String string) {
        this.urlHelperClassname = string;
    }

    public String getURLHelperClassName() {
        return this.urlHelperClassname;
    }

    public void setType(String string) {
        this.driverType = string;
    }

    public String getType() {
        return this.driverType;
    }

    public void setTestSQL(String string) {
        this.testSQL = string;
    }

    public String getTestSQL() {
        return this.testSQL;
    }

    public void setInstallURL(String string) {
        this.installURL = string;
    }

    public String getInstallURL() {
        return this.installURL;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setJdbcProviderTemplateName(String string) {
        this.jdbcProviderTemplateName = string;
    }

    public String getJdbcProviderTemplateName() {
        return this.jdbcProviderTemplateName;
    }

    public void setDatasourceTemplateName(String string) {
        this.datasourceTemplateName = string;
    }

    public String getDatasourceTemplateName() {
        return this.datasourceTemplateName;
    }

    public void setForXA(String string) {
        this.setForXA(new Boolean(string));
    }

    public void setForXA(boolean bl) {
        this.forXA = bl;
    }

    public boolean isForXA() {
        return this.forXA;
    }

    public void setCert(String string) {
        this.setCert(new Boolean(string));
    }

    public void setCert(boolean bl) {
        this.cert = bl;
    }

    public boolean isCert() {
        return this.cert;
    }

    public void setDriverAttribute(String string, JDBCDriverAttribute jDBCDriverAttribute) {
        boolean bl = true;
        for (int i = 0; i < JDBCDriverInfo.WELL_KNOWN_KEYS.length; ++i) {
            if (!JDBCDriverInfo.WELL_KNOWN_KEYS[i].equals(string)) continue;
            bl = false;
        }
        if (bl) {
            this.unknownDriverAttributeKeys.put(string, jDBCDriverAttribute);
        }
        this.driverAttributes.put(string, jDBCDriverAttribute);
    }

    public HashMap getDriverAttributes() {
        LinkedHashMap<String, JDBCDriverAttribute> linkedHashMap = new LinkedHashMap<String, JDBCDriverAttribute>(this.driverAttributes.size());
        for (String string : this.driverAttributes.keySet()) {
            JDBCDriverAttribute jDBCDriverAttribute = null;
            try {
                jDBCDriverAttribute = (JDBCDriverAttribute)((JDBCDriverAttribute)this.driverAttributes.get(string)).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            linkedHashMap.put(string, jDBCDriverAttribute);
        }
        return linkedHashMap;
    }

    public Set getUnknownDriverAttributesKeys() {
        return this.unknownDriverAttributeKeys.keySet();
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isCert()) {
            stringBuffer.append("*");
        }
        stringBuffer.append(this.getDriverVendor());
        stringBuffer.append("'s");
        if (!this.getDriverVendor().equals(this.getDbmsVendor())) {
            stringBuffer.append(" " + this.getDbmsVendor());
        }
        stringBuffer.append(" Driver ");
        if (this.isForXA() || this.getType() != null) {
            stringBuffer.append("(");
            if (this.getType() != null) {
                stringBuffer.append(this.getType());
                if (this.isForXA()) {
                    stringBuffer.append(" XA");
                }
                stringBuffer.append(") ");
            } else {
                stringBuffer.append("XA) ");
            }
        }
        if (this.getDescription() != null) {
            stringBuffer.append(this.getDescription() + " ");
        }
        if ((string = this.getDbmsVersion()) != null && !string.trim().equals("")) {
            stringBuffer.append("Versions:");
            stringBuffer.append(this.getDbmsVersion());
        }
        return stringBuffer.toString();
    }
}

