/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class NSKJDBC4DriverURLHelper
extends JDBCURLHelper {
    private String MAX_STATEMENTS_PROPERTY_VALUE = "100";
    private String URL = "jdbc:sqlmx:";

    public String getURL() throws JDBCDriverInfoException {
        return this.URL;
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Properties properties = new Properties();
        if (!this.isValid(jDBCDriverInfo.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().nskCatalogNameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().nskUserNameReqd());
        }
        properties.put("catalog", jDBCDriverInfo.getDbmsName());
        properties.put("maxStatements", this.MAX_STATEMENTS_PROPERTY_VALUE);
        properties.put("schema", jDBCDriverInfo.getUserName());
        properties.put("mploc", "$" + jDBCDriverInfo.getDbmsName() + "." + jDBCDriverInfo.getUserName());
        return properties;
    }
}

