/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class NeonJDBCDriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        String string = this.getDataSource(jDBCDriverInfo);
        if (!this.isValid(string)) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().neonDSNameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        return "jdbc:neon:" + string + ";UID=" + jDBCDriverInfo.getUserName();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        Properties properties = new Properties();
        return properties;
    }

    private String getDataSource(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("datasource")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return "";
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return "";
    }
}

