/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class OracleBIServerURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        String string = null;
        String string2 = null;
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            for (Object object : map.values()) {
                if (((JDBCDriverAttribute)object).getName() == null || ((JDBCDriverAttribute)object).getValue() == null) continue;
                if (((JDBCDriverAttribute)object).getName().equals("ServerHost")) {
                    string = ((JDBCDriverAttribute)object).getValue();
                    continue;
                }
                if (!((JDBCDriverAttribute)object).getName().equals("ServerPort")) continue;
                string2 = ((JDBCDriverAttribute)object).getValue();
                try {
                    Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JDBCDriverInfoException("serverport");
                }
            }
        }
        Object object = "jdbc:oraclebi:";
        if (string != null) {
            if (string2 == null) {
                string2 = "9703";
            }
            object = (String)object + "//" + string + ":" + string2 + "/";
        }
        if ((map = jDBCDriverInfo.getUnknownDriverAttributes()) != null) {
            for (JDBCDriverAttribute jDBCDriverAttribute : map.values()) {
                if (jDBCDriverAttribute.getName() == null || jDBCDriverAttribute.getValue() == null) continue;
                if (jDBCDriverAttribute.getName().equals("Ssl")) {
                    if (!jDBCDriverAttribute.getValue().equals("True") && !jDBCDriverAttribute.getValue().equals("False")) {
                        throw new JDBCDriverInfoException("ssl");
                    }
                    if (jDBCDriverAttribute.getValue().equals("False")) {
                        continue;
                    }
                } else if (jDBCDriverAttribute.getName().equals("TrustAnyServer")) {
                    if (!jDBCDriverAttribute.getValue().equals("True") && !jDBCDriverAttribute.getValue().equals("False")) {
                        throw new JDBCDriverInfoException("trustanyserver");
                    }
                    if (jDBCDriverAttribute.getValue().equals("False")) continue;
                }
                if (jDBCDriverAttribute.getName().equals("LogLevel")) {
                    if (!(jDBCDriverAttribute.getValue().equals("SEVERE") || jDBCDriverAttribute.getValue().equals("WARNING") || jDBCDriverAttribute.getValue().equals("INFO") || jDBCDriverAttribute.getValue().equals("CONFIG") || jDBCDriverAttribute.getValue().equals("FINE") || jDBCDriverAttribute.getValue().equals("FINER") || jDBCDriverAttribute.getValue().equals("FINEST"))) {
                        throw new JDBCDriverInfoException("loglevel");
                    }
                } else if (jDBCDriverAttribute.getName().equals("PrimaryCcsPort")) {
                    try {
                        Integer.parseInt(jDBCDriverAttribute.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JDBCDriverInfoException("primaryccsport");
                    }
                } else if (jDBCDriverAttribute.getName().equals("SecondaryCcsPort")) {
                    try {
                        Integer.parseInt(jDBCDriverAttribute.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JDBCDriverInfoException("secondaryccsport");
                    }
                } else if (jDBCDriverAttribute.getName().equals("ServerHost") || jDBCDriverAttribute.getName().equals("ServerPort")) continue;
                object = (String)object + jDBCDriverAttribute.getName() + "=" + jDBCDriverAttribute.getValue() + ";";
            }
        }
        return object;
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        Properties properties = new Properties();
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (this.isValid(jDBCDriverInfo.getUserName())) {
            properties.put("user", jDBCDriverInfo.getUserName());
        }
        return properties;
    }
}

