/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.common.internal.AddressList;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class OracleJDBC4DescriptorURLHelper
extends JDBCURLHelper {
    public OracleJDBC4DescriptorURLHelper() {
    }

    public OracleJDBC4DescriptorURLHelper(JDBCDriverInfo jDBCDriverInfo) {
        super(jDBCDriverInfo);
    }

    public String getURL() throws JDBCDriverInfoException {
        Object object2;
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        AddressList addressList = jDBCDriverInfo.getHostPorts();
        if (addressList == null || addressList.size() == 0) {
            if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
            }
            if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
            }
            addressList = new AddressList();
            addressList.add(jDBCDriverInfo.getDbmsHost(), Integer.valueOf(jDBCDriverInfo.getDbmsPort()).intValue());
        } else {
            for (Object object2 : addressList) {
                if (!this.isValid(object2.host)) {
                    throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
                }
                if (object2.port > 0) continue;
                throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
            }
        }
        Object object3 = this.getProtocol(jDBCDriverInfo);
        if (!this.isValid((String)object3)) {
            object3 = "TCP";
        }
        if (!this.isValid((String)(object2 = this.getServiceName(jDBCDriverInfo)))) {
            throw new JDBCDriverInfoException("Service name required");
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=");
        for (AddressList.HostPort hostPort : addressList) {
            if (hostPort.protocol != null) {
                stringBuffer.append("(ADDRESS=(PROTOCOL=" + hostPort.protocol + ")(HOST=");
            } else {
                stringBuffer.append("(ADDRESS=(PROTOCOL=" + (String)object3 + ")(HOST=");
            }
            stringBuffer.append(hostPort.host);
            stringBuffer.append(")(PORT=");
            stringBuffer.append(hostPort.port);
            stringBuffer.append("))");
        }
        stringBuffer.append(")");
        stringBuffer.append("(CONNECT_DATA=");
        stringBuffer.append("(SERVICE_NAME=");
        stringBuffer.append((String)object2);
        stringBuffer.append(")");
        stringBuffer.append(")");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        Properties properties = new Properties();
        String string = jDBCDriverInfo.getUserName();
        if (string != null) {
            properties.put("user", string);
        }
        return properties;
    }

    private String getServiceName(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("servicename")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return null;
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private String getProtocol(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("protocol")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return "";
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return "";
    }
}

