/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public abstract class OracleJDBC4DriverURLHelper
extends JDBCURLHelper {
    protected abstract String getSeparator();

    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc:oracle:thin:@");
        stringBuffer.append(jDBCDriverInfo.getDbmsHost());
        stringBuffer.append(":");
        stringBuffer.append(jDBCDriverInfo.getDbmsPort());
        stringBuffer.append(this.getSeparator());
        stringBuffer.append(jDBCDriverInfo.getDbmsName());
        return stringBuffer.toString();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (jDBCDriverInfo.getDbmsName() == null) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().oracleUserIdReqd());
        }
        Properties properties = new Properties();
        String string = jDBCDriverInfo.getUserName();
        if (string != null) {
            properties.put("user", string);
        }
        return properties;
    }

    public static class ServiceHelper
    extends OracleJDBC4DriverURLHelper {
        protected String getSeparator() {
            return "/";
        }
    }

    public static class SIDHelper
    extends OracleJDBC4DriverURLHelper {
        protected String getSeparator() {
            return ":";
        }
    }
}

