/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class OracleJDBCDriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbNameReqd());
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc:oracle:oci:@");
        stringBuffer.append(jDBCDriverInfo.getDbmsName());
        return stringBuffer.toString();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (jDBCDriverInfo.getDbmsName() == null) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().oracleUserIdReqd());
        }
        Properties properties = new Properties();
        String string = jDBCDriverInfo.getUserName();
        if (string != null) {
            properties.put("user", string);
        }
        return properties;
    }
}

