/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverAttribute;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class OracleRACJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        String string = this.getServiceName(jDBCDriverInfo);
        String string2 = this.getProtocol(jDBCDriverInfo);
        if (!this.isValid(string2)) {
            string2 = "TCP";
        }
        StringBuffer stringBuffer = new StringBuffer("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=" + string2 + ")(HOST=");
        stringBuffer.append(jDBCDriverInfo.getDbmsHost());
        stringBuffer.append(")(PORT=");
        stringBuffer.append(jDBCDriverInfo.getDbmsPort());
        stringBuffer.append(")))");
        if (this.isValid(string) || this.isValid(jDBCDriverInfo.getDbmsName())) {
            stringBuffer.append("(CONNECT_DATA=");
        }
        if (this.isValid(string)) {
            stringBuffer.append("(SERVICE_NAME=");
            stringBuffer.append(string);
            stringBuffer.append(")");
        }
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            stringBuffer.append("(INSTANCE_NAME=");
            stringBuffer.append(jDBCDriverInfo.getDbmsName());
            stringBuffer.append(")");
        }
        if (this.isValid(string) || this.isValid(jDBCDriverInfo.getDbmsName())) {
            stringBuffer.append(")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (jDBCDriverInfo.getDbmsName() == null) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().oracleUserIdReqd());
        }
        Properties properties = new Properties();
        String string = jDBCDriverInfo.getUserName();
        if (string != null) {
            properties.put("user", string);
        }
        return properties;
    }

    private String getServiceName(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("servicename")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return null;
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    private String getProtocol(JDBCDriverInfo jDBCDriverInfo) {
        Map map = jDBCDriverInfo.getUnknownDriverAttributes();
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    JDBCDriverAttribute jDBCDriverAttribute = (JDBCDriverAttribute)iterator.next();
                    if (!jDBCDriverAttribute.getName().toLowerCase(Locale.ENGLISH).startsWith("protocol")) continue;
                    if (jDBCDriverAttribute.getValue() == null) {
                        return "";
                    }
                    return jDBCDriverAttribute.getValue();
                }
                catch (Exception exception) {
                }
            }
        }
        return "";
    }
}

