/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class SybaseJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        String string = jDBCDriverInfo.getDbmsName();
        string = !this.isValid(string) ? "" : "/" + string;
        return "jdbc:sybase:Tds:" + jDBCDriverInfo.getDbmsHost() + ":" + jDBCDriverInfo.getDbmsPort() + string;
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getPassword())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPasswordReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getDbmsPort())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbPortReqd());
        }
        Properties properties = new Properties();
        properties.put("networkProtocol", "Tds");
        properties.put("serverName", jDBCDriverInfo.getDbmsHost());
        properties.put("portNumber", jDBCDriverInfo.getDbmsPort());
        properties.put("user", jDBCDriverInfo.getUserName());
        properties.put("userName", jDBCDriverInfo.getUserName());
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            properties.put("databaseName", jDBCDriverInfo.getDbmsName());
        }
        properties.put("url", this.getURL());
        return properties;
    }
}

