/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils;

import java.util.Properties;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.utils.JDBCDriverInfo;
import weblogic.jdbc.utils.JDBCDriverInfoException;
import weblogic.jdbc.utils.JDBCURLHelper;

public class WebLogicMSSQLJDBC4DriverURLHelper
extends JDBCURLHelper {
    public String getURL() throws JDBCDriverInfoException {
        return "jdbc:weblogic:mssqlserver4";
    }

    public Properties getProperties() throws JDBCDriverInfoException {
        JDBCDriverInfo jDBCDriverInfo = this.getJDBCInfo();
        if (!this.isValid(jDBCDriverInfo.getDbmsHost())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbHostReqd());
        }
        if (!this.isValid(jDBCDriverInfo.getUserName())) {
            throw new JDBCDriverInfoException(JDBCUtil.getTextFormatter().dbUsernameReqd());
        }
        Properties properties = new Properties();
        properties.put("server", jDBCDriverInfo.getDbmsHost());
        if (this.isValid(jDBCDriverInfo.getDbmsPort())) {
            properties.put("port", jDBCDriverInfo.getDbmsPort());
        }
        properties.put("user", jDBCDriverInfo.getUserName());
        if (this.isValid(jDBCDriverInfo.getDbmsName())) {
            properties.put("db", jDBCDriverInfo.getDbmsName());
        }
        return properties;
    }
}

