/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils.schema;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.jdbc.utils.schema.Table;

public final class Column
implements Serializable {
    private static final boolean CHAR_TO_BOOLEAN = true;
    private static final boolean NO_BIG_NUMBERS = true;
    private final Table table;
    private final String defaultValue;
    private final String name;
    private final String remarks;
    private final int decimalDigits;
    private final int nullable;
    private final int ordinalPosition;
    private final int radix;
    private final int size;
    private final short type;
    private boolean isIndex;
    private boolean isPrimaryKey;
    private Column importedFrom;
    private final Set exportedTo = new HashSet();

    Column(Table table, ResultSet resultSet) throws SQLException {
        this.table = table;
        this.name = resultSet.getString("COLUMN_NAME");
        this.type = resultSet.getShort("DATA_TYPE");
        this.size = resultSet.getInt("COLUMN_SIZE");
        this.decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
        this.radix = resultSet.getInt("NUM_PREC_RADIX");
        this.nullable = resultSet.getInt("NULLABLE");
        this.remarks = resultSet.getString("REMARKS");
        this.defaultValue = resultSet.getString("COLUMN_DEF");
        this.ordinalPosition = resultSet.getInt("ORDINAL_POSITION");
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public int getRadix() {
        return this.radix;
    }

    public int getNullable() {
        return this.nullable;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean bl) {
        this.isPrimaryKey = bl;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    void setIndex(boolean bl) {
        this.isIndex = bl;
    }

    public Column getImportedFrom() {
        return this.importedFrom;
    }

    void setImportedFrom(Column column) {
        this.importedFrom = column;
    }

    public boolean isImportedKey() {
        return this.importedFrom != null;
    }

    public Iterator getExportedTo() {
        return this.exportedTo.iterator();
    }

    void addExportedTo(Column column) {
        this.exportedTo.add(column);
    }

    public boolean isExportedKey() {
        return this.exportedTo.size() != 0;
    }

    public String getJavaType() {
        switch (this.getType()) {
            case -5: {
                return "long";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "byte[]";
            }
            case -7: {
                return "boolean";
            }
            case 91: 
            case 92: 
            case 93: {
                return "java.util.Date";
            }
            case 1: {
                if (this.getSize() == 1) {
                    return "boolean";
                }
                return "String";
            }
            case 2: 
            case 3: {
                if (this.getDecimalDigits() > 0) {
                    if (this.getSize() < 17) {
                        return "double";
                    }
                    return "double";
                }
                if (this.getSize() < 10) {
                    return "int";
                }
                if (this.getSize() < 19) {
                    return "long";
                }
                return "long";
            }
            case 6: 
            case 8: {
                return "double";
            }
            case 4: {
                return "int";
            }
            case -1: 
            case 12: 
            case 2005: {
                return "String";
            }
            case 7: {
                return "float";
            }
            case 5: {
                return "short";
            }
            case -6: {
                return "byte";
            }
        }
        return "Object";
    }

    public String getJavaObjectType() {
        String string = this.getJavaType();
        if (string.equals("String")) {
            return "String";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        if (string.equals("char")) {
            return "Character";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("short")) {
            return "Short";
        }
        return string;
    }

    public String toString() {
        return super.toString() + " - name: '" + this.name + "'";
    }
}

