/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils.schema;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import weblogic.jdbc.utils.schema.Column;
import weblogic.jdbc.utils.schema.Table;
import weblogic.utils.collections.Iterators;

public class Database
implements Serializable {
    private static final String[] TABLE_TYPES = new String[]{"TABLE"};
    private transient DatabaseMetaData meta;
    private final Map tables = new TreeMap();
    private final String catalog;
    private final String schema;
    private final String query;
    private Set excludes;
    private Set includes;
    protected boolean m_resolveTables = true;
    protected boolean m_loadRelations = true;

    public Database(String string, String string2, String string3) {
        this.catalog = string;
        this.schema = string2;
        this.query = string3;
    }

    public void setExcludes(Set set) {
        if (this.includes != null) {
            throw new IllegalStateException("Includes already set.");
        }
        this.excludes = set;
    }

    public void setIncludes(Set set) {
        if (this.excludes != null) {
            throw new IllegalStateException("Excludes already set.");
        }
        this.includes = set;
    }

    private boolean shouldInclude(Table table) {
        if (this.includes != null) {
            return this.includes.contains(table.getName());
        }
        if (this.excludes != null) {
            return !this.excludes.contains(table.getName());
        }
        return true;
    }

    public void process(Connection connection) throws SQLException {
        this.meta = connection.getMetaData();
        this.loadTables(this.query);
        if (!this.m_resolveTables) {
            return;
        }
        Iterator iterator = this.getTables();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            this.resolveTable(table);
        }
        if (!this.m_loadRelations) {
            return;
        }
        this.loadRelations();
        this.loadManyToMany();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public Iterator getTables() {
        return this.tables.values().iterator();
    }

    protected void addTable(Table table) {
        this.tables.put(table.getName().toLowerCase(), table);
    }

    public Table getTable(String string) {
        return (Table)this.tables.get(string.toLowerCase());
    }

    public void resolveTable(Table table) throws SQLException {
        if (table.isResolved()) {
            return;
        }
        this.loadColumns(table);
        table.setResolved(true);
        this.loadIndices(table);
        this.loadPrimaryKeys(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTables(String string) throws SQLException {
        ResultSet resultSet = this.meta.getTables(this.catalog, this.schema, string, TABLE_TYPES);
        try {
            while (resultSet.next()) {
                Table table = new Table(this, resultSet);
                if (!this.shouldInclude(table)) continue;
                this.addTable(table);
            }
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadColumns(Table table) throws SQLException {
        ResultSet resultSet = this.meta.getColumns(this.catalog, this.schema, table.getName(), "%");
        try {
            while (resultSet.next()) {
                table.addColumn(new Column(table, resultSet));
            }
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPrimaryKeys(Table table) throws SQLException {
        ResultSet resultSet = this.meta.getPrimaryKeys(this.catalog, this.schema, table.getName());
        try {
            while (resultSet.next()) {
                String string = resultSet.getString("COLUMN_NAME");
                Column column = table.getColumn(string);
                column.setPrimaryKey(true);
            }
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIndices(Table table) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = this.meta.getIndexInfo(this.catalog, this.schema, table.getName(), false, false);
        }
        catch (SQLException sQLException) {
            return;
        }
        if (resultSet == null) {
            return;
        }
        try {
            while (resultSet.next()) {
                Column column;
                String string = resultSet.getString("COLUMN_NAME");
                if (string == null || "SYS_NC_OID$".equals(string) || (column = table.getColumn(string)) == null) continue;
                column.setIndex(true);
            }
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRelations() throws SQLException {
        Iterator iterator = this.getTables();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            ResultSet resultSet = this.meta.getImportedKeys(this.catalog, this.schema, table.getName());
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("FKCOLUMN_NAME");
                    String string2 = resultSet.getString("FKTABLE_NAME");
                    String string3 = resultSet.getString("PKCOLUMN_NAME");
                    String string4 = resultSet.getString("PKTABLE_NAME");
                    Table table2 = this.getTable(string4);
                    Column column = table2.getColumn(string3);
                    Column column2 = table.getColumn(string);
                    column2.setImportedFrom(column);
                    column.addExportedTo(column2);
                }
            }
            finally {
                resultSet.close();
            }
        }
    }

    protected void loadManyToMany() throws SQLException {
        Iterator iterator = this.getTables();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (!Iterators.equals((Iterator)table.getColumns(), (Iterator)table.getImportedKeys())) continue;
            table.setManyToMany(true);
        }
    }
}

