/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.utils.schema;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import weblogic.jdbc.utils.schema.Column;
import weblogic.jdbc.utils.schema.Database;
import weblogic.utils.collections.FilteringIterator;

public final class Table
implements Serializable {
    private static final long serialVersionUID = -6006667552519466897L;
    private final Database db;
    private final Map columns = new TreeMap();
    private final String name;
    private final String type;
    private boolean isManyToMany;
    private boolean isResolved;

    Table(Database database, ResultSet resultSet) throws SQLException {
        this.db = database;
        this.name = resultSet.getString("TABLE_NAME");
        this.type = resultSet.getString("TABLE_TYPE");
    }

    public Database getDatabase() {
        return this.db;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Iterator getColumns() {
        return this.columns.values().iterator();
    }

    public Column getColumn(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return (Column)this.columns.get(string.toLowerCase());
    }

    void addColumn(Column column) {
        this.columns.put(column.getName().toLowerCase(), column);
    }

    public boolean isResolved() {
        return this.isResolved;
    }

    void setResolved(boolean bl) {
        this.isResolved = bl;
    }

    public boolean isManyToMany() {
        return this.isManyToMany;
    }

    void setManyToMany(boolean bl) {
        this.isManyToMany = bl;
    }

    public Iterator getPrimaryKeys() {
        return new FilteringIterator(this.getColumns()){

            public boolean accept(Object object) {
                Column column = (Column)object;
                return column.isPrimaryKey();
            }
        };
    }

    public Iterator getIndices() {
        return new FilteringIterator(this.getColumns()){

            public boolean accept(Object object) {
                Column column = (Column)object;
                return column.isIndex();
            }
        };
    }

    public Iterator getImportedKeys() {
        return new FilteringIterator(this.getColumns()){

            public boolean accept(Object object) {
                Column column = (Column)object;
                return column.isImportedKey();
            }
        };
    }

    public Iterator getExportedKeys() {
        return new FilteringIterator(this.getColumns()){

            public boolean accept(Object object) {
                Column column = (Column)object;
                return column.isExportedKey();
            }
        };
    }

    public String toString() {
        return super.toString() + " - name: '" + this.name + "'";
    }

    public Iterator getOneToManyRelations() {
        return this.getOneToManyRelations(false);
    }

    private Iterator getOneToManyRelations(boolean bl) {
        Object object;
        TreeMap treeMap = new TreeMap();
        Object object2 = this.getExportedKeys();
        while (object2.hasNext()) {
            Column column = (Column)object2.next();
            Object object3 = column.getExportedTo();
            while (object3.hasNext()) {
                object = (Column)object3.next();
                if (bl ^ ((Column)object).getTable().isManyToMany()) continue;
                ArrayList<OneToManyRelation> arrayList = (ArrayList<OneToManyRelation>)treeMap.get(((Column)object).getTable().getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<OneToManyRelation>();
                    treeMap.put(((Column)object).getTable().getName(), arrayList);
                }
                OneToManyRelation oneToManyRelation = null;
                for (OneToManyRelation oneToManyRelation2 : arrayList) {
                    if (oneToManyRelation2.exportedColumns.get(column.getName()) != null) continue;
                    oneToManyRelation = oneToManyRelation2;
                    break;
                }
                if (oneToManyRelation == null) {
                    oneToManyRelation = new OneToManyRelation(((Column)object).getTable());
                    arrayList.add(oneToManyRelation);
                }
                oneToManyRelation.exportedColumns.put(column.getName(), object);
            }
        }
        object2 = new HashSet();
        for (Object object3 : treeMap.values()) {
            object = object3.iterator();
            while (object.hasNext()) {
                object2.add(object.next());
            }
        }
        return object2.iterator();
    }

    public Iterator getManyToOneRelations() {
        TreeMap<String, ManyToOneRelation> treeMap = new TreeMap<String, ManyToOneRelation>();
        HashSet<Table> hashSet = new HashSet<Table>();
        Iterator iterator = this.getImportedKeys();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            Table table = column.getImportedFrom().getTable();
            if (hashSet.contains(table)) continue;
            hashSet.add(table);
            Iterator iterator2 = table.getOneToManyRelations();
            while (iterator2.hasNext()) {
                OneToManyRelation oneToManyRelation = (OneToManyRelation)iterator2.next();
                if (oneToManyRelation.getExportedToTable() != this) continue;
                ManyToOneRelation manyToOneRelation = new ManyToOneRelation(table);
                Iterator iterator3 = oneToManyRelation.getExportedColumns();
                while (iterator3.hasNext()) {
                    Column column2 = (Column)iterator3.next();
                    manyToOneRelation.importedColumns.put(column2.getName(), column2);
                }
                treeMap.put(((Column)manyToOneRelation.getImportedColumns().next()).getName(), manyToOneRelation);
            }
        }
        return treeMap.values().iterator();
    }

    public Iterator getManyToManyRelations() {
        HashMap<Table, ManyToManyRelation> hashMap = new HashMap<Table, ManyToManyRelation>();
        Iterator iterator = this.getExportedKeys();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            Iterator iterator2 = column.getExportedTo();
            while (iterator2.hasNext()) {
                Column column2 = (Column)iterator2.next();
                Table table = column2.getTable();
                if (!table.isManyToMany()) continue;
                Iterator iterator3 = table.getImportedKeys();
                while (iterator3.hasNext()) {
                    Column column3 = (Column)iterator3.next();
                    if (column3.getImportedFrom().getTable() == this) continue;
                    ManyToManyRelation manyToManyRelation = (ManyToManyRelation)hashMap.get(table);
                    if (manyToManyRelation == null) {
                        manyToManyRelation = new ManyToManyRelation(table, column3.getImportedFrom().getTable());
                        hashMap.put(table, manyToManyRelation);
                    }
                    manyToManyRelation.joinColumns.add(column3);
                }
            }
        }
        return hashMap.values().iterator();
    }

    public final class ManyToManyRelation {
        private final Table targetTable;
        private final Table joinTable;
        private final Set joinColumns = new HashSet();

        private ManyToManyRelation(Table table2, Table table3) {
            this.joinTable = table2;
            this.targetTable = table3;
        }

        public Table getTargetTable() {
            return this.targetTable;
        }

        public Table getJoinTable() {
            return this.joinTable;
        }

        public Iterator getJoinColumns() {
            return this.joinColumns.iterator();
        }
    }

    public final class ManyToOneRelation {
        private final Table pkTable;
        private final Map importedColumns = new TreeMap();

        private ManyToOneRelation(Table table2) {
            this.pkTable = table2;
        }

        public Table getImportedFromTable() {
            return this.pkTable;
        }

        public Iterator getImportedColumns() {
            return this.importedColumns.values().iterator();
        }
    }

    public final class OneToManyRelation {
        private final Table fkTable;
        private final Map exportedColumns = new TreeMap();

        private OneToManyRelation(Table table2) {
            this.fkTable = table2;
        }

        public Table getExportedToTable() {
            return this.fkTable;
        }

        public Iterator getExportedColumns() {
            return this.exportedColumns.values().iterator();
        }
    }
}

