/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import javax.naming.NamingException;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.jms.BridgeLogger;
import weblogic.jms.bridge.internal.BridgeDebug;
import weblogic.jms.bridge.internal.MessagingBridge;
import weblogic.jms.bridge.internal.MessagingBridgeException;
import weblogic.jndi.Environment;
import weblogic.kernel.Kernel;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class BridgeService
extends AbstractServerService
implements DeploymentHandler {
    private static final int STATE_INITIALIZING = 0;
    private static final int STATE_SUSPENDING = 1;
    private static final int STATE_SUSPENDED = 2;
    private static final int STATE_STARTED = 4;
    private static final int STATE_SHUTTING_DOWN = 8;
    private static final int STATE_CLOSED = 16;
    private static final String BRIDGE_WORK_MANAGER_NAME = "weblogic.jms.MessagingBridge";
    private int state = 0;
    private boolean initialized;
    private final HashMap bridges;
    private long bridgesHighCount;
    private long bridgesTotalCount;
    private final HashSet adapterMBeans;
    private ServerMBean serverMBean;
    private String domainName;
    private static BridgeService bridgeService;
    private final HashMap registrations;
    private WorkManager workManager;
    private EventContext src;
    final BridgeDebug bridgeDebug = new BridgeDebug();

    public BridgeService() {
        bridgeService = this;
        this.adapterMBeans = new HashSet();
        this.bridges = new HashMap();
        this.registrations = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws ServiceFailureException {
        Object object;
        try {
            object = new Environment();
            ((Environment)object).setCreateIntermediateContexts(true);
            this.src = (EventContext)((Environment)object).getInitialContext();
        }
        catch (Exception exception) {
            throw new ServiceFailureException((Throwable)exception);
        }
        DeploymentHandlerHome.addDeploymentHandler(this);
        object = this;
        synchronized (object) {
            this.state = 2;
        }
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("Bridge is initialized");
        }
    }

    public void stop() throws ServiceFailureException {
        this.suspend(false);
        this.shutdown();
    }

    public void halt() throws ServiceFailureException {
        this.suspend(true);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServiceFailureException {
        Iterator iterator;
        this.initialize();
        Object object = this;
        synchronized (object) {
            if ((this.state & 4) != 0) {
                return;
            }
            if ((this.state & 0x10) != 0) {
                BridgeLogger.logBridgeFailedInit();
                return;
            }
            this.state = 4;
            iterator = ((HashMap)this.bridges.clone()).values().iterator();
        }
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("About to start bridge service: state=" + this.state);
        }
        while (iterator.hasNext()) {
            object = (MessagingBridge)iterator.next();
            try {
                ((MessagingBridge)object).resume();
            }
            catch (Exception exception) {
                BridgeLogger.logErrorStartBridge((String)object.getName(), (Exception)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend(boolean bl) {
        Iterator iterator;
        Object object = this;
        synchronized (object) {
            if ((this.state & 0x19) != 0) {
                return;
            }
            this.state = 1;
            iterator = ((HashMap)this.bridges.clone()).values().iterator();
        }
        DeploymentHandlerHome.removeDeploymentHandler(this);
        try {
            while (iterator.hasNext()) {
                object = (MessagingBridge)iterator.next();
                ((MessagingBridge)object).suspend(bl);
            }
        }
        finally {
            object = this;
            synchronized (object) {
                this.state = 2;
            }
        }
    }

    private synchronized boolean isShutdown() {
        return (this.state & 0x18) != 0;
    }

    private synchronized void checkShutdown() throws MessagingBridgeException {
        if (this.isShutdown()) {
            throw new MessagingBridgeException("Messaging Bridge Service is shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        try {
            Iterator iterator;
            BridgeService bridgeService = this;
            synchronized (bridgeService) {
                block24: {
                    if ((this.state & 0x10 | 8) == 0) break block24;
                    return;
                }
                this.state = 8;
                Iterator iterator2 = this.bridges.values().iterator();
                iterator = ((HashMap)this.bridges.clone()).values().iterator();
                while (iterator2.hasNext()) {
                    ((MessagingBridge)iterator2.next()).markShuttingDown();
                }
            }
            while (iterator.hasNext()) {
                try {
                    ((MessagingBridge)iterator.next()).shutdown();
                }
                catch (Throwable throwable) {}
            }
            bridgeService = this;
            synchronized (bridgeService) {
                this.bridges.clear();
                this.adapterMBeans.clear();
            }
        }
        finally {
            BridgeService bridgeService = this;
            synchronized (bridgeService) {
                this.state = 16;
            }
            BridgeLogger.logBridgeShutdown();
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public static BridgeService getBridgeService() {
        return bridgeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessagingBridge createMessagingBridge(MessagingBridgeMBean messagingBridgeMBean) throws DeploymentException {
        if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("creating bridge " + messagingBridgeMBean.getName());
        }
        Object object = this;
        synchronized (object) {
            try {
                this.checkShutdown();
            }
            catch (MessagingBridgeException messagingBridgeException) {
                BridgeLogger.logErrorCreateBridgeWhenShutdown((String)messagingBridgeMBean.getName());
                BridgeService.throwDeploymentException("Error creating messaging bridge " + messagingBridgeMBean.getName(), messagingBridgeException);
            }
        }
        object = null;
        try {
            object = new MessagingBridge(messagingBridgeMBean, this);
        }
        catch (Exception exception) {
            if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeStartup.debug("Error creating bridge " + messagingBridgeMBean.getName(), (Throwable)exception);
            }
            BridgeLogger.logErrorCreateBridge((String)messagingBridgeMBean.getName(), (Exception)exception);
            BridgeService.throwDeploymentException("Error deploying messaging bridge " + messagingBridgeMBean.getName(), exception);
        }
        return object;
    }

    private synchronized void addMessagingBridge(MessagingBridge messagingBridge) throws MessagingBridgeException {
        this.checkShutdown();
        if (this.bridges.put(messagingBridge.getName(), messagingBridge) == null) {
            this.bridgesHighCount = Math.max((long)this.bridges.size(), this.bridgesHighCount);
            ++this.bridgesTotalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessagingBridge(MessagingBridge messagingBridge) {
        if (messagingBridge != null) {
            BridgeService bridgeService = this;
            synchronized (bridgeService) {
                messagingBridge.markShuttingDown();
                this.bridges.remove(messagingBridge.getName());
            }
            try {
                messagingBridge.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagingBridge[] getMessagingBridges() {
        Iterator iterator;
        MessagingBridge[] messagingBridgeArray;
        BridgeService bridgeService = this;
        synchronized (bridgeService) {
            messagingBridgeArray = new MessagingBridge[this.bridges.size()];
            iterator = ((HashMap)this.bridges.clone()).values().iterator();
        }
        int n = 0;
        while (iterator.hasNext()) {
            messagingBridgeArray[n++] = (MessagingBridge)iterator.next();
        }
        return messagingBridgeArray;
    }

    private synchronized MessagingBridge findBridge(String string) {
        return (MessagingBridge)this.bridges.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdapter(String string) {
        Cloneable cloneable = this.adapterMBeans;
        synchronized (cloneable) {
            this.adapterMBeans.add(string);
        }
        HashMap hashMap = this.registrations;
        synchronized (hashMap) {
            cloneable = (HashMap)this.registrations.remove(string);
            if (cloneable == null) {
                return;
            }
            for (MessagingBridge messagingBridge : ((HashMap)cloneable).values()) {
                try {
                    messagingBridge.resume();
                }
                catch (MessagingBridgeException messagingBridgeException) {
                    BridgeLogger.logErrorStartBridge((String)messagingBridge.getName(), (Exception)messagingBridgeException);
                    try {
                        messagingBridge.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    messagingBridgeException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAdapter(String string) {
        Iterator iterator;
        if (this.isShutdown()) {
            return;
        }
        Object object = this;
        synchronized (object) {
            iterator = ((HashMap)this.bridges.clone()).values().iterator();
        }
        while (iterator.hasNext()) {
            object = (MessagingBridge)iterator.next();
            MessagingBridgeMBean messagingBridgeMBean = ((MessagingBridge)object).getMBean();
            if (!BridgeService.seperatedBySlash(messagingBridgeMBean.getSourceDestination().getAdapterJNDIName()).equals(string) && !BridgeService.seperatedBySlash(messagingBridgeMBean.getTargetDestination().getAdapterJNDIName()).equals(string)) continue;
            ((MessagingBridge)object).suspend(false);
            this.registerForAdapterDeployment(string, (MessagingBridge)object);
        }
        object = this.adapterMBeans;
        synchronized (object) {
            this.adapterMBeans.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findAdapterAndRegister(String string, MessagingBridge messagingBridge) {
        HashSet hashSet = this.adapterMBeans;
        synchronized (hashSet) {
            if (this.adapterMBeans.contains(BridgeService.seperatedBySlash(string))) {
                return true;
            }
            this.registerForAdapterDeployment(string, messagingBridge);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerForAdapterDeployment(String string, MessagingBridge messagingBridge) {
        String string2 = BridgeService.seperatedBySlash(string);
        HashMap hashMap = this.registrations;
        synchronized (hashMap) {
            HashMap<String, MessagingBridge> hashMap2 = (HashMap<String, MessagingBridge>)this.registrations.get(string2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, MessagingBridge>();
                this.registrations.put(string2, hashMap2);
                try {
                    this.src.addNamingListener(string, 0, (NamingListener)new AdapterChangeHandler());
                }
                catch (NamingException namingException) {
                    namingException.printStackTrace();
                }
            }
            hashMap2.put(messagingBridge.getName(), messagingBridge);
        }
    }

    private static String seperatedBySlash(String string) {
        String string2 = "";
        int n = string.indexOf(".");
        while (n >= 0) {
            string2 = string2 + string.substring(0, n) + "/";
            string = string.substring(n + 1);
            n = string.indexOf(".");
        }
        string2 = string2 + string;
        return string2;
    }

    public static String seperatedByDot(String string) {
        String string2 = "";
        int n = string.indexOf("/");
        while (n >= 0) {
            string2 = string2 + string.substring(0, n) + ".";
            string = string.substring(n + 1);
            n = string.indexOf("/");
        }
        string2 = string2 + string;
        return string2;
    }

    public static void removeNotificationListener(NotificationBroadcaster notificationBroadcaster, NotificationListener notificationListener) {
        try {
            notificationBroadcaster.removeNotificationListener(notificationListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof MessagingBridgeMBean) {
            this.addBridge((MessagingBridgeMBean)deploymentMBean);
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        if (this.isShutdown()) {
            return;
        }
        if (deploymentMBean instanceof MessagingBridgeMBean) {
            this.removeBridge((MessagingBridgeMBean)deploymentMBean);
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }

    private void addBridge(MessagingBridgeMBean messagingBridgeMBean) throws DeploymentException {
        if (this.findBridge(messagingBridgeMBean.getName()) == null) {
            MessagingBridge messagingBridge = this.createMessagingBridge(messagingBridgeMBean);
            if (messagingBridgeMBean.getTargets()[0] instanceof MigratableTargetMBean) {
                if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeStartup.debug("Bridge " + messagingBridgeMBean.getName() + " is deployed as a migratable");
                }
                try {
                    this.addMessagingBridge(messagingBridge);
                    MigrationManager.singleton().register(messagingBridge, (MigratableTargetMBean)messagingBridgeMBean.getTargets()[0]);
                }
                catch (MigrationException migrationException) {
                    migrationException.printStackTrace();
                    BridgeService.throwDeploymentException("Failed to register with MigrationManager", migrationException);
                }
                catch (MessagingBridgeException messagingBridgeException) {
                    messagingBridgeException.printStackTrace();
                    BridgeService.throwDeploymentException("Failed to add bridge " + messagingBridgeMBean.getName(), messagingBridgeException);
                }
            } else {
                try {
                    messagingBridge.initialize();
                    this.addMessagingBridge(messagingBridge);
                }
                catch (Exception exception) {
                    if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
                        BridgeDebug.MessagingBridgeStartup.debug("Error creating bridge " + messagingBridgeMBean.getName(), (Throwable)exception);
                    }
                    BridgeLogger.logErrorCreateBridge((String)messagingBridge.getName(), (Exception)exception);
                    try {
                        messagingBridge.shutdown();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    BridgeService.throwDeploymentException("Error deploying messaging bridge " + messagingBridge.getName(), exception);
                }
                try {
                    messagingBridge.resume();
                    BridgeLogger.logBridgeDeployed((String)messagingBridge.getName());
                }
                catch (Exception exception) {
                    BridgeLogger.logErrorStartBridge((String)messagingBridge.getName(), (Exception)exception);
                    try {
                        messagingBridge.shutdown();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    this.removeMessagingBridge(messagingBridge);
                    BridgeService.throwDeploymentException("Error deploying Bridge " + messagingBridgeMBean.getName(), exception);
                }
            }
        } else {
            if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeStartup.debug("Bridge " + messagingBridgeMBean.getName() + " already exists");
            }
            BridgeService.throwDeploymentException("Bridge " + messagingBridgeMBean.getName() + " already exists", null);
        }
    }

    private void removeBridge(MessagingBridgeMBean messagingBridgeMBean) throws UndeploymentException {
        MessagingBridge messagingBridge = this.findBridge(messagingBridgeMBean.getName());
        if (messagingBridge != null) {
            this.removeMessagingBridge(messagingBridge);
        } else if (BridgeDebug.MessagingBridgeStartup.isDebugEnabled()) {
            BridgeDebug.MessagingBridgeStartup.debug("Error removing Bridge " + messagingBridge + ": instance doesn't exist");
        }
    }

    public synchronized WorkManager getWorkManager() {
        if (this.workManager == null) {
            int n = -1;
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
            if (serverMBean.getUse81StyleExecuteQueues() && (n = Kernel.getConfig().getMessagingBridgeThreadPoolSize()) <= 0) {
                n = 10;
            }
            this.workManager = WorkManagerFactory.getInstance().findOrCreate(BRIDGE_WORK_MANAGER_NAME, 1, n);
        }
        return this.workManager;
    }

    private static void throwDeploymentException(String string, Exception exception) throws DeploymentException {
        DeploymentException deploymentException = exception != null ? new DeploymentException(string, exception) : new DeploymentException(string);
        throw deploymentException;
    }

    private static void throwUndeploymentException(String string, Exception exception) throws UndeploymentException {
        throw new UndeploymentException(string);
    }

    private final class AdapterChangeHandler
    implements ObjectChangeListener {
        private AdapterChangeHandler() {
        }

        public void objectChanged(NamingEvent namingEvent) {
            switch (namingEvent.getType()) {
                case 0: {
                    BridgeService.this.addAdapter(BridgeService.seperatedBySlash(namingEvent.getNewBinding().getName()));
                    break;
                }
                case 1: {
                    BridgeService.this.removeAdapter(BridgeService.seperatedBySlash(namingEvent.getNewBinding().getName()));
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
            System.out.println(namingExceptionEvent.getException());
        }
    }
}

