/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.Destination;
import javax.jms.InvalidClientIDException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.deployment.jms.JMSSessionPoolManager;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.jms.JMSLogger;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEManager;
import weblogic.jms.backend.BEUOOObjectHandler;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.udd.UDDEntity;
import weblogic.jms.common.CDSRouter;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSException;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSTargetsListener;
import weblogic.jms.common.LeaderManager;
import weblogic.jms.common.SecurityChecker;
import weblogic.jms.common.ServerCrossDomainSecurityUtil;
import weblogic.jms.common.SingularAggregatableManager;
import weblogic.jms.common.TimedSecurityParticipant;
import weblogic.jms.deployer.BEAdminHandler;
import weblogic.jms.deployer.BEDeployer;
import weblogic.jms.deployer.FEDeployer;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dotnet.proxy.ProxyManager;
import weblogic.jms.frontend.FEClientIDSingularAggregatable;
import weblogic.jms.frontend.FEConnection;
import weblogic.jms.frontend.FEConnectionFactory;
import weblogic.jms.frontend.FEManager;
import weblogic.jms.frontend.FrontEnd;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.TargetingHelper;
import weblogic.jms.module.observers.JMSObserver;
import weblogic.jms.multicast.JMSTDMSocket;
import weblogic.jms.multicast.JMSTDMSocketIPM;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.jndi.Environment;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.JMSConnectionRuntimeMBean;
import weblogic.management.runtime.JMSPooledConnectionRuntimeMBean;
import weblogic.management.runtime.JMSRuntimeMBean;
import weblogic.management.runtime.JMSServerRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.utils.GenericBeanListener;
import weblogic.management.utils.GenericManagedService;
import weblogic.management.utils.GenericServiceManager;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.path.internal.PathObjectHandler;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.JMSResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServiceFailureException;
import weblogic.store.ObjectHandler;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public final class JMSService
extends RuntimeMBeanDelegate
implements JMSRuntimeMBean {
    static final long serialVersionUID = -992732582587191590L;
    public static final int STATE_INITIALIZING = 0;
    public static final int STATE_SUSPENDED = 1;
    public static final int STATE_SUSPENDING = 2;
    public static final int STATE_STARTED = 4;
    public static final int STATE_SHUTTING_DOWN = 8;
    public static final int STATE_CLOSED = 16;
    public static final int STATE_DELETING = 32;
    public static final int STATE_DELETED = 64;
    public static final int STATE_BOOTING = 128;
    public static final int STATE_PAUSING_PRODUCTION = 256;
    public static final int STATE_PAUSED_PRODUCTION = 512;
    public static final int STATE_RESUMING_PRODUCTION = 1024;
    public static final int STATE_PAUSING_INSERTION = 2048;
    public static final int STATE_PAUSED_INSERTION = 4096;
    public static final int STATE_RESUMING_INSERTION = 8192;
    public static final int STATE_PAUSING_CONSUMPTION = 16384;
    public static final int STATE_PAUSED_CONSUMPTION = 32768;
    public static final int STATE_RESUMING_CONSUMPTION = 65536;
    public static final int STATE_ADVERTISED_IN_CLUSTER_JNDI = 131072;
    public static final int STATE_ADVERTISED_IN_LOCAL_JNDI = 262144;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String[] stateName = new String[]{"initializing", "suspended", "suspending", "started", "shutting_down", "closed", "deleting", "deleted", "booting", "pausing_production", "paused_production", "resuming_production", "pausing_insertion", "paused_insertion", "resuming_insertion", "pausing_consumption", "paused_consumption", "resuming_consumption", "advertised_in_cluster_jndi", "advertised_in_local_jndi", "unknown"};
    public static final String MESSAGE_LOG_NON_DURABLE_PROP = "weblogic.jms.message.logging.logNonDurableSubscriber";
    public static final String MESSAGE_LOG_DESTINATIONS_ALL_PROP = "weblogic.jms.message.logging.destinations.all";
    public static final String SECURITY_CHECK_INTERVAL_PROP = "weblogic.jms.securityCheckInterval";
    public static final String MULTICAST_SEND_DELAY_PROP = "weblogic.jms.extensions.multicast.sendDelay";
    public static final String BACKEND_JNDI = "weblogic.jms.backend";
    private int state = 0;
    private Object shutdownLock;
    private boolean initialized;
    private volatile boolean startedFirstTime;
    private JMSDispatcher dispatcher;
    private FrontEnd frontEnd;
    private ProxyManager proxyManager;
    private static Context ctx;
    private static Context nonReplicatedCtx;
    private ServerMBean serverMBean;
    private DomainMBean domainMBean;
    private String mbeanName;
    JMSDebug jmsDebug = new JMSDebug();
    private JMSTDMSocket dgmSock;
    private JMSTMSocket mSock;
    private int multicastDelay;
    private static JMSService jmsService;
    private InvocableMonitor invocableMonitor;
    private GenericManagedService beAdminManager;
    private BEDeployer beDeployer;
    private FEDeployer feDeployer;
    private boolean messageLogNonDurableSubscriber;
    private boolean messageLogAll;
    private static final long SECURITY_CHECK_INTERVAL = 60000L;
    private TimerManager securityTimerManager;
    private SecurityChecker securityChecker;
    private Timer securityTimer;
    private long securityCheckInterval = 60000L;
    private static final HashMap<String, Class<Boolean>> wlsServerSignatures;
    private GenericBeanListener wlsServerListener;
    private JMSDiagnosticImageSource diagnosticImageSource;
    private HashSet<JMSTargetsListener> jmsServerListeners = new HashSet();
    private HashMap<String, DescriptorAndListener> jmsServerBeanListeners = new HashMap();
    private boolean use81StyleExecuteQueues;
    private boolean migrationInProgress = false;

    public String getServerName() {
        return this.serverMBean == null ? null : this.serverMBean.getName();
    }

    public String getClusterName() {
        return this.serverMBean == null ? null : (this.serverMBean.getCluster() == null ? null : this.serverMBean.getCluster().getName());
    }

    public String getDomainName() {
        return this.domainMBean == null ? null : this.domainMBean.getName();
    }

    public boolean isMigrationInProgress() {
        return this.migrationInProgress;
    }

    public void setMigrationInProgress(boolean bl) {
        this.migrationInProgress = bl;
    }

    public JMSService() throws ManagementException {
        super(ManagementService.getRuntimeAccess(kernelId).getServerName() + ".jms");
        ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setJMSRuntime(this);
        this.mbeanName = ManagementService.getRuntimeAccess(kernelId).getServerName() + ".jms";
        this.beDeployer = new BEDeployer(this);
        this.feDeployer = new FEDeployer(this);
        this.shutdownLock = this.beDeployer.getShutdownLock();
        this.feDeployer.setShutdownLock(this.shutdownLock);
        JMSSecurityHelper.getSecurityHelper();
        new PathObjectHandler();
        PathObjectHandler.setObjectHandler((byte)1, (ObjectHandler)new BEUOOObjectHandler());
        this.invocableMonitor = new InvocableMonitor(null);
        InvocableManagerDelegate.delegate.addManager(1, new FEManager(this.invocableMonitor));
        InvocableManagerDelegate.delegate.addManager(2, new BEManager(this.invocableMonitor));
        InvocableManagerDelegate.delegate.addManager(21, LeaderManager.getLeaderManager());
        InvocableManagerDelegate.delegate.addManager(23, CDSRouter.getSingleton());
        String string = System.getProperty(MESSAGE_LOG_NON_DURABLE_PROP);
        this.messageLogNonDurableSubscriber = string == null ? false : string.equalsIgnoreCase("true");
        string = System.getProperty(MESSAGE_LOG_DESTINATIONS_ALL_PROP);
        this.messageLogAll = string == null ? false : string.equalsIgnoreCase("true");
        string = System.getProperty(SECURITY_CHECK_INTERVAL_PROP);
        if (string != null) {
            try {
                this.securityCheckInterval = Integer.parseInt(string);
                System.out.println("INFO: Using a JMS security check interval of " + this.securityCheckInterval);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("WARNING: Unable to set securityCheckInterval to " + string + " : " + numberFormatException);
                this.securityCheckInterval = 60000L;
            }
        }
        if (this.securityCheckInterval > 0L) {
            this.securityTimerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.jms.security.checkers", "weblogic.kernel.Default");
            this.securityChecker = new SecurityChecker(this);
        }
        this.diagnosticImageSource = new JMSDiagnosticImageSource();
    }

    public BEDeployer getBEDeployer() {
        return this.beDeployer;
    }

    public FEDeployer getFEDeployer() {
        return this.feDeployer;
    }

    public static final String getStateName(int n) {
        if (n == 0) {
            return stateName[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 1; i < stateName.length - 1; ++i) {
            if ((n & 1 << i - 1) == 0) continue;
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(stateName[i]);
        }
        if (!bl) {
            return stateName[stateName.length - 1];
        }
        return stringBuffer.toString();
    }

    public static synchronized JMSService getService() throws ManagementException {
        if (jmsService == null) {
            jmsService = new JMSService();
        }
        return jmsService;
    }

    public static JMSService getJMSService() {
        return jmsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeJMSServerListeners() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            JMSServerMBean jMSServerMBean = jMSServerMBeanArray[i];
            JMSServerBeanListener jMSServerBeanListener = new JMSServerBeanListener(jMSServerMBeanArray[i]);
            jMSServerMBean.addBeanUpdateListener(jMSServerBeanListener);
            HashMap<String, DescriptorAndListener> hashMap = this.jmsServerBeanListeners;
            synchronized (hashMap) {
                this.jmsServerBeanListeners.put(jMSServerMBeanArray[i].getName(), new DescriptorAndListener(jMSServerMBean, jMSServerBeanListener));
            }
            if (!JMSDebug.JMSBackEnd.isDebugEnabled()) continue;
            JMSDebug.JMSBackEnd.debug("Listening for changes to JMSServer " + jMSServerMBeanArray[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJMSServerListeners() {
        HashMap<String, DescriptorAndListener> hashMap = this.jmsServerBeanListeners;
        synchronized (hashMap) {
            for (String string : this.jmsServerBeanListeners.keySet()) {
                DescriptorAndListener descriptorAndListener = this.jmsServerBeanListeners.get(string);
                DescriptorBean descriptorBean = descriptorAndListener.getDescriptorBean();
                JMSServerBeanListener jMSServerBeanListener = descriptorAndListener.getListener();
                descriptorBean.removeBeanUpdateListener((BeanUpdateListener)jMSServerBeanListener);
                jMSServerBeanListener.close();
            }
        }
    }

    private void initializeObservers() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        runtimeAccess.addAccessCallbackClass(JMSObserver.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws javax.jms.JMSException, ServiceFailureException {
        if (!this.startedFirstTime) {
            if (!this.initialize()) {
                return;
            }
            this.startedFirstTime = true;
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            this.state = 4;
        }
        HealthMonitorService.register(this.mbeanName, this, false);
        this.initializeObservers();
        this.initializeJMSServerListeners();
        this.feDeployer.initialize(this.frontEnd);
        if (this.serverMBean.isJMSDefaultConnectionFactoriesEnabled()) {
            this.ensureInitialized();
        }
        if (this.frontEnd != null) {
            this.frontEnd.resume();
        }
        if (this.proxyManager != null) {
            this.proxyManager.resume();
        }
        this.beAdminManager.start();
        JMSLogger.logJMSActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize() throws javax.jms.JMSException {
        try {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            environment.setReplicateBindings(true);
            ctx = environment.getInitialContext();
            environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            environment.setReplicateBindings(false);
            nonReplicatedCtx = environment.getInitialContext();
        }
        catch (NamingException namingException) {
            JMSLogger.logErrorInitialCtx((Exception)namingException);
            throw new JMSException(namingException);
        }
        Class<?> clazz = this.shutdownLock;
        synchronized (clazz) {
            if (this.isShutdown()) {
                this.state = 0;
            }
        }
        this.serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.initializeDispatcher();
        if (this.frontEnd == null) {
            this.frontEnd = new FrontEnd(this);
        }
        if (this.proxyManager == null) {
            try {
                clazz = Class.forName("weblogic.jms.dotnet.proxy.internal.ProxyManagerImpl");
                Method method = clazz.getMethod("getProxyManager", new Class[0]);
                this.proxyManager = (ProxyManager)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
        }
        this.beAdminManager = GenericServiceManager.getManager().register(JMSServerMBean.class, BEAdminHandler.class, true);
        JMSLogger.logJMSInitialized();
        return true;
    }

    public final synchronized void ensureInitialized() throws javax.jms.JMSException {
        if (this.initialized) {
            return;
        }
        this.multicastDelay = 0;
        try {
            String string = System.getProperty(MULTICAST_SEND_DELAY_PROP);
            if (string != null) {
                this.multicastDelay = Integer.parseInt(string);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("JMS is initialized");
        }
        this.initialized = true;
        this.wlsServerListener = new GenericBeanListener(this.serverMBean, this, wlsServerSignatures);
    }

    public void openMulticastSendSocket() throws javax.jms.JMSException {
        if (this.mSock != null) {
            return;
        }
        try {
            this.dgmSock = new JMSTDMSocketIPM();
            this.mSock = new JMSTMSocket(null, this.dgmSock, this.multicastDelay, 0);
        }
        catch (IOException iOException) {
            if (this.mSock != null) {
                this.mSock.close();
            }
            if (this.dgmSock != null) {
                this.dgmSock.close();
            }
            this.mSock = null;
            this.dgmSock = null;
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("can not open multicast socket " + iOException.toString());
            }
            JMSLogger.logErrorMulticastOpen((Exception)iOException);
            throw new javax.jms.JMSException(iOException.toString());
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Multicast socket is opened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void stop(boolean bl) throws ServiceFailureException {
        try {
            Object object = this.shutdownLock;
            // MONITORENTER : object
            if ((this.state & 0x11) != 0) {
                // MONITOREXIT : object
                Object var7_4 = null;
                Object object2 = this.shutdownLock;
                // MONITORENTER : object2
                this.state = 16;
                // MONITOREXIT : object2
                JMSLogger.logJMSShutdown();
                return;
            }
            this.state = 8;
            this.removeJMSServerListeners();
            if (this.wlsServerListener != null) {
                this.wlsServerListener.close();
            }
            BackEnd[] backEndArray = this.beDeployer.getBackEnds();
            for (int i = 0; i < backEndArray.length; ++i) {
                backEndArray[i].markShuttingDown();
            }
            if (this.frontEnd != null) {
                this.frontEnd.markShuttingDown();
            }
            if (bl) {
                this.invocableMonitor.forceInvocablesCompletion();
            }
            // MONITOREXIT : object
            if (this.frontEnd != null) {
                this.frontEnd.prepareForSuspend(bl);
            }
            if (!bl) {
                this.invocableMonitor.waitForInvocablesCompletion();
            }
            if (this.beAdminManager != null) {
                this.beAdminManager.stop();
            }
            if (this.frontEnd != null) {
                this.frontEnd.shutdown();
            }
            if (this.proxyManager != null) {
                this.proxyManager.shutdown(bl);
            }
            if (this.feDeployer != null) {
                this.feDeployer.shutdown();
            }
            HealthMonitorService.unregister(this.mbeanName);
            try {
                PrivilegedActionUtilities.unregister(this, kernelId);
            }
            catch (ManagementException managementException) {
            }
            Object var7_5 = null;
            Object object3 = this.shutdownLock;
            // MONITORENTER : object3
            this.state = 16;
            // MONITOREXIT : object3
            JMSLogger.logJMSShutdown();
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Object object = this.shutdownLock;
            // MONITORENTER : object
            this.state = 16;
            // MONITOREXIT : object
            JMSLogger.logJMSShutdown();
            throw throwable;
        }
    }

    public HealthState getHealthState() {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        BackEnd[] backEndArray = this.getBEDeployer().getBackEnds();
        for (int i = 0; i < backEndArray.length; ++i) {
            HealthState healthState = backEndArray[i].getHealthState();
            n = Math.max(healthState.getState(), n);
            String[] stringArray = healthState.getReasonCode();
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
        }
        return new HealthState(n, arrayList.toArray(new String[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (this.state & 4) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return (this.state & 0x18) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdown() throws javax.jms.JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShutdown()) {
                throw new JMSException("JMS server shutdown: " + this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkShutdownOrSuspended(String string) throws javax.jms.JMSException {
        Object object = this.shutdownLock;
        synchronized (object) {
            if ((this.state & 0x1B) != 0) {
                throw new javax.jms.JMSException("Failed to " + string + " because JMS server shutdown or suspended");
            }
        }
    }

    public FEConnectionFactory getDefaultConnectionFactory(String string) {
        return this.getFEDeployer().getDefaultConnectionFactory(string);
    }

    public static Context getContext() {
        return ctx;
    }

    public static Context getContext(boolean bl) {
        return bl ? ctx : nonReplicatedCtx;
    }

    public synchronized JMSServerId getNextServerId() {
        return new JMSServerId(JMSID.create(), this.dispatcher.getId());
    }

    public JMSID getNextId() {
        return JMSID.create();
    }

    public JMSMessageId getNextMessageId() {
        return JMSMessageId.create();
    }

    public JMSConnectionRuntimeMBean[] getConnections() {
        return FEManager.getConnections();
    }

    public long getConnectionsCurrentCount() {
        return FEManager.getConnectionsCurrentCount();
    }

    public long getConnectionsHighCount() {
        return FEManager.getConnectionsHighCount();
    }

    public long getConnectionsTotalCount() {
        return FEManager.getConnectionsTotalCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSServerRuntimeMBean[] getJMSServers() {
        BackEnd[] backEndArray = null;
        HashMap<String, BackEnd> hashMap = new HashMap<String, BackEnd>();
        Object object = this.shutdownLock;
        synchronized (object) {
            backEndArray = this.beDeployer.getBackEnds();
            if (backEndArray != null && backEndArray.length > 0) {
                for (int i = 0; i < backEndArray.length; ++i) {
                    if (!backEndArray[i].getConfigType().equals("JMSServer")) continue;
                    hashMap.put(backEndArray[i].getName(), backEndArray[i]);
                }
            }
            BackEnd[] backEndArray2 = new BackEnd[hashMap.size()];
            return hashMap.values().toArray(backEndArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMSServersCurrentCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.getBEDeployer().getBackEndsMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMSServersHighCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.getBEDeployer().getBackEndsHighCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJMSServersTotalCount() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.getBEDeployer().getBackEndsTotalCount();
        }
    }

    public JMSPooledConnectionRuntimeMBean[] getJMSPooledConnections() {
        JMSPooledConnectionRuntimeMBean[] jMSPooledConnectionRuntimeMBeanArray2;
        HashMap<String, JMSPooledConnectionRuntimeMBean> hashMap = new HashMap<String, JMSPooledConnectionRuntimeMBean>();
        JMSSessionPoolManager jMSSessionPoolManager = JMSSessionPoolManager.getSessionPoolManager();
        HashMap hashMap2 = jMSSessionPoolManager.getSessionPools();
        for (JMSPooledConnectionRuntimeMBean[] jMSPooledConnectionRuntimeMBeanArray2 : hashMap2.values()) {
            JMSPooledConnectionRuntimeMBean jMSPooledConnectionRuntimeMBean = (JMSPooledConnectionRuntimeMBean)jMSPooledConnectionRuntimeMBeanArray2.getJMSSessionPoolRuntime();
            if (jMSPooledConnectionRuntimeMBean == null) continue;
            hashMap.put(jMSPooledConnectionRuntimeMBeanArray2.getName(), jMSPooledConnectionRuntimeMBean);
        }
        jMSPooledConnectionRuntimeMBeanArray2 = new JMSPooledConnectionRuntimeMBean[hashMap.size()];
        return hashMap.values().toArray(jMSPooledConnectionRuntimeMBeanArray2);
    }

    public void setJMSDefaultConnectionFactoriesEnabled(boolean bl) {
        try {
            if (bl) {
                this.getFEDeployer().deployDefaultConnectionFactories();
            } else {
                this.getFEDeployer().undeployDefaultConnectionFactories();
            }
        }
        catch (javax.jms.JMSException jMSException) {
            JMSLogger.logErrorDeployingDefaultFactories((String)jMSException.toString());
        }
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public JMSTMSocket getMulticastSocket() {
        if (this.mSock == null) {
            try {
                this.openMulticastSendSocket();
            }
            catch (javax.jms.JMSException jMSException) {
                // empty catch block
            }
        }
        return this.mSock;
    }

    private void initializeDispatcher() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string = runtimeAccess.getServerName();
        this.use81StyleExecuteQueues = ManagementService.getRuntimeAccess(kernelId).getServer().getUse81StyleExecuteQueues();
        JMSDispatcherManager.initialize(string, LocalServerIdentity.getIdentity().getPersistentIdentity().toString(), this.use81StyleExecuteQueues);
        this.dispatcher = JMSDispatcherManager.getLocalDispatcher();
        String string2 = "weblogic.messaging.dispatcher.S:" + this.dispatcher.getId();
        try {
            if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
                JMSDebug.JMSDispatcher.debug("Binding dispatcher to '" + this.name + "'");
            }
            PrivilegedActionUtilities.rebindAsSU(JMSService.getContext(), string2, JMSDispatcherManager.getLocalDispatcherWrapper(), kernelId);
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public void reserveClientID(String string) throws javax.jms.JMSException {
        FEClientIDSingularAggregatable fEClientIDSingularAggregatable;
        String string2;
        SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
        String string3 = singularAggregatableManager.singularBind(string2 = "weblogic.jms.connection.clientid." + string, fEClientIDSingularAggregatable = new FEClientIDSingularAggregatable(string, this.getNextId()));
        if (string3 != null) {
            throw new InvalidClientIDException("Client id, " + string + ", is in use.  The reason for rejection is \"" + string3 + "\"");
        }
    }

    public static void releaseClientID(String string) throws javax.jms.JMSException {
        SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
        String string2 = "weblogic.jms.connection.clientid." + string;
        try {
            singularAggregatableManager.singularUnbind(string2);
        }
        catch (javax.jms.JMSException jMSException) {
            throw new JMSException("Unable to unbind client id " + string + " from JNDI", (Throwable)jMSException);
        }
    }

    public static String getDestinationName(Destination destination) {
        if (destination instanceof DistributedDestinationImpl) {
            return ((DistributedDestinationImpl)destination).getInstanceName();
        }
        return ((DestinationImpl)destination).getName();
    }

    public boolean shouldMessageLogNonDurableSubscriber() {
        return this.messageLogNonDurableSubscriber;
    }

    public boolean shouldMessageLogAll() {
        return this.messageLogAll;
    }

    public FrontEnd getFrontEnd() {
        return this.frontEnd;
    }

    public void registerSecurityParticipant(JMSResource jMSResource, TimedSecurityParticipant timedSecurityParticipant) {
        if (this.securityCheckInterval <= 0L) {
            return;
        }
        this.securityChecker.registerWithChecker(jMSResource, timedSecurityParticipant);
    }

    public boolean isSecurityCheckerStop() {
        return this.securityCheckInterval == 0L;
    }

    public void fireUpSecurityChecks() {
        if (this.securityCheckInterval <= 0L) {
            return;
        }
        if (JMSDebug.JMSCommon.isDebugEnabled()) {
            JMSDebug.JMSCommon.debug("Firing up periodic security checks");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.securityTimer = this.securityTimerManager.schedule((TimerListener)this.securityChecker, 1000L, this.securityCheckInterval);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public void stopSecurityChecks() {
        if (this.securityTimer != null) {
            if (JMSDebug.JMSCommon.isDebugEnabled()) {
                JMSDebug.JMSCommon.debug("Stoping periodic security checks");
            }
            this.securityTimer.cancel();
            this.securityTimer = null;
        }
    }

    void postDeploymentStart() {
        this.beDeployer.postDeploymentsStart();
    }

    void postDeploymentStop() {
        this.beDeployer.postDeploymentsStop();
    }

    void postDeploymentHalt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        HashMap hashMap;
        BEConnection[] bEConnectionArray2;
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("JMS");
        xMLStreamWriter.writeAttribute("id", this.frontEnd.getFrontEndId().toString());
        xMLStreamWriter.writeAttribute("serverName", this.mbeanName);
        xMLStreamWriter.writeAttribute("state", JMSService.getStateName(this.state));
        xMLStreamWriter.writeAttribute("connectionsCurrentCount", String.valueOf(this.getConnectionsCurrentCount()));
        xMLStreamWriter.writeAttribute("connectionsHighCount", String.valueOf(this.getConnectionsHighCount()));
        xMLStreamWriter.writeAttribute("connectionsTotalCount", String.valueOf(this.getConnectionsTotalCount()));
        xMLStreamWriter.writeAttribute("jmsServersCurrentCount", String.valueOf(this.getJMSServersCurrentCount()));
        xMLStreamWriter.writeAttribute("jmsServersHighCount", String.valueOf(this.getJMSServersHighCount()));
        xMLStreamWriter.writeAttribute("jmsServersTotalCount", String.valueOf(this.getJMSServersTotalCount()));
        JMSDiagnosticImageSource.dumpHealthStateElement(xMLStreamWriter, this.getHealthState());
        xMLStreamWriter.writeStartElement("Connections");
        FEConnection[] fEConnectionArray = FEManager.getFEConnections();
        if (fEConnectionArray != null && fEConnectionArray.length > 0) {
            for (int i = 0; i < fEConnectionArray.length; ++i) {
                fEConnectionArray[i].dump(jMSDiagnosticImageSource, xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("JMSServers");
        Iterator iterator = this.shutdownLock;
        synchronized (iterator) {
            bEConnectionArray2 = this.getBEDeployer().getBackEndsMap();
            hashMap = (HashMap)bEConnectionArray2.clone();
        }
        for (BEConnection[] bEConnectionArray2 : hashMap.values()) {
            bEConnectionArray2.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeStartElement("Connections");
        bEConnectionArray2 = BEManager.getBEConnections();
        if (bEConnectionArray2 != null && bEConnectionArray2.length > 0) {
            for (int i = 0; i < bEConnectionArray2.length; ++i) {
                bEConnectionArray2[i].dump(jMSDiagnosticImageSource, xMLStreamWriter);
            }
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    public boolean getUse81StyleExecuteQueues() {
        return this.use81StyleExecuteQueues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJMSServerListener(JMSTargetsListener jMSTargetsListener) {
        HashSet<JMSTargetsListener> hashSet = this.jmsServerListeners;
        synchronized (hashSet) {
            this.jmsServerListeners.add(jMSTargetsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJMSServerListener(JMSTargetsListener jMSTargetsListener) {
        HashSet<JMSTargetsListener> hashSet = this.jmsServerListeners;
        synchronized (hashSet) {
            this.jmsServerListeners.remove(jMSTargetsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireListenersPrepare(DomainMBean domainMBean, JMSServerMBean jMSServerMBean, int n) throws BeanUpdateRejectedException {
        boolean bl = false;
        LinkedList<JMSTargetsListener> linkedList = new LinkedList<JMSTargetsListener>();
        HashSet<JMSTargetsListener> hashSet = this.jmsServerListeners;
        synchronized (hashSet) {
            try {
                Iterator<JMSTargetsListener> iterator = this.jmsServerListeners.iterator();
                while (iterator.hasNext()) {
                    JMSTargetsListener jMSTargetsListener = iterator.next();
                    jMSTargetsListener.prepareUpdate(domainMBean, jMSServerMBean, n, this.migrationInProgress);
                    linkedList.addLast(jMSTargetsListener);
                }
                return;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (bl) throw throwable;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    JMSTargetsListener jMSTargetsListener = (JMSTargetsListener)iterator.next();
                    jMSTargetsListener.rollbackUpdate();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListenersActivateOrRollback(boolean bl) {
        HashSet<JMSTargetsListener> hashSet = this.jmsServerListeners;
        synchronized (hashSet) {
            for (JMSTargetsListener jMSTargetsListener : this.jmsServerListeners) {
                if (bl) {
                    jMSTargetsListener.activateUpdate();
                    continue;
                }
                jMSTargetsListener.rollbackUpdate();
            }
        }
    }

    public void startAddJMSServers(JMSServerMBean jMSServerMBean) throws BeanUpdateRejectedException {
        DomainMBean domainMBean;
        try {
            domainMBean = JMSBeanHelper.getDomain(jMSServerMBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        this.fireListenersPrepare(domainMBean, jMSServerMBean, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAddJMSServers(JMSServerMBean jMSServerMBean, boolean bl) {
        this.fireListenersActivateOrRollback(bl);
        JMSServerBeanListener jMSServerBeanListener = new JMSServerBeanListener(jMSServerMBean);
        jMSServerMBean.addBeanUpdateListener(jMSServerBeanListener);
        HashMap<String, DescriptorAndListener> hashMap = this.jmsServerBeanListeners;
        synchronized (hashMap) {
            this.jmsServerBeanListeners.put(jMSServerMBean.getName(), new DescriptorAndListener(jMSServerMBean, jMSServerBeanListener));
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Listening for changes to JMSServer " + jMSServerMBean.getName());
        }
    }

    public void startRemoveJMSServers(JMSServerMBean jMSServerMBean) throws BeanUpdateRejectedException {
        DomainMBean domainMBean = null;
        try {
            domainMBean = JMSBeanHelper.getDomain(jMSServerMBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        this.fireListenersPrepare(domainMBean, jMSServerMBean, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRemoveJMSServers(JMSServerMBean jMSServerMBean, boolean bl) {
        this.fireListenersActivateOrRollback(bl);
        HashMap<String, DescriptorAndListener> hashMap = this.jmsServerBeanListeners;
        synchronized (hashMap) {
            DescriptorAndListener descriptorAndListener = this.jmsServerBeanListeners.remove(jMSServerMBean.getName());
            if (descriptorAndListener == null) {
                return;
            }
            DescriptorBean descriptorBean = descriptorAndListener.getDescriptorBean();
            JMSServerBeanListener jMSServerBeanListener = descriptorAndListener.getListener();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)jMSServerBeanListener);
            jMSServerBeanListener.close();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Not listening for changes to removed JMSServer " + jMSServerMBean.getName());
        }
    }

    static {
        wlsServerSignatures = new HashMap();
        wlsServerSignatures.put("JMSDefaultConnectionFactoriesEnabled", Boolean.TYPE);
        CrossDomainSecurityManager.setCrossDomainSecurityUtil(new ServerCrossDomainSecurityUtil());
    }

    private static class DescriptorAndListener {
        private DescriptorBean db;
        private JMSServerBeanListener listener;

        private DescriptorAndListener(DescriptorBean descriptorBean, JMSServerBeanListener jMSServerBeanListener) {
            this.db = descriptorBean;
            this.listener = jMSServerBeanListener;
        }

        private DescriptorBean getDescriptorBean() {
            return this.db;
        }

        private JMSServerBeanListener getListener() {
            return this.listener;
        }
    }

    private class JMSServerBeanListener
    implements BeanUpdateListener {
        private JMSServerMBean jmsServer;
        private JMSServerMBean proposedJMSServer;
        private MigratableTargetMBean migratableTarget;
        int numFound;
        boolean jmsServerChanged;

        private JMSServerBeanListener(JMSServerMBean jMSServerMBean) {
            this.jmsServer = jMSServerMBean;
            TargetMBean[] targetMBeanArray = this.jmsServer.getTargets();
            if (targetMBeanArray.length < 1) {
                return;
            }
            TargetMBean targetMBean = targetMBeanArray[0];
            if (targetMBean instanceof MigratableTargetMBean) {
                this.migratableTarget = (MigratableTargetMBean)targetMBean;
                this.migratableTarget.addBeanUpdateListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            DomainMBean domainMBean;
            Object object;
            DescriptorBean descriptorBean;
            this.jmsServerChanged = this.migratableTarget == null ? true : (descriptorBean = beanUpdateEvent.getProposedBean()) instanceof JMSServerMBean;
            boolean bl = false;
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                object = propertyUpdateArray[i];
                if (this.jmsServerChanged && object.getPropertyName().equals("Targets")) {
                    bl = true;
                    break;
                }
                if (this.jmsServerChanged || !object.getPropertyName().equals("UserPreferredServer")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            ++this.numFound;
            this.proposedJMSServer = this.jmsServerChanged ? (JMSServerMBean)beanUpdateEvent.getProposedBean() : this.jmsServer;
            try {
                domainMBean = this.jmsServerChanged ? JMSBeanHelper.getDomain(this.proposedJMSServer) : JMSBeanHelper.getDomain((WebLogicMBean)beanUpdateEvent.getProposedBean());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            object = this;
            synchronized (object) {
                if (UDDEntity.getLocalJMSServers().get(this.proposedJMSServer.getName()) == null && !this.isLocallyTargeted(this.proposedJMSServer)) {
                    JMSService.this.fireListenersPrepare(domainMBean, this.jmsServer, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (this.numFound <= 0) {
                return;
            }
            --this.numFound;
            Object object = this;
            synchronized (object) {
                if (UDDEntity.getLocalJMSServers().get(this.proposedJMSServer.getName()) == null && !this.isLocallyTargeted(this.proposedJMSServer)) {
                    JMSService.this.fireListenersActivateOrRollback(true);
                }
            }
            if (!this.jmsServerChanged) {
                return;
            }
            object = this.migratableTarget;
            if (object != null) {
                object.removeBeanUpdateListener((BeanUpdateListener)this);
            }
            this.migratableTarget = null;
            TargetMBean[] targetMBeanArray = this.jmsServer.getTargets();
            if (targetMBeanArray.length < 1) {
                return;
            }
            TargetMBean targetMBean = targetMBeanArray[0];
            if (targetMBean instanceof MigratableTargetMBean) {
                this.migratableTarget = (MigratableTargetMBean)targetMBean;
                this.migratableTarget.addBeanUpdateListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (this.numFound <= 0) {
                return;
            }
            --this.numFound;
            JMSServerBeanListener jMSServerBeanListener = this;
            synchronized (jMSServerBeanListener) {
                if (UDDEntity.getLocalJMSServers().get(this.proposedJMSServer.getName()) == null && !this.isLocallyTargeted(this.proposedJMSServer)) {
                    JMSService.this.fireListenersActivateOrRollback(false);
                }
            }
        }

        private void close() {
            if (this.migratableTarget == null) {
                return;
            }
            this.migratableTarget.removeBeanUpdateListener(this);
        }

        private boolean isLocallyTargeted(JMSServerMBean jMSServerMBean) {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            if (serverMBean == null) {
                return false;
            }
            return TargetingHelper.isLocallyTargeted(jMSServerMBean, serverMBean.getCluster() == null ? null : serverMBean.getCluster().getName(), serverMBean.getName());
        }
    }
}

