/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms;

import javax.jms.JMSException;
import weblogic.application.ApplicationFactoryManager;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.interception.service;
import weblogic.jms.module.JMSDeploymentFactory;
import weblogic.jms.module.JMSModuleFactory;
import weblogic.management.ManagementException;
import weblogic.messaging.interception.exceptions.InterceptionServiceException;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;

public final class JMSServiceServerLifeCycleImpl
extends ActivatedService {
    private transient JMSService jmsService;

    public void stopService() throws ServiceFailureException {
        JMSLogger.logJMSSuspending();
        this.jmsService.stop(false);
    }

    public void haltService() throws ServiceFailureException {
        JMSLogger.logJMSForceSuspending();
        if (this.jmsService != null) {
            this.jmsService.stop(true);
        }
    }

    public boolean startService() throws ServiceFailureException {
        try {
            service.initialize();
        }
        catch (InterceptionServiceException interceptionServiceException) {
            JMSLogger.logJMSFailedInit();
            throw new ServiceFailureException("JMS service failed in initialization - registering with Interception Service", (Throwable)interceptionServiceException);
        }
        try {
            this.jmsService = JMSService.getService();
            ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
            applicationFactoryManager.addDeploymentFactory(new JMSDeploymentFactory());
            applicationFactoryManager.addWblogicModuleFactory(new JMSModuleFactory());
            this.jmsService.start();
            return true;
        }
        catch (JMSException jMSException) {
            JMSLogger.logJMSFailedInit();
            throw new ServiceFailureException("JMS service failed in initialization", (Throwable)jMSException);
        }
        catch (ManagementException managementException) {
            JMSLogger.logJMSFailedInit();
            throw new ServiceFailureException("JMS service failed in initialization", (Throwable)managementException);
        }
    }
}

