/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import weblogic.jms.adapter.JMSBaseConnection;
import weblogic.jms.adapter.JMSManagedConnection;
import weblogic.jms.adapter.JMSManagedConnectionFactory;
import weblogic.jms.bridge.AdapterConnection;
import weblogic.jms.bridge.AdapterConnectionMetaData;

public class AdapterConnectionMetaDataImpl
implements AdapterConnectionMetaData {
    private JMSManagedConnection mc;
    private JMSManagedConnectionFactory mcf;

    public AdapterConnectionMetaDataImpl(JMSManagedConnection jMSManagedConnection, JMSManagedConnectionFactory jMSManagedConnectionFactory) {
        this.mc = jMSManagedConnection;
        this.mcf = jMSManagedConnectionFactory;
    }

    public String getProductName() throws ResourceException {
        return new String("Java Messaging Service");
    }

    public String getProductVersion() throws ResourceException {
        return new String("1.0.2");
    }

    public String getUserName() throws ResourceException {
        return this.mc.getUserName();
    }

    public boolean implementsMDBTransaction() throws ResourceException {
        try {
            AdapterConnection adapterConnection = this.mc.getJMSBaseConnection();
            return ((JMSBaseConnection)adapterConnection).implementsMDBTransaction();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException(exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public boolean isXAConnection() throws ResourceException {
        try {
            AdapterConnection adapterConnection = this.mc.getJMSBaseConnection();
            return ((JMSBaseConnection)adapterConnection).isXAConnection();
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException(exception.getMessage());
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }
}

