/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

public class IsolatingClassLoader
extends URLClassLoader {
    private String m_name;
    private String[] m_isolatedPrefixes;
    private Set m_isolatedClassNames = new HashSet();

    public IsolatingClassLoader(String string, URL[] uRLArray, String[] stringArray, boolean bl) throws InvalidContextClassLoaderException {
        super(uRLArray);
        this.init(string, stringArray, bl);
    }

    public IsolatingClassLoader(String string, URL[] uRLArray, ClassLoader classLoader, String[] stringArray, boolean bl) throws InvalidContextClassLoaderException {
        super(uRLArray, classLoader);
        this.init(string, stringArray, bl);
    }

    private void init(String string, String[] stringArray, boolean bl) throws InvalidContextClassLoaderException {
        this.m_name = string;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(42);
            if (n >= 0) {
                hashSet.add(stringArray[i].substring(0, n));
                continue;
            }
            this.m_isolatedClassNames.add(stringArray[i]);
        }
        this.m_isolatedPrefixes = hashSet.toArray(new String[0]);
        if (bl) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    this.addURL(uRLArray[i]);
                }
            } else {
                throw new InvalidContextClassLoaderException("Caller classloader is not a URLClassLoader, can't automatically augument classpath.Its a " + classLoader.getClass());
            }
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        boolean bl2 = this.m_isolatedClassNames.contains(string);
        if (!bl2) {
            for (int i = 0; i < this.m_isolatedPrefixes.length; ++i) {
                if (!string.startsWith(this.m_isolatedPrefixes[i])) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                clazz = this.findClass(string);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(string, bl);
    }

    public static class InvalidContextClassLoaderException
    extends Exception {
        public InvalidContextClassLoaderException(String string) {
            super(string);
        }
    }
}

